/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.workflow.newbusiness;

import java.util.List;
import org.apache.inlong.manager.common.pojo.workflow.WorkflowApproverFilterContext;
import org.apache.inlong.manager.service.core.WorkflowApproverService;
import org.apache.inlong.manager.service.workflow.ProcessName;
import org.apache.inlong.manager.service.workflow.WorkflowDefinition;
import org.apache.inlong.manager.service.workflow.newbusiness.NewBusinessApproveForm;
import org.apache.inlong.manager.service.workflow.newbusiness.NewBusinessWorkflowForm;
import org.apache.inlong.manager.service.workflow.newbusiness.listener.ApproveCancelProcessListener;
import org.apache.inlong.manager.service.workflow.newbusiness.listener.ApprovePassTaskListener;
import org.apache.inlong.manager.service.workflow.newbusiness.listener.ApproveRejectProcessListener;
import org.apache.inlong.manager.service.workflow.newbusiness.listener.StartCreateResourceProcessListener;
import org.apache.inlong.manager.workflow.core.event.process.ProcessEventListener;
import org.apache.inlong.manager.workflow.core.event.task.TaskEventListener;
import org.apache.inlong.manager.workflow.model.definition.Element;
import org.apache.inlong.manager.workflow.model.definition.EndEvent;
import org.apache.inlong.manager.workflow.model.definition.Process;
import org.apache.inlong.manager.workflow.model.definition.StartEvent;
import org.apache.inlong.manager.workflow.model.definition.Task;
import org.apache.inlong.manager.workflow.model.definition.UserTask;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NewBusinessWorkflowDefinition
implements WorkflowDefinition {
    @Autowired
    private ApprovePassTaskListener approvePassTaskListener;
    @Autowired
    private ApproveCancelProcessListener approveCancelProcessListener;
    @Autowired
    private ApproveRejectProcessListener approveRejectProcessListener;
    @Autowired
    private StartCreateResourceProcessListener startCreateResourceProcessListener;
    @Autowired
    private WorkflowApproverService workflowApproverService;

    @Override
    public Process defineProcess() {
        Process process = new Process();
        process.setType(this.getProcessName().getDisplayName());
        process.setName(this.getProcessName().name());
        process.setDisplayName(this.getProcessName().getDisplayName());
        process.setFormClass(NewBusinessWorkflowForm.class);
        process.setVersion(1);
        process.addListener((ProcessEventListener)this.approveCancelProcessListener);
        process.addListener((ProcessEventListener)this.approveRejectProcessListener);
        process.addListener((ProcessEventListener)this.startCreateResourceProcessListener);
        StartEvent startEvent = new StartEvent();
        process.setStartEvent(startEvent);
        EndEvent endEvent = new EndEvent();
        process.setEndEvent(endEvent);
        UserTask adminUserTask = new UserTask();
        adminUserTask.setName("ut_admin");
        adminUserTask.setDisplayName("System Administrator");
        adminUserTask.setFormClass(NewBusinessApproveForm.class);
        adminUserTask.setApproverAssign(context -> this.getTaskApprovers(adminUserTask.getName()));
        adminUserTask.addListener((TaskEventListener)this.approvePassTaskListener);
        process.addTask((Task)adminUserTask);
        startEvent.addNext((Element)adminUserTask);
        adminUserTask.addNext((Element)endEvent);
        return process;
    }

    @Override
    public ProcessName getProcessName() {
        return ProcessName.NEW_BUSINESS_WORKFLOW;
    }

    private List<String> getTaskApprovers(String taskName) {
        String processName = this.getProcessName().name();
        WorkflowApproverFilterContext context = new WorkflowApproverFilterContext();
        return this.workflowApproverService.getApprovers(processName, taskName, context);
    }
}

