/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.workflow.newstream;

import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.inlong.manager.service.core.StorageService;
import org.apache.inlong.manager.service.thirdpart.hive.CreateHiveTableForOneStreamListener;
import org.apache.inlong.manager.service.thirdpart.sort.PushHiveConfigToSortEventListener;
import org.apache.inlong.manager.service.workflow.ProcessName;
import org.apache.inlong.manager.service.workflow.WorkflowDefinition;
import org.apache.inlong.manager.service.workflow.newbusiness.CreateResourceWorkflowForm;
import org.apache.inlong.manager.service.workflow.newbusiness.listener.InitBusinessInfoListener;
import org.apache.inlong.manager.service.workflow.newstream.SingleStreamCompleteProcessListener;
import org.apache.inlong.manager.service.workflow.newstream.SingleStreamFailedProcessListener;
import org.apache.inlong.manager.workflow.core.event.process.ProcessEventListener;
import org.apache.inlong.manager.workflow.core.event.task.TaskEventListener;
import org.apache.inlong.manager.workflow.model.definition.Element;
import org.apache.inlong.manager.workflow.model.definition.EndEvent;
import org.apache.inlong.manager.workflow.model.definition.Process;
import org.apache.inlong.manager.workflow.model.definition.ServiceTask;
import org.apache.inlong.manager.workflow.model.definition.StartEvent;
import org.apache.inlong.manager.workflow.model.definition.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SingleStreamWorkflowDefinition
implements WorkflowDefinition {
    private static final Logger log = LoggerFactory.getLogger(SingleStreamWorkflowDefinition.class);
    @Autowired
    private StorageService storageService;
    @Autowired
    private InitBusinessInfoListener initBusinessInfoListener;
    @Autowired
    private SingleStreamFailedProcessListener singleStreamFailedProcessListener;
    @Autowired
    private SingleStreamCompleteProcessListener singleStreamCompleteProcessListener;
    @Autowired
    private CreateHiveTableForOneStreamListener createHiveTableForOneStreamListener;
    @Autowired
    private PushHiveConfigToSortEventListener pushHiveConfigToSortEventListener;

    @Override
    public Process defineProcess() {
        Process process = new Process();
        process.addListener((ProcessEventListener)this.initBusinessInfoListener);
        process.addListener((ProcessEventListener)this.singleStreamFailedProcessListener);
        process.addListener((ProcessEventListener)this.singleStreamCompleteProcessListener);
        process.setType("Data stream access resource creation");
        process.setName(this.getProcessName().name());
        process.setDisplayName(this.getProcessName().getDisplayName());
        process.setFormClass(CreateResourceWorkflowForm.class);
        process.setVersion(1);
        process.setHidden(Boolean.valueOf(true));
        StartEvent startEvent = new StartEvent();
        process.setStartEvent(startEvent);
        EndEvent endEvent = new EndEvent();
        process.setEndEvent(endEvent);
        ServiceTask createHiveTableTask = new ServiceTask();
        createHiveTableTask.setSkipResolver(c -> {
            String dsid;
            CreateResourceWorkflowForm form = (CreateResourceWorkflowForm)c.getProcessForm();
            String bid = form.getBusinessId();
            List<String> dsForHive = this.storageService.filterStreamIdByStorageType(bid, "HIVE", Collections.singletonList(dsid = form.getDataStreamIdentifier()));
            if (CollectionUtils.isEmpty(dsForHive)) {
                log.warn("business [{}] adn data stream [{}] does not have storage, skip create hive table", (Object)bid, (Object)dsid);
                return true;
            }
            return false;
        });
        createHiveTableTask.setName("createHiveTableTask");
        createHiveTableTask.setDisplayName("Create Hive Table");
        createHiveTableTask.addListener((TaskEventListener)this.createHiveTableForOneStreamListener);
        process.addTask((Task)createHiveTableTask);
        ServiceTask pushSortConfig = new ServiceTask();
        pushSortConfig.setName("pushSortConfig");
        pushSortConfig.setDisplayName("Push Sort Configuration");
        pushSortConfig.addListener((TaskEventListener)this.pushHiveConfigToSortEventListener);
        process.addTask((Task)pushSortConfig);
        startEvent.addNext((Element)createHiveTableTask);
        createHiveTableTask.addNext((Element)pushSortConfig);
        pushSortConfig.addNext((Element)endEvent);
        return process;
    }

    @Override
    public ProcessName getProcessName() {
        return ProcessName.CREATE_DATASTREAM_RESOURCE;
    }
}

