/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.core.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.inlong.manager.common.enums.EntityStatus;
import org.apache.inlong.manager.common.enums.FileAgentDataGenerateRule;
import org.apache.inlong.manager.common.pojo.agent.AgentStatusReportRequest;
import org.apache.inlong.manager.common.pojo.agent.CheckAgentTaskConfRequest;
import org.apache.inlong.manager.common.pojo.agent.ConfirmAgentIpRequest;
import org.apache.inlong.manager.common.pojo.agent.FileAgentCMDConfig;
import org.apache.inlong.manager.common.pojo.agent.FileAgentCommandInfo;
import org.apache.inlong.manager.common.pojo.agent.FileAgentTaskConfig;
import org.apache.inlong.manager.common.pojo.agent.FileAgentTaskInfo;
import org.apache.inlong.manager.dao.entity.DataSourceCmdConfigEntity;
import org.apache.inlong.manager.dao.entity.DataStreamFieldEntity;
import org.apache.inlong.manager.dao.entity.SourceFileDetailEntity;
import org.apache.inlong.manager.dao.mapper.DataSourceCmdConfigEntityMapper;
import org.apache.inlong.manager.dao.mapper.DataStreamFieldEntityMapper;
import org.apache.inlong.manager.dao.mapper.SourceFileDetailEntityMapper;
import org.apache.inlong.manager.service.core.AgentTaskService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AgentTaskServiceImpl
implements AgentTaskService {
    private static final Logger log = LoggerFactory.getLogger(AgentTaskServiceImpl.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(AgentTaskServiceImpl.class);
    @Autowired
    private SourceFileDetailEntityMapper fileDetailMapper;
    @Autowired
    private DataSourceCmdConfigEntityMapper sourceCmdConfigMapper;
    @Autowired
    private DataStreamFieldEntityMapper streamFieldMapper;

    @Override
    public FileAgentTaskInfo getFileAgentTask(FileAgentCommandInfo info) {
        LOGGER.debug("begin to get file agent task by info={}", (Object)info);
        if (info == null || info.getAgentIp() == null) {
            LOGGER.error("agent command info cannot be empty");
            return null;
        }
        this.dealCommandResult(info);
        List<FileAgentTaskConfig> taskConfigs = this.getFileAgentTaskConfigs(info);
        List<FileAgentCMDConfig> cmdConfigs = this.getFileAgentCMDConfigs(info);
        return FileAgentTaskInfo.builder().cmdConfigs(cmdConfigs).dataConfigs(taskConfigs).build();
    }

    private List<FileAgentCMDConfig> getFileAgentCMDConfigs(FileAgentCommandInfo info) {
        return this.sourceCmdConfigMapper.queryCmdByAgentIp(info.getAgentIp()).stream().map(cmd -> {
            FileAgentCMDConfig cmdConfig = new FileAgentCMDConfig();
            cmdConfig.setDataTime(cmd.getSpecifiedDataTime());
            cmdConfig.setOp(cmd.getCmdType().intValue());
            cmdConfig.setId(cmd.getId().intValue());
            cmdConfig.setTaskId(cmd.getTaskId().intValue());
            return cmdConfig;
        }).collect(Collectors.toList());
    }

    private List<FileAgentTaskConfig> getFileAgentTaskConfigs(FileAgentCommandInfo info) {
        List taskConfigs = this.fileDetailMapper.selectFileAgentTaskByIp(info.getAgentIp());
        for (FileAgentTaskConfig config : taskConfigs) {
            FileAgentDataGenerateRule ruleEnu = FileAgentDataGenerateRule.fromRuleValue((String)config.getDataGenerateRule());
            if (ruleEnu != null) {
                config.setScheduleTime(ruleEnu.getScheduleRule());
            }
            StringBuilder s = new StringBuilder();
            s.append("m=").append(config.getSortType()).append("&");
            s.append("iname=").append(config.getInlongStreamId()).append("&");
            if (config.getDataGenerateRule().equalsIgnoreCase("minute")) {
                s.append("p=t").append("&");
            }
            List preFields = this.streamFieldMapper.selectDataStreamFields(config.getInlongGroupId(), config.getInlongStreamId());
            if (!config.getSortType().equalsIgnoreCase("13")) {
                int fIndex = 0;
                for (DataStreamFieldEntity f : preFields) {
                    s.append("__addcol" + fIndex + "__" + f.getFieldName());
                    s.append("=");
                    s.append(f.getFieldValue());
                    s.append("&");
                }
            }
            config.setAdditionalAttr(s.substring(0, s.toString().length() - 1));
        }
        return taskConfigs;
    }

    private void dealCommandResult(FileAgentCommandInfo info) {
        if (CollectionUtils.isEmpty((Collection)info.getCommandInfo())) {
            LOGGER.warn("command info is empty, just return");
            return;
        }
        for (FileAgentCommandInfo.CommandInfoBean command : info.getCommandInfo()) {
            SourceFileDetailEntity current = this.fileDetailMapper.selectByPrimaryKey(Integer.valueOf(command.getTaskId()));
            if (current == null) continue;
            int op = command.getOp();
            if (op == 2 || op == 6 || op == 8) {
                DataSourceCmdConfigEntity cmd = new DataSourceCmdConfigEntity();
                if (command.getId() <= 0) continue;
                cmd.setId(Integer.valueOf(command.getId()));
                cmd.setBsend(Boolean.valueOf(true));
                cmd.setModifyTime(new Date());
                cmd.setResultInfo(String.valueOf(command.getCommandResult()));
                this.sourceCmdConfigMapper.updateByPrimaryKeySelective(cmd);
                continue;
            }
            if (current.getModifyTime().getTime() - command.getDeliveryTime() > 5000L) {
                log.warn(" task id {} receive heartbeat time delay more than 5's, skip it!", (Object)command.getTaskId());
                continue;
            }
            int result = command.getCommandResult();
            int nextStatus = EntityStatus.AGENT_NORMAL.getCode();
            int previousStatus = current.getStatus();
            if (previousStatus / 100 != 2) continue;
            if (result == 0) {
                if (previousStatus == EntityStatus.AGENT_ADD.getCode()) {
                    nextStatus = EntityStatus.AGENT_NORMAL.getCode();
                } else if (previousStatus == EntityStatus.AGENT_DELETE.getCode()) {
                    nextStatus = EntityStatus.AGENT_DISABLE.getCode();
                }
            } else if (result == 1) {
                nextStatus = EntityStatus.AGENT_FAILURE.getCode();
            }
            SourceFileDetailEntity update = new SourceFileDetailEntity();
            update.setId(Integer.valueOf(command.getTaskId()));
            update.setStatus(Integer.valueOf(nextStatus));
            update.setPreviousStatus(Integer.valueOf(previousStatus));
            this.fileDetailMapper.updateByPrimaryKeySelective(update);
        }
    }

    @Override
    public String confirmAgentIp(ConfirmAgentIpRequest request) {
        for (String ip : request.getIpList()) {
            List taskConfigs = this.fileDetailMapper.selectFileAgentTaskByIp(ip);
            if (taskConfigs.isEmpty()) continue;
            return ((FileAgentTaskConfig)taskConfigs.get(0)).getIp();
        }
        throw new IllegalArgumentException("Do not find any agent info with the ip's in db.");
    }

    @Override
    public List<FileAgentTaskConfig> checkAgentTaskConf(CheckAgentTaskConfRequest request) {
        List taskConfigs = this.fileDetailMapper.selectFileAgentTaskByIpForCheck(request.getAgentIp());
        LOGGER.info(request.getAgentIp() + " taskConfigs = " + taskConfigs);
        List<FileAgentTaskConfig> toAdds = this.getToBeAdded(request.getTaskInfo(), taskConfigs);
        List<Integer> toRemoves = this.getToBeRemoved(request.getTaskInfo(), taskConfigs);
        List<FileAgentTaskConfig> commons = this.commons(request.getTaskInfo(), taskConfigs);
        ArrayList<FileAgentTaskConfig> result = new ArrayList<FileAgentTaskConfig>(toAdds.size() + toRemoves.size());
        for (FileAgentTaskConfig fileAgentTaskConfig : toAdds) {
            int currentStatus = fileAgentTaskConfig.getStatus();
            if (currentStatus != 100) continue;
            fileAgentTaskConfig.setOp("0");
            this.setFileAgentTaskConfigAttr(fileAgentTaskConfig);
            result.add(fileAgentTaskConfig);
        }
        for (Integer remove : toRemoves) {
            FileAgentTaskConfig config = new FileAgentTaskConfig();
            config.setOp("1");
            config.setTaskId(remove.intValue());
            result.add(config);
        }
        for (FileAgentTaskConfig fileAgentTaskConfig : commons) {
            int currentStatus = fileAgentTaskConfig.getStatus();
            if (currentStatus == 101) {
                fileAgentTaskConfig.setOp("1");
                this.setFileAgentTaskConfigAttr(fileAgentTaskConfig);
                result.add(fileAgentTaskConfig);
                continue;
            }
            if (currentStatus == 104) {
                fileAgentTaskConfig.setOp("4");
                this.setFileAgentTaskConfigAttr(fileAgentTaskConfig);
                result.add(fileAgentTaskConfig);
                continue;
            }
            LOGGER.warn("Agent {} report task id = {} with status {}, skip task id fileAgentTaskConfig = {} ", new Object[]{request.getAgentIp(), fileAgentTaskConfig.getTaskId(), currentStatus, fileAgentTaskConfig});
        }
        return result;
    }

    private void setFileAgentTaskConfigAttr(FileAgentTaskConfig config) {
        FileAgentDataGenerateRule ruleEnu = FileAgentDataGenerateRule.fromRuleValue((String)config.getDataGenerateRule());
        if (ruleEnu != null) {
            config.setScheduleTime(ruleEnu.getScheduleRule());
        }
        StringBuilder s = new StringBuilder();
        s.append("m=").append(config.getSortType()).append("&");
        s.append("iname=").append(config.getInlongStreamId()).append("&");
        if (config.getDataGenerateRule().equalsIgnoreCase("minute")) {
            s.append("p=t").append("&");
        }
        List preFields = this.streamFieldMapper.selectDataStreamFields(config.getInlongGroupId(), config.getInlongStreamId());
        if (!config.getSortType().equalsIgnoreCase("13")) {
            int fIndex = 0;
            for (DataStreamFieldEntity f : preFields) {
                s.append("__addcol" + fIndex + "__" + f.getFieldName());
                s.append("=");
                s.append(f.getFieldValue());
                s.append("&");
            }
        }
        config.setAdditionalAttr(s.substring(0, s.toString().length() - 1));
    }

    @Override
    public String reportAgentStatus(AgentStatusReportRequest request) {
        Gson gson = new GsonBuilder().create();
        LOGGER.info(gson.toJson((Object)request));
        return "Success";
    }

    private List<FileAgentTaskConfig> getToBeAdded(List<Integer> taskInfo, List<FileAgentTaskConfig> taskConfigs) {
        HashMap<Integer, FileAgentTaskConfig> all = new HashMap<Integer, FileAgentTaskConfig>();
        for (FileAgentTaskConfig config : taskConfigs) {
            all.put(config.getTaskId(), config);
        }
        for (Integer entry : taskInfo) {
            all.remove(entry);
        }
        return new ArrayList<FileAgentTaskConfig>(all.values());
    }

    private List<Integer> getToBeRemoved(List<Integer> taskInfo, List<FileAgentTaskConfig> taskConfigs) {
        ArrayList<Integer> toRemove = new ArrayList<Integer>();
        HashMap<Integer, FileAgentTaskConfig> all = new HashMap<Integer, FileAgentTaskConfig>();
        for (FileAgentTaskConfig config : taskConfigs) {
            all.put(config.getTaskId(), config);
        }
        for (Integer entry : taskInfo) {
            if (all.containsKey(entry)) continue;
            toRemove.add(entry);
        }
        return toRemove;
    }

    private List<FileAgentTaskConfig> commons(List<Integer> taskInfo, List<FileAgentTaskConfig> taskConfigs) {
        HashMap<Integer, FileAgentTaskConfig> all = new HashMap<Integer, FileAgentTaskConfig>();
        ArrayList<FileAgentTaskConfig> commons = new ArrayList<FileAgentTaskConfig>();
        for (FileAgentTaskConfig config : taskConfigs) {
            all.put(config.getTaskId(), config);
        }
        for (Integer entry : taskInfo) {
            if (!all.containsKey(entry)) continue;
            commons.add((FileAgentTaskConfig)all.get(entry));
        }
        return commons;
    }
}

