/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.core.impl;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.inlong.manager.common.beans.ClusterBean;
import org.apache.inlong.manager.common.enums.BizErrorCodeEnum;
import org.apache.inlong.manager.common.enums.EntityStatus;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.pojo.business.BusinessApproveInfo;
import org.apache.inlong.manager.common.pojo.business.BusinessCountVO;
import org.apache.inlong.manager.common.pojo.business.BusinessExtInfo;
import org.apache.inlong.manager.common.pojo.business.BusinessInfo;
import org.apache.inlong.manager.common.pojo.business.BusinessListVO;
import org.apache.inlong.manager.common.pojo.business.BusinessMqExtBase;
import org.apache.inlong.manager.common.pojo.business.BusinessPageRequest;
import org.apache.inlong.manager.common.pojo.business.BusinessPulsarInfo;
import org.apache.inlong.manager.common.pojo.business.BusinessTopicVO;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.BusinessEntity;
import org.apache.inlong.manager.dao.entity.BusinessExtEntity;
import org.apache.inlong.manager.dao.entity.BusinessPulsarEntity;
import org.apache.inlong.manager.dao.mapper.BusinessEntityMapper;
import org.apache.inlong.manager.dao.mapper.BusinessExtEntityMapper;
import org.apache.inlong.manager.dao.mapper.BusinessPulsarEntityMapper;
import org.apache.inlong.manager.service.core.BusinessService;
import org.apache.inlong.manager.service.core.DataStreamService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BusinessServiceImpl
implements BusinessService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BusinessServiceImpl.class);
    @Autowired
    BusinessPulsarEntityMapper businessPulsarMapper;
    @Autowired
    private BusinessEntityMapper businessMapper;
    @Autowired
    private BusinessExtEntityMapper businessExtMapper;
    @Autowired
    private ClusterBean clusterBean;
    @Autowired
    private DataStreamService streamService;

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public String save(BusinessInfo businessInfo, String operator) {
        LOGGER.debug("begin to save business info={}", (Object)businessInfo);
        Preconditions.checkNotNull((Object)businessInfo, (String)"business info is empty");
        String bizName = businessInfo.getName();
        Preconditions.checkNotNull((Object)bizName, (String)"business name is empty");
        String groupId = "b_" + bizName.toLowerCase(Locale.ROOT);
        Integer count = this.businessMapper.selectIdentifierExist(groupId);
        if (count >= 1) {
            LOGGER.error("groupId [{}] has already exists", (Object)groupId);
            throw new BusinessException(BizErrorCodeEnum.BUSINESS_DUPLICATE);
        }
        BusinessEntity entity = (BusinessEntity)CommonBeanUtils.copyProperties((Object)businessInfo, BusinessEntity::new);
        entity.setInlongGroupId(groupId);
        entity.setMqResourceObj(groupId);
        entity.setSchemaName("m0_day");
        entity.setStatus(EntityStatus.BIZ_WAIT_SUBMIT.getCode());
        entity.setIsDeleted(EntityStatus.UN_DELETED.getCode());
        entity.setCreator(operator);
        entity.setModifier(operator);
        entity.setCreateTime(new Date());
        this.businessMapper.insertSelective(entity);
        this.saveExt(groupId, businessInfo.getExtList());
        if ("PULSAR".equals(businessInfo.getMiddlewareType())) {
            BusinessPulsarInfo pulsarInfo = (BusinessPulsarInfo)businessInfo.getMqExtInfo();
            Preconditions.checkNotNull((Object)pulsarInfo, (String)"Pulsar info cannot be empty, as the middleware is Pulsar");
            Integer ackQuorum = pulsarInfo.getAckQuorum();
            Integer writeQuorum = pulsarInfo.getWriteQuorum();
            Preconditions.checkNotNull((Object)ackQuorum, (String)"Pulsar ackQuorum cannot be empty");
            Preconditions.checkNotNull((Object)writeQuorum, (String)"Pulsar writeQuorum cannot be empty");
            if (ackQuorum > writeQuorum) {
                throw new BusinessException(BizErrorCodeEnum.BUSINESS_SAVE_FAILED, "Pulsar params must meet: ackQuorum <= writeQuorum");
            }
            pulsarInfo.setEnsemble(writeQuorum);
            BusinessPulsarEntity pulsarEntity = this.businessPulsarMapper.selectByGroupId(groupId);
            if (pulsarEntity == null) {
                pulsarEntity = (BusinessPulsarEntity)CommonBeanUtils.copyProperties((Object)pulsarInfo, BusinessPulsarEntity::new);
                pulsarEntity.setIsDeleted(Integer.valueOf(0));
                pulsarEntity.setInlongGroupId(groupId);
                this.businessPulsarMapper.insertSelective(pulsarEntity);
            } else {
                Integer id = pulsarEntity.getId();
                pulsarEntity = (BusinessPulsarEntity)CommonBeanUtils.copyProperties((Object)pulsarInfo, BusinessPulsarEntity::new);
                pulsarEntity.setId(id);
                this.businessPulsarMapper.updateByPrimaryKeySelective(pulsarEntity);
            }
        }
        LOGGER.info("success to save business info for groupId={}", (Object)groupId);
        return groupId;
    }

    @Override
    public BusinessInfo get(String groupId) {
        LOGGER.debug("begin to get business info by groupId={}", (Object)groupId);
        Preconditions.checkNotNull((Object)groupId, (String)"business group id is empty");
        BusinessEntity entity = this.businessMapper.selectByIdentifier(groupId);
        if (entity == null) {
            LOGGER.error("business not found by groupId={}", (Object)groupId);
            throw new BusinessException(BizErrorCodeEnum.BUSINESS_NOT_FOUND);
        }
        BusinessInfo businessInfo = (BusinessInfo)CommonBeanUtils.copyProperties((Object)entity, BusinessInfo::new);
        List extEntityList = this.businessExtMapper.selectByGroupId(groupId);
        List extInfoList = CommonBeanUtils.copyListProperties((List)extEntityList, BusinessExtInfo::new);
        businessInfo.setExtList(extInfoList);
        String middlewareType = entity.getMiddlewareType();
        if ("PULSAR".equalsIgnoreCase(middlewareType)) {
            BusinessPulsarEntity pulsarEntity = this.businessPulsarMapper.selectByGroupId(groupId);
            Preconditions.checkNotNull((Object)pulsarEntity, (String)"Pulsar info not found for the Pulsar business");
            BusinessPulsarInfo pulsarInfo = (BusinessPulsarInfo)CommonBeanUtils.copyProperties((Object)pulsarEntity, BusinessPulsarInfo::new);
            businessInfo.setMqExtInfo((BusinessMqExtBase)pulsarInfo);
        }
        if (EntityStatus.BIZ_CONFIG_SUCCESSFUL.getCode().equals(businessInfo.getStatus())) {
            if ("TUBE".equalsIgnoreCase(middlewareType)) {
                businessInfo.setTubeMaster(this.clusterBean.getTubeMaster());
            } else if ("PULSAR".equalsIgnoreCase(middlewareType)) {
                businessInfo.setPulsarAdminUrl(this.clusterBean.getPulsarAdminUrl());
                businessInfo.setPulsarServiceUrl(this.clusterBean.getPulsarServiceUrl());
            }
        }
        LOGGER.info("success to get business info for groupId={}", (Object)groupId);
        return businessInfo;
    }

    @Override
    public PageInfo<BusinessListVO> listByCondition(BusinessPageRequest request) {
        LOGGER.debug("begin to list business info by {}", (Object)request);
        PageHelper.startPage((int)request.getPageNum(), (int)request.getPageSize());
        Page entityPage = (Page)this.businessMapper.selectByCondition(request);
        List businessList = CommonBeanUtils.copyListProperties((List)entityPage, BusinessListVO::new);
        PageInfo page = new PageInfo(businessList);
        page.setTotal(entityPage.getTotal());
        LOGGER.info("success to list business info");
        return page;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public String update(BusinessInfo businessInfo, String operator) {
        LOGGER.debug("begin to update business info={}", (Object)businessInfo);
        Preconditions.checkNotNull((Object)businessInfo, (String)"business info is empty");
        String groupId = businessInfo.getInlongGroupId();
        Preconditions.checkNotNull((Object)groupId, (String)"business group id is empty");
        BusinessEntity entity = this.businessMapper.selectByIdentifier(groupId);
        if (entity == null) {
            LOGGER.error("business not found by groupId={}", (Object)groupId);
            throw new BusinessException(BizErrorCodeEnum.BUSINESS_NOT_FOUND);
        }
        this.checkBizCanUpdate(entity, businessInfo);
        CommonBeanUtils.copyProperties((Object)businessInfo, (Object)entity, (boolean)true);
        if (EntityStatus.BIZ_CONFIG_FAILED.getCode().equals(entity.getStatus())) {
            entity.setStatus(EntityStatus.BIZ_WAIT_SUBMIT.getCode());
        }
        entity.setModifier(operator);
        this.businessMapper.updateByIdentifierSelective(entity);
        this.updateExt(groupId, businessInfo.getExtList());
        if ("PULSAR".equals(businessInfo.getMiddlewareType())) {
            BusinessPulsarInfo pulsarInfo = (BusinessPulsarInfo)businessInfo.getMqExtInfo();
            Preconditions.checkNotNull((Object)pulsarInfo, (String)"Pulsar info cannot be empty, as the middleware is Pulsar");
            Integer writeQuorum = pulsarInfo.getWriteQuorum();
            Integer ackQuorum = pulsarInfo.getAckQuorum();
            if (ackQuorum > writeQuorum) {
                throw new BusinessException(BizErrorCodeEnum.BUSINESS_SAVE_FAILED, "Pulsar params must meet: ackQuorum <= writeQuorum");
            }
            BusinessPulsarEntity pulsarEntity = (BusinessPulsarEntity)CommonBeanUtils.copyProperties((Object)pulsarInfo, BusinessPulsarEntity::new);
            pulsarEntity.setInlongGroupId(groupId);
            this.businessPulsarMapper.updateByIdentifierSelective(pulsarEntity);
        }
        LOGGER.info("success to update business info for groupId={}", (Object)groupId);
        return groupId;
    }

    private void checkBizCanUpdate(BusinessEntity entity, BusinessInfo businessInfo) {
        boolean updateGroupId;
        if (entity == null || businessInfo == null) {
            return;
        }
        Integer oldStatus = entity.getStatus();
        if (!EntityStatus.ALLOW_UPDATE_BIZ_STATUS.contains(oldStatus)) {
            LOGGER.error("current status was not allowed to update");
            throw new BusinessException(BizErrorCodeEnum.BUSINESS_UPDATE_NOT_ALLOWED);
        }
        boolean bl = updateGroupId = !EntityStatus.DRAFT.getCode().equals(oldStatus) && !Objects.equals(entity.getInlongGroupId(), businessInfo.getInlongGroupId());
        if (updateGroupId) {
            LOGGER.error("current status was not allowed to update business group id");
            throw new BusinessException(BizErrorCodeEnum.BUSINESS_GROUP_ID_UPDATE_NOT_ALLOWED);
        }
        if (EntityStatus.BIZ_CONFIG_SUCCESSFUL.getCode().equals(oldStatus)) {
            if (!Objects.equals(entity.getInlongGroupId(), businessInfo.getInlongGroupId())) {
                LOGGER.error("current status was not allowed to update business group id");
                throw new BusinessException(BizErrorCodeEnum.BUSINESS_GROUP_ID_UPDATE_NOT_ALLOWED);
            }
            if (!Objects.equals(entity.getMiddlewareType(), businessInfo.getMiddlewareType())) {
                LOGGER.error("current status was not allowed to update middleware type");
                throw new BusinessException(BizErrorCodeEnum.BUSINESS_MIDDLEWARE_UPDATE_NOT_ALLOWED);
            }
        }
    }

    @Override
    public boolean updateStatus(String groupId, Integer status, String operator) {
        LOGGER.debug("begin to update business status, groupId={}, status={}, username={}", new Object[]{groupId, status, operator});
        Preconditions.checkNotNull((Object)groupId, (String)"business group id is empty");
        this.businessMapper.updateStatusByIdentifier(groupId, status, operator);
        LOGGER.info("success to update business status for groupId={}", (Object)groupId);
        return true;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public boolean delete(String groupId, String operator) {
        LOGGER.debug("begin to delete business, groupId={}", (Object)groupId);
        Preconditions.checkNotNull((Object)groupId, (String)"business group id is empty");
        BusinessEntity entity = this.businessMapper.selectByIdentifier(groupId);
        if (entity == null) {
            LOGGER.error("business not found by groupId={}", (Object)groupId);
            throw new BusinessException(BizErrorCodeEnum.BUSINESS_NOT_FOUND);
        }
        if (!EntityStatus.ALLOW_DELETE_BIZ_STATUS.contains(entity.getStatus())) {
            LOGGER.error("current status was not allowed to delete");
            throw new BusinessException(BizErrorCodeEnum.BUSINESS_DELETE_NOT_ALLOWED);
        }
        if (EntityStatus.ALLOW_DELETE_BIZ_CASCADE_STATUS.contains(entity.getStatus())) {
            this.streamService.logicDeleteAll(entity.getInlongGroupId(), operator);
        } else {
            int count = this.streamService.selectCountByGroupId(groupId);
            if (count >= 1) {
                LOGGER.error("groupId={} have [{}] data streams, deleted failed", (Object)groupId, (Object)count);
                throw new BusinessException(BizErrorCodeEnum.BUSINESS_HAS_DATA_STREAM);
            }
        }
        entity.setIsDeleted(EntityStatus.IS_DELETED.getCode());
        entity.setStatus(EntityStatus.DELETED.getCode());
        entity.setModifier(operator);
        this.businessMapper.updateByIdentifierSelective(entity);
        this.businessExtMapper.logicDeleteAllByGroupId(groupId);
        this.businessPulsarMapper.logicDeleteByGroupId(groupId);
        LOGGER.info("success to delete business and business ext property for groupId={}", (Object)groupId);
        return true;
    }

    @Override
    public boolean exist(String groupId) {
        LOGGER.debug("begin to check business, groupId={}", (Object)groupId);
        Preconditions.checkNotNull((Object)groupId, (String)"business group id is empty");
        Integer count = this.businessMapper.selectIdentifierExist(groupId);
        LOGGER.info("success to check business");
        return count >= 1;
    }

    @Override
    public BusinessCountVO countBusinessByUser(String operator) {
        LOGGER.debug("begin to count business by user={}", (Object)operator);
        BusinessCountVO countVO = new BusinessCountVO();
        List statusCount = this.businessMapper.countCurrentUserBusiness(operator);
        for (Map map : statusCount) {
            int status = (Integer)map.get("status");
            long count = (Long)map.get("count");
            countVO.setTotalCount(countVO.getTotalCount() + count);
            if (status == EntityStatus.BIZ_CONFIG_ING.getCode()) {
                countVO.setWaitAssignCount(countVO.getWaitAssignCount() + count);
                continue;
            }
            if (status == EntityStatus.BIZ_WAIT_APPROVAL.getCode()) {
                countVO.setWaitApproveCount(countVO.getWaitApproveCount() + count);
                continue;
            }
            if (status != EntityStatus.BIZ_APPROVE_REJECTED.getCode()) continue;
            countVO.setRejectCount(countVO.getRejectCount() + count);
        }
        LOGGER.info("success to count business for operator={}", (Object)operator);
        return countVO;
    }

    @Override
    public BusinessTopicVO getTopic(String groupId) {
        LOGGER.debug("begin to get topic by groupId={}", (Object)groupId);
        BusinessInfo businessInfo = this.get(groupId);
        String middlewareType = businessInfo.getMiddlewareType();
        BusinessTopicVO topicVO = new BusinessTopicVO();
        if ("TUBE".equalsIgnoreCase(middlewareType)) {
            topicVO.setMqResourceObj(businessInfo.getMqResourceObj());
            topicVO.setTubeMasterUrl(this.clusterBean.getTubeMaster());
        } else if ("PULSAR".equalsIgnoreCase(middlewareType)) {
            topicVO.setDsTopicList(this.streamService.getTopicList(groupId));
            topicVO.setPulsarAdminUrl(this.clusterBean.getPulsarAdminUrl());
            topicVO.setPulsarServiceUrl(this.clusterBean.getPulsarServiceUrl());
        } else {
            LOGGER.error("middleware type={} not supported", (Object)middlewareType);
            throw new BusinessException(BizErrorCodeEnum.MIDDLEWARE_TYPE_NOT_SUPPORTED);
        }
        topicVO.setInlongGroupId(groupId);
        topicVO.setMiddlewareType(middlewareType);
        return topicVO;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public boolean updateAfterApprove(BusinessApproveInfo approveInfo, String operator) {
        LOGGER.debug("begin to update business after approve={}", (Object)approveInfo);
        Preconditions.checkNotNull((Object)approveInfo, (String)"BusinessApproveInfo is empty");
        String groupId = approveInfo.getInlongGroupId();
        Preconditions.checkNotNull((Object)groupId, (String)"business group id is empty");
        String middlewareType = approveInfo.getMiddlewareType();
        Preconditions.checkNotNull((Object)middlewareType, (String)"Middleware type is empty");
        this.updateStatus(groupId, EntityStatus.BIZ_CONFIG_ING.getCode(), operator);
        LOGGER.info("success to update business status after approve for groupId={}", (Object)groupId);
        return true;
    }

    @Transactional(rollbackFor={Throwable.class})
    void updateExt(String groupId, List<BusinessExtInfo> extInfoList) {
        LOGGER.debug("begin to update business ext, groupId={}, ext={}", (Object)groupId, extInfoList);
        try {
            this.businessExtMapper.deleteAllByGroupId(groupId);
            this.saveExt(groupId, extInfoList);
            LOGGER.info("success to update business ext");
        }
        catch (Exception e) {
            LOGGER.error("failed to update business ext: ", (Throwable)e);
            throw new BusinessException(BizErrorCodeEnum.BUSINESS_SAVE_FAILED);
        }
    }

    @Transactional(rollbackFor={Throwable.class})
    void saveExt(String groupId, List<BusinessExtInfo> infoList) {
        if (CollectionUtils.isEmpty(infoList)) {
            return;
        }
        List entityList = CommonBeanUtils.copyListProperties(infoList, BusinessExtEntity::new);
        Date date = new Date();
        for (BusinessExtEntity entity : entityList) {
            entity.setInlongGroupId(groupId);
            entity.setModifyTime(date);
        }
        this.businessExtMapper.insertAll(entityList);
    }
}

