/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.core.impl;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.inlong.manager.common.enums.BizErrorCodeEnum;
import org.apache.inlong.manager.common.enums.EntityStatus;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.pojo.datasource.SourceDbBasicInfo;
import org.apache.inlong.manager.common.pojo.datasource.SourceDbDetailInfo;
import org.apache.inlong.manager.common.pojo.datasource.SourceDbDetailListVO;
import org.apache.inlong.manager.common.pojo.datasource.SourceDbDetailPageRequest;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.BusinessEntity;
import org.apache.inlong.manager.dao.entity.SourceDbBasicEntity;
import org.apache.inlong.manager.dao.entity.SourceDbDetailEntity;
import org.apache.inlong.manager.dao.mapper.BusinessEntityMapper;
import org.apache.inlong.manager.dao.mapper.SourceDbBasicEntityMapper;
import org.apache.inlong.manager.dao.mapper.SourceDbDetailEntityMapper;
import org.apache.inlong.manager.service.core.SourceDbService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SourceDbServiceImpl
implements SourceDbService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SourceDbServiceImpl.class);
    @Autowired
    private SourceDbBasicEntityMapper dbBasicMapper;
    @Autowired
    private SourceDbDetailEntityMapper dbDetailMapper;
    @Autowired
    private BusinessEntityMapper businessMapper;

    @Override
    public Integer saveBasic(SourceDbBasicInfo basicInfo, String operator) {
        LOGGER.info("begin to save db data source basic={}", (Object)basicInfo);
        Preconditions.checkNotNull((Object)basicInfo, (String)"db data source basic");
        String groupId = basicInfo.getInlongGroupId();
        String streamId = basicInfo.getInlongStreamId();
        Preconditions.checkNotNull((Object)groupId, (String)"business group id is empty");
        Preconditions.checkNotNull((Object)streamId, (String)"data stream id is empty");
        this.checkBizIsTempStatus(groupId);
        SourceDbBasicEntity exist = this.dbBasicMapper.selectByIdentifier(groupId, streamId);
        if (exist != null) {
            LOGGER.error("db data source basic already exists");
            throw new BusinessException(BizErrorCodeEnum.DATA_SOURCE_DUPLICATE);
        }
        SourceDbBasicEntity entity = (SourceDbBasicEntity)CommonBeanUtils.copyProperties((Object)basicInfo, SourceDbBasicEntity::new);
        entity.setCreator(operator);
        entity.setModifier(operator);
        entity.setCreateTime(new Date());
        this.dbBasicMapper.insertSelective(entity);
        LOGGER.info("success to save db data source basic");
        return entity.getId();
    }

    @Override
    public SourceDbBasicInfo getBasicByIdentifier(String groupId, String streamId) {
        LOGGER.info("begin to get db data source basic by groupId={}, streamId={}", (Object)groupId, (Object)streamId);
        Preconditions.checkNotNull((Object)groupId, (String)"business group id is empty");
        Preconditions.checkNotNull((Object)streamId, (String)"data stream id is empty");
        SourceDbBasicEntity entity = this.dbBasicMapper.selectByIdentifier(groupId, streamId);
        SourceDbBasicInfo basicInfo = new SourceDbBasicInfo();
        if (entity == null) {
            LOGGER.error("file data source basic not found by streamId={}", (Object)streamId);
            return basicInfo;
        }
        BeanUtils.copyProperties((Object)entity, (Object)basicInfo);
        LOGGER.info("success to get db data source basic");
        return basicInfo;
    }

    @Override
    public boolean updateBasic(SourceDbBasicInfo basicInfo, String operator) {
        LOGGER.info("begin to update db data source basic={}", (Object)basicInfo);
        Preconditions.checkNotNull((Object)basicInfo, (String)"db data source basic is empty");
        this.checkBizIsTempStatus(basicInfo.getInlongGroupId());
        if (basicInfo.getId() == null) {
            this.saveBasic(basicInfo, operator);
        } else {
            SourceDbBasicEntity basicEntity = this.dbBasicMapper.selectByPrimaryKey(basicInfo.getId());
            if (basicEntity == null) {
                LOGGER.error("db data source basic not found by id={}, update failed", (Object)basicInfo.getId());
                throw new BusinessException(BizErrorCodeEnum.DATA_SOURCE_BASIC_NOT_FOUND);
            }
            BeanUtils.copyProperties((Object)basicInfo, (Object)basicEntity);
            basicEntity.setModifier(operator);
            this.dbBasicMapper.updateByPrimaryKeySelective(basicEntity);
        }
        LOGGER.info("success to update db data source basic");
        return true;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public boolean logicDeleteBasic(Integer id, String operator) {
        LOGGER.info("begin to delete db data source basic, id={}", (Object)id);
        Preconditions.checkNotNull((Object)id, (String)"db data source basic's id is null");
        SourceDbBasicEntity entity = this.dbBasicMapper.selectByPrimaryKey(id);
        if (entity == null) {
            LOGGER.error("db data source basic not found by id={}, delete failed", (Object)id);
            throw new BusinessException(BizErrorCodeEnum.DATA_SOURCE_BASIC_NOT_FOUND);
        }
        String groupId = entity.getInlongGroupId();
        String streamId = entity.getInlongStreamId();
        this.checkBizIsTempStatus(groupId);
        List detailEntities = this.dbDetailMapper.selectByIdentifier(groupId, streamId);
        if (CollectionUtils.isNotEmpty((Collection)detailEntities)) {
            LOGGER.error("the data source basic have [{}] details, delete failed", (Object)detailEntities.size());
            throw new BusinessException(BizErrorCodeEnum.DATA_SOURCE_BASIC_DELETE_HAS_DETAIL);
        }
        entity.setIsDeleted(Integer.valueOf(1));
        entity.setModifier(operator);
        int resultCount = this.dbBasicMapper.updateByPrimaryKey(entity);
        LOGGER.info("success to delete db data source basic");
        return resultCount >= 0;
    }

    @Override
    public Integer saveDetail(SourceDbDetailInfo detailInfo, String operator) {
        LOGGER.info("begin to save db data source detail={}", (Object)detailInfo);
        Preconditions.checkNotNull((Object)detailInfo, (String)"db data source basic is null");
        Preconditions.checkNotNull((Object)detailInfo.getInlongGroupId(), (String)"business group id is empty");
        Preconditions.checkNotNull((Object)detailInfo.getInlongStreamId(), (String)"data stream id is empty");
        this.checkBizIsTempStatus(detailInfo.getInlongGroupId());
        int id = this.saveDetailOpt(detailInfo, operator);
        LOGGER.info("success to save db data source detail");
        return id;
    }

    @Override
    public SourceDbDetailInfo getDetailById(Integer id) {
        LOGGER.info("begin to get db data source detail by id={}", (Object)id);
        Preconditions.checkNotNull((Object)id, (String)"db data source detail's id is null");
        SourceDbDetailEntity entity = this.dbDetailMapper.selectByPrimaryKey(id);
        if (entity == null) {
            LOGGER.error("db data source detail not found by id={}", (Object)id);
            throw new BusinessException(BizErrorCodeEnum.DATA_SOURCE_DETAIL_NOT_FOUND);
        }
        SourceDbDetailInfo detailInfo = (SourceDbDetailInfo)CommonBeanUtils.copyProperties((Object)entity, SourceDbDetailInfo::new);
        LOGGER.info("success to get db data source detail");
        return detailInfo;
    }

    @Override
    public List<SourceDbDetailInfo> listDetailByIdentifier(String groupId, String streamId) {
        LOGGER.info("begin to list db data source detail by groupId={}, streamId={}", (Object)groupId, (Object)streamId);
        Preconditions.checkNotNull((Object)groupId, (String)"business group id is empty");
        List entities = this.dbDetailMapper.selectByIdentifier(groupId, streamId);
        if (CollectionUtils.isEmpty((Collection)entities)) {
            LOGGER.error("db data source detail not found");
            return Collections.emptyList();
        }
        List infoList = CommonBeanUtils.copyListProperties((List)entities, SourceDbDetailInfo::new);
        LOGGER.info("success to list db data source detail");
        return infoList;
    }

    @Override
    public PageInfo<SourceDbDetailListVO> listByCondition(SourceDbDetailPageRequest request) {
        LOGGER.info("begin to list db data source detail page by {}", (Object)request);
        PageHelper.startPage((int)request.getPageNum(), (int)request.getPageSize());
        Page entityPage = (Page)this.dbDetailMapper.selectByCondition(request);
        List detailList = CommonBeanUtils.copyListProperties((List)entityPage, SourceDbDetailListVO::new);
        PageInfo page = new PageInfo(detailList);
        page.setTotal(entityPage.getTotal());
        LOGGER.info("success to list db data source detail");
        return page;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public boolean updateDetail(SourceDbDetailInfo detailInfo, String operator) {
        LOGGER.info("begin to update db data source detail={}", (Object)detailInfo);
        Preconditions.checkNotNull((Object)detailInfo, (String)"db data source detail is empty");
        Preconditions.checkNotNull((Object)detailInfo.getInlongGroupId(), (String)"business group id is empty");
        Preconditions.checkNotNull((Object)detailInfo.getInlongStreamId(), (String)"data stream id is empty");
        this.checkBizIsTempStatus(detailInfo.getInlongGroupId());
        if (detailInfo.getId() != null) {
            SourceDbDetailEntity entity = this.dbDetailMapper.selectByPrimaryKey(detailInfo.getId());
            if (entity == null) {
                LOGGER.error("db data source detail not found by id=" + detailInfo.getId());
                throw new BusinessException(BizErrorCodeEnum.DATA_SOURCE_DETAIL_NOT_FOUND);
            }
            SourceDbDetailEntity dbEntity = (SourceDbDetailEntity)CommonBeanUtils.copyProperties((Object)detailInfo, SourceDbDetailEntity::new);
            dbEntity.setStatus(EntityStatus.BIZ_CONFIG_ING.getCode());
            dbEntity.setModifier(operator);
            this.dbDetailMapper.updateByPrimaryKeySelective(dbEntity);
        } else {
            this.saveDetailOpt(detailInfo, operator);
        }
        LOGGER.info("success to update db data source detail");
        return true;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public boolean logicDeleteDetail(Integer id, String operator) {
        LOGGER.info("begin to delete db data source detail, id={}", (Object)id);
        Preconditions.checkNotNull((Object)id, (String)"db data source detail's id is null");
        SourceDbDetailEntity entity = this.dbDetailMapper.selectByPrimaryKey(id);
        if (entity == null) {
            LOGGER.error("db data source detail not found by id={}", (Object)id);
            throw new BusinessException(BizErrorCodeEnum.DATA_SOURCE_DETAIL_NOT_FOUND);
        }
        this.checkBizIsTempStatus(entity.getInlongGroupId());
        entity.setIsDeleted(Integer.valueOf(1));
        entity.setModifier(operator);
        int resultCount = this.dbDetailMapper.updateByPrimaryKey(entity);
        LOGGER.info("success to delete db data source detail");
        return resultCount >= 0;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public boolean deleteAllByIdentifier(String groupId, String streamId) {
        LOGGER.info("begin delete all db basic and detail by groupId={}, streamId={}", (Object)groupId, (Object)streamId);
        Preconditions.checkNotNull((Object)groupId, (String)"business group id is empty");
        Preconditions.checkNotNull((Object)streamId, (String)"data stream id is empty");
        this.checkBizIsTempStatus(groupId);
        this.dbBasicMapper.deleteByIdentifier(groupId, streamId);
        this.dbDetailMapper.deleteByIdentifier(groupId, streamId);
        LOGGER.info("success delete all db basic and detail");
        return true;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public boolean logicDeleteAllByIdentifier(String groupId, String streamId, String operator) {
        LOGGER.info("begin logic delete all db basic and detail by groupId={}, streamId={}", (Object)groupId, (Object)streamId);
        Preconditions.checkNotNull((Object)groupId, (String)"business group id is empty");
        Preconditions.checkNotNull((Object)streamId, (String)"data stream id is empty");
        this.checkBizIsTempStatus(groupId);
        this.dbBasicMapper.logicDeleteByIdentifier(groupId, streamId, operator);
        this.dbDetailMapper.logicDeleteByIdentifier(groupId, streamId, operator);
        LOGGER.info("success logic delete all db basic and detail");
        return true;
    }

    @Transactional(rollbackFor={Throwable.class})
    int saveDetailOpt(SourceDbDetailInfo detailInfo, String operator) {
        String connectionName;
        String dbName;
        String streamId;
        String groupId = detailInfo.getInlongGroupId();
        Integer count = this.dbDetailMapper.selectDetailExist(groupId, streamId = detailInfo.getInlongStreamId(), dbName = detailInfo.getDbName(), connectionName = detailInfo.getConnectionName());
        if (count > 0) {
            LOGGER.error("db source detail already exists, groupId={}, streamId={}, dbName={}, connectionName={}", new Object[]{groupId, streamId, dbName, connectionName});
            throw new BusinessException(BizErrorCodeEnum.DATA_SOURCE_DUPLICATE);
        }
        SourceDbDetailEntity dbEntity = (SourceDbDetailEntity)CommonBeanUtils.copyProperties((Object)detailInfo, SourceDbDetailEntity::new);
        dbEntity.setStatus(EntityStatus.AGENT_ADD.getCode());
        dbEntity.setCreator(operator);
        dbEntity.setModifier(operator);
        dbEntity.setCreateTime(new Date());
        this.dbDetailMapper.insertSelective(dbEntity);
        return dbEntity.getId();
    }

    private BusinessEntity checkBizIsTempStatus(String groupId) {
        BusinessEntity businessEntity = this.businessMapper.selectByIdentifier(groupId);
        Preconditions.checkNotNull((Object)businessEntity, (String)"groupId is invalid");
        if (EntityStatus.BIZ_TEMP_STATUS.contains((Object)businessEntity.getStatus())) {
            LOGGER.error("business status was not allowed to add/update/delete data source info");
            throw new BusinessException(BizErrorCodeEnum.DATA_SOURCE_OPT_NOT_ALLOWED);
        }
        return businessEntity;
    }
}

