/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.core.impl;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.inlong.manager.common.enums.BizErrorCodeEnum;
import org.apache.inlong.manager.common.enums.EntityStatus;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.pojo.datasource.SourceFileBasicInfo;
import org.apache.inlong.manager.common.pojo.datasource.SourceFileDetailInfo;
import org.apache.inlong.manager.common.pojo.datasource.SourceFileDetailListVO;
import org.apache.inlong.manager.common.pojo.datasource.SourceFileDetailPageRequest;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.BusinessEntity;
import org.apache.inlong.manager.dao.entity.SourceFileBasicEntity;
import org.apache.inlong.manager.dao.entity.SourceFileDetailEntity;
import org.apache.inlong.manager.dao.mapper.BusinessEntityMapper;
import org.apache.inlong.manager.dao.mapper.SourceFileBasicEntityMapper;
import org.apache.inlong.manager.dao.mapper.SourceFileDetailEntityMapper;
import org.apache.inlong.manager.service.core.SourceFileService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SourceFileServiceImpl
implements SourceFileService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SourceFileServiceImpl.class);
    @Autowired
    private SourceFileBasicEntityMapper fileBasicMapper;
    @Autowired
    private SourceFileDetailEntityMapper fileDetailMapper;
    @Autowired
    private BusinessEntityMapper businessMapper;

    @Override
    public Integer saveBasic(SourceFileBasicInfo basicInfo, String operator) {
        LOGGER.info("begin to save file data source basic={}", (Object)basicInfo);
        Preconditions.checkNotNull((Object)basicInfo, (String)"file data source basic is empty");
        String groupId = basicInfo.getInlongGroupId();
        String streamId = basicInfo.getInlongStreamId();
        Preconditions.checkNotNull((Object)groupId, (String)"business group id is empty");
        Preconditions.checkNotNull((Object)streamId, (String)"data stream id is empty");
        this.checkBizIsTempStatus(groupId);
        SourceFileBasicEntity exist = this.fileBasicMapper.selectByIdentifier(groupId, streamId);
        if (exist != null) {
            LOGGER.error("file data source basic already exists, please check");
            throw new BusinessException(BizErrorCodeEnum.DATA_SOURCE_DUPLICATE);
        }
        SourceFileBasicEntity entity = (SourceFileBasicEntity)CommonBeanUtils.copyProperties((Object)basicInfo, SourceFileBasicEntity::new);
        entity.setCreator(operator);
        entity.setModifier(operator);
        entity.setCreateTime(new Date());
        this.fileBasicMapper.insertSelective(entity);
        LOGGER.info("success to save file data source basic");
        return entity.getId();
    }

    @Override
    public SourceFileBasicInfo getBasicByIdentifier(String groupId, String streamId) {
        LOGGER.info("begin to get file data source basic by groupId={}, streamId={}", (Object)groupId, (Object)streamId);
        Preconditions.checkNotNull((Object)groupId, (String)"business group id is empty");
        Preconditions.checkNotNull((Object)streamId, (String)"data stream id is empty");
        SourceFileBasicEntity entity = this.fileBasicMapper.selectByIdentifier(groupId, streamId);
        SourceFileBasicInfo basicInfo = new SourceFileBasicInfo();
        if (entity == null) {
            LOGGER.error("file data source basic not found by streamId={}", (Object)streamId);
            return basicInfo;
        }
        CommonBeanUtils.copyProperties((Object)entity, (Object)basicInfo);
        LOGGER.info("success to get file data source basic");
        return basicInfo;
    }

    @Override
    public boolean updateBasic(SourceFileBasicInfo basicInfo, String operator) {
        LOGGER.info("begin to update file data source basic={}", (Object)basicInfo);
        Preconditions.checkNotNull((Object)basicInfo, (String)"file data source basic is empty");
        this.checkBizIsTempStatus(basicInfo.getInlongGroupId());
        if (basicInfo.getId() == null) {
            this.saveBasic(basicInfo, operator);
        } else {
            SourceFileBasicEntity basicEntity = this.fileBasicMapper.selectByPrimaryKey(basicInfo.getId());
            if (basicEntity == null) {
                LOGGER.error("file data source basic not found by id={}, update failed", (Object)basicInfo.getId());
                throw new BusinessException(BizErrorCodeEnum.DATA_SOURCE_BASIC_NOT_FOUND);
            }
            BeanUtils.copyProperties((Object)basicInfo, (Object)basicEntity);
            basicEntity.setModifier(operator);
            this.fileBasicMapper.updateByPrimaryKeySelective(basicEntity);
        }
        LOGGER.info("success to update file data source basic");
        return true;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public boolean logicDeleteBasic(Integer id, String operator) {
        LOGGER.info("begin to delete file data source basic, id={}", (Object)id);
        Preconditions.checkNotNull((Object)id, (String)"file data source basic's id is null");
        SourceFileBasicEntity entity = this.fileBasicMapper.selectByPrimaryKey(id);
        if (entity == null) {
            LOGGER.error("file data source basic not found by id={}, delete failed", (Object)id);
            throw new BusinessException(BizErrorCodeEnum.DATA_SOURCE_BASIC_NOT_FOUND);
        }
        String groupId = entity.getInlongGroupId();
        String streamId = entity.getInlongStreamId();
        this.checkBizIsTempStatus(groupId);
        List detailEntities = this.fileDetailMapper.selectByIdentifier(groupId, streamId);
        if (CollectionUtils.isNotEmpty((Collection)detailEntities)) {
            LOGGER.error("the data source basic have [{}] details, delete failed", (Object)detailEntities.size());
            throw new BusinessException(BizErrorCodeEnum.DATA_SOURCE_BASIC_DELETE_HAS_DETAIL);
        }
        entity.setIsDeleted(Integer.valueOf(1));
        entity.setModifier(operator);
        int resultCount = this.fileBasicMapper.updateByPrimaryKey(entity);
        LOGGER.info("success to delete file data source basic");
        return resultCount >= 0;
    }

    @Override
    public Integer saveDetail(SourceFileDetailInfo detailInfo, String operator) {
        LOGGER.info("begin to save file data source detail={}", (Object)detailInfo);
        Preconditions.checkNotNull((Object)detailInfo, (String)"file data source detail is empty");
        Preconditions.checkNotNull((Object)detailInfo.getInlongGroupId(), (String)"business group id is empty");
        Preconditions.checkNotNull((Object)detailInfo.getInlongStreamId(), (String)"data stream id is empty");
        BusinessEntity businessEntity = this.checkBizIsTempStatus(detailInfo.getInlongGroupId());
        String groupId = detailInfo.getInlongGroupId();
        String streamId = detailInfo.getInlongStreamId();
        String ip = detailInfo.getIp();
        String username = detailInfo.getUsername();
        Integer count = this.fileDetailMapper.selectDetailExist(groupId, streamId, ip, username);
        if (count > 0) {
            LOGGER.error("file data source already exists: groupId=" + groupId + ", streamId=" + streamId + ", ip=" + ip + ", username=" + username);
            throw new BusinessException(BizErrorCodeEnum.DATA_SOURCE_DUPLICATE);
        }
        detailInfo.setStatus(EntityStatus.AGENT_ADD.getCode());
        SourceFileDetailEntity detailEntity = (SourceFileDetailEntity)CommonBeanUtils.copyProperties((Object)detailInfo, SourceFileDetailEntity::new);
        detailEntity.setCreator(operator);
        detailEntity.setModifier(operator);
        Date now = new Date();
        detailEntity.setCreateTime(now);
        detailEntity.setModifyTime(now);
        this.fileDetailMapper.insertSelective(detailEntity);
        LOGGER.info("success to save file data source detail");
        return detailEntity.getId();
    }

    @Override
    public SourceFileDetailInfo getDetailById(Integer id) {
        LOGGER.info("begin to get file data source detail by id={}", (Object)id);
        Preconditions.checkNotNull((Object)id, (String)"file data source detail's id is null");
        SourceFileDetailEntity entity = this.fileDetailMapper.selectByPrimaryKey(id);
        if (entity == null) {
            LOGGER.error("file data source detail not found by id={}", (Object)id);
            throw new BusinessException(BizErrorCodeEnum.DATA_SOURCE_DETAIL_NOT_FOUND);
        }
        SourceFileDetailInfo detailInfo = (SourceFileDetailInfo)CommonBeanUtils.copyProperties((Object)entity, SourceFileDetailInfo::new);
        LOGGER.info("success to get file data source detail");
        return detailInfo;
    }

    @Override
    public List<SourceFileDetailInfo> listDetailByIdentifier(String groupId, String streamId) {
        LOGGER.info("begin list file data source detail by groupId={}, streamId={}", (Object)groupId, (Object)streamId);
        Preconditions.checkNotNull((Object)groupId, (String)"business group id is empty");
        List entities = this.fileDetailMapper.selectByIdentifier(groupId, streamId);
        if (CollectionUtils.isEmpty((Collection)entities)) {
            LOGGER.error("file data source detail not found");
            return Collections.emptyList();
        }
        List infoList = CommonBeanUtils.copyListProperties((List)entities, SourceFileDetailInfo::new);
        LOGGER.info("success to list file data source detail");
        return infoList;
    }

    @Override
    public PageInfo<SourceFileDetailListVO> listByCondition(SourceFileDetailPageRequest request) {
        LOGGER.info("begin to list file data source detail page by {}", (Object)request);
        PageHelper.startPage((int)request.getPageNum(), (int)request.getPageSize());
        Page page = (Page)this.fileDetailMapper.selectByCondition(request);
        List detailList = CommonBeanUtils.copyListProperties((List)page, SourceFileDetailListVO::new);
        PageInfo pageInfo = new PageInfo(detailList);
        pageInfo.setTotal(page.getTotal());
        LOGGER.info("success to list file data source detail");
        return pageInfo;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public boolean updateDetail(SourceFileDetailInfo detailInfo, String operator) {
        LOGGER.info("begin to update file data source detail={}", (Object)detailInfo);
        Preconditions.checkNotNull((Object)detailInfo, (String)"file data source detail is empty");
        Integer id = detailInfo.getId();
        Preconditions.checkNotNull((Object)id, (String)"id cannot empty during the update/delete operation");
        SourceFileDetailEntity entity = this.fileDetailMapper.selectByPrimaryKey(id);
        if (entity == null) {
            LOGGER.error("file data source detail not found by id=" + id);
            throw new BusinessException(BizErrorCodeEnum.DATA_SOURCE_DETAIL_NOT_FOUND);
        }
        this.checkBizIsTempStatus(detailInfo.getInlongGroupId());
        detailInfo.setStatus(EntityStatus.AGENT_ADD.getCode());
        SourceFileDetailEntity updateEntity = (SourceFileDetailEntity)CommonBeanUtils.copyProperties((Object)detailInfo, SourceFileDetailEntity::new);
        updateEntity.setModifier(operator);
        updateEntity.setModifyTime(new Date());
        this.fileDetailMapper.updateByPrimaryKeySelective(updateEntity);
        LOGGER.info("success to update file data source detail");
        return true;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public boolean logicDeleteDetail(Integer id, String operator) {
        LOGGER.info("begin to delete file data source detail, id={}", (Object)id);
        Preconditions.checkNotNull((Object)id, (String)"file data source detail's id is null");
        SourceFileDetailEntity entity = this.fileDetailMapper.selectByPrimaryKey(id);
        if (entity == null) {
            LOGGER.error("file data source detail not found by id={}", (Object)id);
            throw new BusinessException(BizErrorCodeEnum.DATA_SOURCE_DETAIL_NOT_FOUND);
        }
        BusinessEntity bizEntity = this.checkBizIsTempStatus(entity.getInlongGroupId());
        if (EntityStatus.BIZ_CONFIG_SUCCESSFUL.getCode().equals(bizEntity.getStatus())) {
            entity.setPreviousStatus(entity.getStatus());
            entity.setStatus(EntityStatus.AGENT_DELETE.getCode());
        } else {
            entity.setPreviousStatus(entity.getStatus());
            entity.setStatus(EntityStatus.AGENT_DISABLE.getCode());
        }
        entity.setIsDeleted(EntityStatus.IS_DELETED.getCode());
        entity.setModifier(operator);
        int resultCount = this.fileDetailMapper.updateByPrimaryKey(entity);
        LOGGER.info("success to delete file data source detail");
        return resultCount >= 0;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public boolean deleteAllByIdentifier(String groupId, String streamId) {
        LOGGER.info("begin delete all file basic and detail by groupId={}, streamId={}", (Object)groupId, (Object)streamId);
        Preconditions.checkNotNull((Object)groupId, (String)"business group id is empty");
        Preconditions.checkNotNull((Object)streamId, (String)"data stream id is empty");
        this.checkBizIsTempStatus(groupId);
        this.fileBasicMapper.deleteByIdentifier(groupId, streamId);
        this.fileDetailMapper.deleteByIdentifier(groupId, streamId);
        LOGGER.info("success delete all file basic and detail");
        return true;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public boolean logicDeleteAllByIdentifier(String groupId, String streamId, String operator) {
        LOGGER.info("begin logic delete all file basic and detail by groupId={}, streamId={}", (Object)groupId, (Object)streamId);
        Preconditions.checkNotNull((Object)groupId, (String)"business group id is empty");
        Preconditions.checkNotNull((Object)streamId, (String)"data stream id is empty");
        this.checkBizIsTempStatus(groupId);
        this.fileBasicMapper.logicDeleteByIdentifier(groupId, streamId, operator);
        this.fileDetailMapper.logicDeleteByIdentifier(groupId, streamId, operator);
        LOGGER.info("success logic delete all file basic and detail");
        return true;
    }

    private BusinessEntity checkBizIsTempStatus(String groupId) {
        BusinessEntity businessEntity = this.businessMapper.selectByIdentifier(groupId);
        Preconditions.checkNotNull((Object)businessEntity, (String)"groupId is invalid");
        if (EntityStatus.BIZ_TEMP_STATUS.contains((Object)businessEntity.getStatus())) {
            LOGGER.error("business status was not allowed to add/update/delete data source info");
            throw new BusinessException(BizErrorCodeEnum.DATA_SOURCE_OPT_NOT_ALLOWED);
        }
        return businessEntity;
    }
}

