/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.core.impl;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.inlong.manager.common.enums.BizErrorCodeEnum;
import org.apache.inlong.manager.common.enums.EntityStatus;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.pojo.business.BusinessInfo;
import org.apache.inlong.manager.common.pojo.datastorage.StorageExtInfo;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.BusinessEntity;
import org.apache.inlong.manager.dao.entity.StorageExtEntity;
import org.apache.inlong.manager.dao.mapper.BusinessEntityMapper;
import org.apache.inlong.manager.dao.mapper.StorageExtEntityMapper;
import org.apache.inlong.manager.service.core.impl.BusinessProcessOperation;
import org.apache.inlong.manager.service.workflow.ProcessName;
import org.apache.inlong.manager.service.workflow.WorkflowService;
import org.apache.inlong.manager.service.workflow.business.BusinessResourceWorkflowForm;
import org.apache.inlong.manager.service.workflow.business.NewBusinessWorkflowForm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class StorageBaseOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger(StorageBaseOperation.class);
    public final ExecutorService executorService = new ThreadPoolExecutor(10, 20, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(100), new ThreadFactoryBuilder().setNameFormat("data-stream-workflow-%s").build(), new ThreadPoolExecutor.CallerRunsPolicy());
    @Autowired
    private BusinessEntityMapper businessMapper;
    @Autowired
    private StorageExtEntityMapper storageExtMapper;
    @Autowired
    private WorkflowService workflowService;
    @Autowired
    private BusinessProcessOperation businessProcessOperation;

    public void startBusinessProcess(String operator, BusinessEntity businessEntity) {
        BusinessInfo businessInfo = (BusinessInfo)CommonBeanUtils.copyProperties((Object)businessEntity, BusinessInfo::new);
        NewBusinessWorkflowForm form = this.businessProcessOperation.genNewBusinessWorkflowForm(businessInfo);
        this.workflowService.start(ProcessName.NEW_BUSINESS_WORKFLOW, operator, form);
    }

    public BusinessEntity checkBizIsTempStatus(String groupId) {
        BusinessEntity businessEntity = this.businessMapper.selectByIdentifier(groupId);
        Preconditions.checkNotNull((Object)businessEntity, (String)"groupId is invalid");
        if (EntityStatus.BIZ_TEMP_STATUS.contains((Object)businessEntity.getStatus())) {
            LOGGER.error("business status was not allowed to add/update/delete data storage");
            throw new BusinessException(BizErrorCodeEnum.STORAGE_OPT_NOT_ALLOWED);
        }
        return businessEntity;
    }

    @Transactional(rollbackFor={Throwable.class})
    public void updateExtOpt(String storageType, Integer storageId, List<StorageExtInfo> extList) {
        LOGGER.info("begin to update data storage ext={}", extList);
        try {
            this.storageExtMapper.deleteByStorageTypeAndId(storageType, storageId);
            this.saveExtOpt(storageType, storageId, extList);
        }
        catch (Exception e) {
            LOGGER.error("failed to update data storage ext: ", (Throwable)e);
            throw new BusinessException(BizErrorCodeEnum.STORAGE_SAVE_FAILED);
        }
    }

    public void saveExtOpt(String storageType, int storageId, List<StorageExtInfo> extList) {
        if (CollectionUtils.isEmpty(extList)) {
            return;
        }
        LOGGER.info("begin to save storage ext={}", extList);
        Date date = new Date();
        for (StorageExtInfo extInfo : extList) {
            StorageExtEntity extEntity = (StorageExtEntity)CommonBeanUtils.copyProperties((Object)extInfo, StorageExtEntity::new);
            extEntity.setStorageId(Integer.valueOf(storageId));
            extEntity.setStorageType(storageType);
            extEntity.setModifyTime(date);
            this.storageExtMapper.insert(extEntity);
        }
        LOGGER.info("success to save storage ext");
    }

    class WorkflowStartRunnable
    implements Runnable {
        private final String operator;
        private final BusinessEntity businessEntity;
        private final String streamId;

        public WorkflowStartRunnable(String operator, BusinessEntity businessEntity, String streamId) {
            this.operator = operator;
            this.businessEntity = businessEntity;
            this.streamId = streamId;
        }

        @Override
        public void run() {
            String groupId = this.businessEntity.getInlongGroupId();
            LOGGER.info("begin start data stream workflow, groupId={}, streamId={}", (Object)groupId, (Object)this.streamId);
            BusinessInfo businessInfo = (BusinessInfo)CommonBeanUtils.copyProperties((Object)this.businessEntity, BusinessInfo::new);
            BusinessResourceWorkflowForm form = this.genBizResourceWorkflowForm(businessInfo, this.streamId);
            StorageBaseOperation.this.workflowService.start(ProcessName.CREATE_DATASTREAM_RESOURCE, this.operator, form);
            LOGGER.info("success start data stream workflow, groupId={}, streamId={}", (Object)groupId, (Object)this.streamId);
        }

        private BusinessResourceWorkflowForm genBizResourceWorkflowForm(BusinessInfo businessInfo, String streamId) {
            BusinessResourceWorkflowForm form = new BusinessResourceWorkflowForm();
            form.setBusinessInfo(businessInfo);
            form.setInlongStreamId(streamId);
            return form;
        }
    }
}

