/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.core.impl;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.BizErrorCodeEnum;
import org.apache.inlong.manager.common.enums.EntityStatus;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.pojo.datastorage.BaseStorageInfo;
import org.apache.inlong.manager.common.pojo.datastorage.StorageExtInfo;
import org.apache.inlong.manager.common.pojo.datastorage.StorageHiveFieldInfo;
import org.apache.inlong.manager.common.pojo.datastorage.StorageHiveInfo;
import org.apache.inlong.manager.common.pojo.datastorage.StorageHiveListVO;
import org.apache.inlong.manager.common.pojo.datastorage.StoragePageRequest;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.DataStreamEntity;
import org.apache.inlong.manager.dao.entity.StorageHiveEntity;
import org.apache.inlong.manager.dao.entity.StorageHiveFieldEntity;
import org.apache.inlong.manager.dao.mapper.DataStreamEntityMapper;
import org.apache.inlong.manager.dao.mapper.StorageExtEntityMapper;
import org.apache.inlong.manager.dao.mapper.StorageHiveEntityMapper;
import org.apache.inlong.manager.dao.mapper.StorageHiveFieldEntityMapper;
import org.apache.inlong.manager.service.core.impl.StorageBaseOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StorageHiveOperation
extends StorageBaseOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger(StorageHiveOperation.class);
    @Autowired
    private StorageHiveEntityMapper hiveStorageMapper;
    @Autowired
    private StorageExtEntityMapper storageExtMapper;
    @Autowired
    private StorageHiveFieldEntityMapper hiveFieldMapper;
    @Autowired
    private DataStreamEntityMapper dataStreamMapper;

    public int saveHiveStorage(BaseStorageInfo storageInfo, String operator) {
        String groupId = storageInfo.getInlongGroupId();
        List storageExist = this.hiveStorageMapper.selectByIdentifier(groupId, storageInfo.getInlongStreamId());
        Preconditions.checkEmpty((Collection)storageExist, (String)"HIVE storage already exist under the groupId and streamId");
        StorageHiveInfo hiveInfo = (StorageHiveInfo)storageInfo;
        StorageHiveEntity entity = (StorageHiveEntity)CommonBeanUtils.copyProperties((Object)hiveInfo, StorageHiveEntity::new);
        DataStreamEntity streamEntity = this.dataStreamMapper.selectByIdentifier(groupId, entity.getInlongStreamId());
        String dataEncoding = streamEntity.getDataEncoding() == null ? StandardCharsets.UTF_8.displayName() : streamEntity.getDataEncoding();
        entity.setDataEncoding(dataEncoding);
        if (entity.getDataSeparator() == null) {
            entity.setDataSeparator(streamEntity.getDataSeparator());
        }
        entity.setStatus(EntityStatus.DATA_STORAGE_NEW.getCode());
        entity.setCreator(operator);
        entity.setModifier(operator);
        entity.setCreateTime(new Date());
        this.hiveStorageMapper.insertSelective(entity);
        int id = entity.getId();
        this.saveHiveFieldOpt(id, hiveInfo.getHiveFieldList());
        String storageType = "HIVE";
        this.saveExtOpt(storageType, id, hiveInfo.getExtList());
        return id;
    }

    public void setHiveStorageInfo(String groupId, String streamId, List<BaseStorageInfo> storageInfoList) {
        List hiveEntities = this.hiveStorageMapper.selectByIdentifier(groupId, streamId);
        if (CollectionUtils.isEmpty((Collection)hiveEntities)) {
            return;
        }
        for (StorageHiveEntity hiveEntity : hiveEntities) {
            Integer storageId = hiveEntity.getId();
            String storageType = "HIVE";
            List extEntities = this.storageExtMapper.selectByStorageTypeAndId("HIVE", storageId);
            List fieldEntityList = this.hiveFieldMapper.selectByStorageId(storageId);
            List fieldInfoList = CommonBeanUtils.copyListProperties((List)fieldEntityList, StorageHiveFieldInfo::new);
            StorageHiveInfo hiveInfo = (StorageHiveInfo)CommonBeanUtils.copyProperties((Object)hiveEntity, StorageHiveInfo::new);
            hiveInfo.setStorageType(storageType);
            hiveInfo.setExtList(CommonBeanUtils.copyListProperties((List)extEntities, StorageExtInfo::new));
            hiveInfo.setHiveFieldList(fieldInfoList);
            storageInfoList.add((BaseStorageInfo)hiveInfo);
        }
    }

    public boolean logicDeleteHiveByIdentifier(String groupId, String streamId, String operator) {
        List hiveEntityList = this.hiveStorageMapper.selectByIdentifier(groupId, streamId);
        if (CollectionUtils.isNotEmpty((Collection)hiveEntityList)) {
            hiveEntityList.forEach(entity -> {
                entity.setIsDeleted(EntityStatus.IS_DELETED.getCode());
                entity.setPreviousStatus(entity.getStatus());
                entity.setStatus(EntityStatus.DELETED.getCode());
                entity.setModifier(operator);
                this.hiveStorageMapper.updateByPrimaryKey(entity);
                this.storageExtMapper.logicDeleteAll(entity.getId());
                this.hiveFieldMapper.logicDeleteAll(entity.getId());
            });
        }
        return true;
    }

    public boolean logicDeleteHiveStorage(Integer id, String operator) {
        StorageHiveEntity entity = this.hiveStorageMapper.selectByPrimaryKey(id);
        if (entity == null) {
            LOGGER.error("hive storage not found by id={}, delete failed", (Object)id);
            throw new BusinessException(BizErrorCodeEnum.STORAGE_INFO_NOT_FOUND);
        }
        super.checkBizIsTempStatus(entity.getInlongGroupId());
        entity.setIsDeleted(EntityStatus.IS_DELETED.getCode());
        entity.setPreviousStatus(entity.getStatus());
        entity.setStatus(EntityStatus.DELETED.getCode());
        entity.setModifier(operator);
        int resultCount = this.hiveStorageMapper.updateByPrimaryKey(entity);
        this.storageExtMapper.logicDeleteAll(id);
        this.hiveFieldMapper.logicDeleteAll(id);
        return resultCount >= 0;
    }

    public boolean deleteHiveByIdentifier(String groupId, String streamId) {
        List storageHiveEntities = this.hiveStorageMapper.selectByIdentifier(groupId, streamId);
        if (CollectionUtils.isNotEmpty((Collection)storageHiveEntities)) {
            storageHiveEntities.forEach(entity -> {
                this.hiveStorageMapper.deleteByPrimaryKey(entity.getId());
                this.hiveFieldMapper.deleteAllByStorageId(entity.getId());
            });
        }
        return true;
    }

    public BaseStorageInfo getHiveStorage(Integer id) {
        StorageHiveEntity entity = this.hiveStorageMapper.selectByPrimaryKey(id);
        if (entity == null) {
            LOGGER.error("hive storage not found by id={}", (Object)id);
            return null;
        }
        StorageHiveInfo hiveInfo = (StorageHiveInfo)CommonBeanUtils.copyProperties((Object)entity, StorageHiveInfo::new);
        String storageType = "HIVE";
        List extEntityList = this.storageExtMapper.selectByStorageTypeAndId(storageType, id);
        List extInfoList = CommonBeanUtils.copyListProperties((List)extEntityList, StorageExtInfo::new);
        hiveInfo.setExtList(extInfoList);
        List entities = this.hiveFieldMapper.selectByStorageId(id);
        List infos = CommonBeanUtils.copyListProperties((List)entities, StorageHiveFieldInfo::new);
        hiveInfo.setHiveFieldList(infos);
        return hiveInfo;
    }

    public PageInfo<StorageHiveListVO> getHiveStorageList(StoragePageRequest request) {
        LOGGER.info("begin to list hive storage page by {}", (Object)request);
        PageHelper.startPage((int)request.getPageNum(), (int)request.getPageSize());
        Page entityPage = (Page)this.hiveStorageMapper.selectByCondition(request);
        List detailList = CommonBeanUtils.copyListProperties((List)entityPage, StorageHiveListVO::new);
        PageInfo page = new PageInfo(detailList);
        page.setTotal(entityPage.getTotal());
        LOGGER.info("success to list hive storage");
        return page;
    }

    public Integer updateHiveStorage(Integer bizStatus, BaseStorageInfo storageInfo, String operator) {
        StorageHiveInfo hiveInfo = (StorageHiveInfo)storageInfo;
        Integer id = hiveInfo.getId();
        if (id != null) {
            StorageHiveEntity entity = this.hiveStorageMapper.selectByPrimaryKey(hiveInfo.getId());
            if (entity == null) {
                LOGGER.error("hive storage not found by id={}, update failed", (Object)id);
                throw new BusinessException(BizErrorCodeEnum.STORAGE_INFO_NOT_FOUND);
            }
            BeanUtils.copyProperties((Object)hiveInfo, (Object)entity);
            entity.setStatus(EntityStatus.BIZ_CONFIG_ING.getCode());
            entity.setModifier(operator);
            this.hiveStorageMapper.updateByPrimaryKeySelective(entity);
            super.updateExtOpt(hiveInfo.getStorageType(), id, hiveInfo.getExtList());
            this.updateHiveFieldOpt(bizStatus, id, hiveInfo.getHiveFieldList());
        } else {
            id = this.saveHiveStorage((BaseStorageInfo)hiveInfo, operator);
        }
        return id;
    }

    private void updateHiveFieldOpt(Integer bizStatus, Integer storageId, List<StorageHiveFieldInfo> fieldInfoList) {
        if (CollectionUtils.isEmpty(fieldInfoList)) {
            return;
        }
        LOGGER.info("begin to update hive field={}", fieldInfoList);
        if (EntityStatus.BIZ_CONFIG_SUCCESSFUL.getCode().equals(bizStatus)) {
            List existsFieldList = this.hiveFieldMapper.selectByStorageId(storageId);
            if (existsFieldList.size() > fieldInfoList.size()) {
                LOGGER.error("current status was not allowed to update hive field");
                throw new BusinessException(BizErrorCodeEnum.STORAGE_HIVE_FIELD_UPDATE_NOT_ALLOWED);
            }
            for (int i = 0; i < existsFieldList.size(); ++i) {
                if (((StorageHiveFieldEntity)existsFieldList.get(i)).getFieldName().equals(fieldInfoList.get(i).getFieldName())) continue;
                LOGGER.error("current status was not allowed to update hive field");
                throw new BusinessException(BizErrorCodeEnum.STORAGE_HIVE_FIELD_UPDATE_NOT_ALLOWED);
            }
        }
        try {
            this.hiveFieldMapper.deleteAllByStorageId(storageId);
            this.saveHiveFieldOpt(storageId, fieldInfoList);
            LOGGER.info("success to update hive field");
        }
        catch (Exception e) {
            LOGGER.error("failed to update hive field: ", (Throwable)e);
            throw new BusinessException(BizErrorCodeEnum.STORAGE_HIVE_FIELD_SAVE_FAILED);
        }
    }

    private void saveHiveFieldOpt(int storageId, List<StorageHiveFieldInfo> hiveFieldList) {
        if (CollectionUtils.isEmpty(hiveFieldList)) {
            return;
        }
        LOGGER.info("begin to save hive field={}", hiveFieldList);
        for (StorageHiveFieldInfo fieldInfo : hiveFieldList) {
            StorageHiveFieldEntity fieldEntity = (StorageHiveFieldEntity)CommonBeanUtils.copyProperties((Object)fieldInfo, StorageHiveFieldEntity::new);
            if (StringUtils.isEmpty((CharSequence)fieldEntity.getFieldComment())) {
                fieldEntity.setFieldComment(fieldEntity.getFieldName());
            }
            fieldEntity.setStorageId(Integer.valueOf(storageId));
            this.hiveFieldMapper.insert(fieldEntity);
        }
        LOGGER.info("success to save hive field");
    }
}

