/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.core.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.EntityStatus;
import org.apache.inlong.manager.common.pojo.workflow.FilterKey;
import org.apache.inlong.manager.common.pojo.workflow.WorkflowApprover;
import org.apache.inlong.manager.common.pojo.workflow.WorkflowApproverFilterContext;
import org.apache.inlong.manager.common.pojo.workflow.WorkflowApproverQuery;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.WorkflowApproverEntity;
import org.apache.inlong.manager.dao.mapper.WorkflowApproverEntityMapper;
import org.apache.inlong.manager.service.core.WorkflowApproverService;
import org.apache.inlong.manager.workflow.core.WorkflowEngine;
import org.apache.inlong.manager.workflow.model.definition.Element;
import org.apache.inlong.manager.workflow.model.definition.Process;
import org.apache.inlong.manager.workflow.model.definition.Task;
import org.apache.inlong.manager.workflow.model.definition.UserTask;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WorkflowApproverServiceImpl
implements WorkflowApproverService {
    @Autowired
    private WorkflowApproverEntityMapper workflowApproverMapper;
    @Autowired
    private WorkflowEngine workflowEngine;

    @Override
    public List<String> getApprovers(String processName, String taskName, WorkflowApproverFilterContext context) {
        WorkflowApproverQuery approverQuery = WorkflowApproverQuery.builder().processName(processName).taskName(taskName).build();
        List configs = this.workflowApproverMapper.selectByQuery(approverQuery);
        Map<String, List<WorkflowApproverEntity>> groupByFilterKey = configs.stream().collect(Collectors.groupingBy(WorkflowApproverEntity::getFilterKey));
        Map filterKey2ValueMap = context.toFilterKeyMap();
        return FilterKey.getFilterKeyByOrder().stream().map(Enum::name).map(groupByFilterKey::get).filter(Objects::nonNull).flatMap(Collection::stream).filter(config -> this.checkFilterCondition(filterKey2ValueMap, (WorkflowApproverEntity)config)).findFirst().map(WorkflowApproverEntity::getApprovers).map(approvers -> Arrays.asList(approvers.split(","))).orElse(null);
    }

    @Override
    public List<WorkflowApprover> list(WorkflowApproverQuery query) {
        List entityList = this.workflowApproverMapper.selectByQuery(query);
        List approverList = CommonBeanUtils.copyListProperties((List)entityList, WorkflowApprover::new);
        approverList.forEach(config -> {
            Process process = this.workflowEngine.processDefinitionService().getByName(config.getProcessName());
            if (process != null) {
                config.setProcessDisplayName(process.getDisplayName());
                config.setTaskDisplayName((String)Optional.ofNullable(process.getTaskByName(config.getTaskName())).map(Element::getDisplayName).orElse(null));
            }
        });
        return approverList;
    }

    @Override
    public void add(WorkflowApprover approver, String operator) {
        Date now = new Date();
        approver.setCreateTime(now);
        approver.setModifyTime(now);
        approver.setModifier(operator);
        approver.setCreator(operator);
        Process process = this.workflowEngine.processDefinitionService().getByName(approver.getProcessName());
        Preconditions.checkNotNull((Object)process, (String)("process not exit with name: " + approver.getProcessName()));
        Task task = process.getTaskByName(approver.getTaskName());
        Preconditions.checkNotNull((Object)task, (String)("task not exit with name: " + approver.getTaskName()));
        Preconditions.checkTrue((boolean)(task instanceof UserTask), (String)"task should be userTask");
        List exist = this.workflowApproverMapper.selectByQuery(WorkflowApproverQuery.builder().processName(approver.getProcessName()).taskName(approver.getTaskName()).filterKey(approver.getFilterKey().name()).filterValue(approver.getFilterValue()).build());
        Preconditions.checkEmpty((Collection)exist, (String)"already exit the same config");
        WorkflowApproverEntity entity = (WorkflowApproverEntity)CommonBeanUtils.copyProperties((Object)approver, WorkflowApproverEntity::new);
        entity.setIsDeleted(EntityStatus.UN_DELETED.getCode());
        int success = this.workflowApproverMapper.insert(entity);
        Preconditions.checkTrue((success == 1 ? 1 : 0) != 0, (String)"add failed");
    }

    @Override
    public void update(WorkflowApprover config, String operator) {
        Preconditions.checkNotNull((Object)config, (String)"config cannot be null");
        Preconditions.checkNotNull((Object)config.getId(), (String)"id cannot be null");
        WorkflowApproverEntity entity = this.workflowApproverMapper.selectByPrimaryKey(config.getId());
        Preconditions.checkNotNull((Object)entity, (String)("not exist with id:" + config.getId()));
        WorkflowApproverEntity update = new WorkflowApproverEntity();
        update.setId(config.getId());
        update.setModifyTime(new Date());
        update.setModifier(operator);
        update.setApprovers(config.getApprovers());
        update.setFilterKey(config.getFilterKey().name());
        update.setFilterValue(config.getFilterValue());
        int success = this.workflowApproverMapper.updateByPrimaryKeySelective(update);
        Preconditions.checkTrue((success == 1 ? 1 : 0) != 0, (String)"update failed");
    }

    @Override
    public void delete(Integer id, String operator) {
        WorkflowApproverEntity entity = this.workflowApproverMapper.selectByPrimaryKey(id);
        Preconditions.checkNotNull((Object)entity, (String)("not exist with id:" + id));
        int success = this.workflowApproverMapper.deleteByPrimaryKey(id, operator);
        Preconditions.checkTrue((success == 1 ? 1 : 0) != 0, (String)"delete failed");
    }

    private boolean checkFilterCondition(Map<FilterKey, String> filterKey2ValueMap, WorkflowApproverEntity config) {
        FilterKey filterKey = FilterKey.fromName((String)config.getFilterKey());
        if (filterKey == null) {
            return false;
        }
        return FilterKey.DEFAULT.name().equals(config.getFilterKey()) || StringUtils.equals((CharSequence)filterKey2ValueMap.get(filterKey), (CharSequence)config.getFilterValue());
    }
}

