/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.thirdpart.hive;

import java.util.List;
import org.apache.inlong.manager.common.pojo.datastorage.StorageHiveSortInfo;
import org.apache.inlong.manager.dao.mapper.StorageHiveEntityMapper;
import org.apache.inlong.manager.service.thirdpart.hive.HiveTableOperator;
import org.apache.inlong.manager.service.workflow.business.BusinessResourceWorkflowForm;
import org.apache.inlong.manager.workflow.core.event.ListenerResult;
import org.apache.inlong.manager.workflow.core.event.task.TaskEvent;
import org.apache.inlong.manager.workflow.core.event.task.TaskEventListener;
import org.apache.inlong.manager.workflow.model.WorkflowContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CreateHiveTableListener
implements TaskEventListener {
    private static final Logger log = LoggerFactory.getLogger(CreateHiveTableListener.class);
    @Autowired
    private StorageHiveEntityMapper hiveEntityMapper;
    @Autowired
    private HiveTableOperator hiveTableOperator;

    public TaskEvent event() {
        return TaskEvent.COMPLETE;
    }

    public ListenerResult listen(WorkflowContext context) {
        BusinessResourceWorkflowForm form = (BusinessResourceWorkflowForm)context.getProcessForm();
        String groupId = form.getInlongGroupId();
        log.info("begin to create hive table for groupId={}", (Object)groupId);
        List configList = this.hiveEntityMapper.selectHiveSortInfoByIdentifier(groupId, null);
        if (configList == null || configList.size() == 0) {
            return ListenerResult.success();
        }
        for (StorageHiveSortInfo hiveConfig : configList) {
            this.hiveTableOperator.createHiveTable(groupId, hiveConfig);
            log.info("finish to create hive table for business {}", (Object)groupId);
        }
        return ListenerResult.success();
    }

    public boolean async() {
        return false;
    }
}

