/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.thirdpart.mq;

import java.util.List;
import org.apache.inlong.manager.common.beans.ClusterBean;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.pojo.business.BusinessInfo;
import org.apache.inlong.manager.common.pojo.pulsar.PulsarTopicBean;
import org.apache.inlong.manager.dao.entity.DataStreamEntity;
import org.apache.inlong.manager.dao.mapper.DataStreamEntityMapper;
import org.apache.inlong.manager.service.core.BusinessService;
import org.apache.inlong.manager.service.core.ConsumptionService;
import org.apache.inlong.manager.service.core.StorageService;
import org.apache.inlong.manager.service.thirdpart.mq.PulsarOptService;
import org.apache.inlong.manager.service.thirdpart.mq.util.PulsarUtils;
import org.apache.inlong.manager.service.workflow.business.BusinessResourceWorkflowForm;
import org.apache.inlong.manager.workflow.core.event.ListenerResult;
import org.apache.inlong.manager.workflow.core.event.task.TaskEvent;
import org.apache.inlong.manager.workflow.core.event.task.TaskEventListener;
import org.apache.inlong.manager.workflow.exception.WorkflowListenerException;
import org.apache.inlong.manager.workflow.model.WorkflowContext;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CreatePulsarGroupForStreamTaskListener
implements TaskEventListener {
    private static final Logger log = LoggerFactory.getLogger(CreatePulsarGroupForStreamTaskListener.class);
    @Autowired
    private ClusterBean clusterBean;
    @Autowired
    private BusinessService businessService;
    @Autowired
    private DataStreamEntityMapper dataStreamMapper;
    @Autowired
    private PulsarOptService pulsarOptService;
    @Autowired
    private StorageService storageService;
    @Autowired
    private ConsumptionService consumptionService;

    public TaskEvent event() {
        return TaskEvent.COMPLETE;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ListenerResult listen(WorkflowContext context) throws WorkflowListenerException {
        BusinessResourceWorkflowForm form = (BusinessResourceWorkflowForm)context.getProcessForm();
        String groupId = form.getInlongGroupId();
        String streamId = form.getInlongStreamId();
        BusinessInfo bizInfo = this.businessService.get(groupId);
        if (bizInfo == null) {
            log.error("business not found with groupId={}", (Object)groupId);
            throw new WorkflowListenerException("business not found with groupId=" + groupId);
        }
        DataStreamEntity streamEntity = this.dataStreamMapper.selectByIdentifier(groupId, streamId);
        if (streamEntity == null) {
            log.warn("data stream is empty for group={}, stream={}, skip to create pulsar group", (Object)groupId, (Object)streamId);
            return ListenerResult.success();
        }
        try (PulsarAdmin globalPulsarAdmin = PulsarUtils.getPulsarAdmin(this.clusterBean.getPulsarAdminUrl());){
            List<String> storageTypeList = this.storageService.getStorageTypeList(groupId, streamId);
            if (storageTypeList == null || storageTypeList.size() == 0) {
                log.warn("storage info is empty for groupId={}, streamId={}, skip to create pulsar group", (Object)groupId, (Object)streamId);
                ListenerResult listenerResult = ListenerResult.success();
                return listenerResult;
            }
            PulsarTopicBean topicBean = new PulsarTopicBean();
            topicBean.setTenant(this.clusterBean.getDefaultTenant());
            topicBean.setNamespace(bizInfo.getMqResourceObj());
            String topic = streamEntity.getMqResourceObj();
            topicBean.setTopicName(topic);
            List<String> pulsarClusters = PulsarUtils.getPulsarClusters(globalPulsarAdmin);
            String tenant = this.clusterBean.getDefaultTenant();
            String namespace = bizInfo.getMqResourceObj();
            for (String cluster : pulsarClusters) {
                String serviceUrl = PulsarUtils.getServiceUrl(globalPulsarAdmin, cluster);
                PulsarAdmin pulsarAdmin = PulsarUtils.getPulsarAdmin(serviceUrl);
                Throwable throwable = null;
                try {
                    boolean exist = this.pulsarOptService.topicIsExists(pulsarAdmin, tenant, namespace, topic);
                    if (!exist) {
                        String fullTopic = tenant + "/" + namespace + "/" + topic;
                        log.error("topic={} not exists in {}", (Object)fullTopic, (Object)pulsarAdmin.getServiceUrl());
                        throw new BusinessException("topic=" + fullTopic + " not exists in " + serviceUrl);
                    }
                    String subscription = this.clusterBean.getAppName() + "_" + topic + "_consumer_group";
                    this.pulsarOptService.createSubscription(pulsarAdmin, topicBean, subscription);
                    this.consumptionService.saveSortConsumption(bizInfo, topic, subscription);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (pulsarAdmin == null) continue;
                    if (throwable != null) {
                        try {
                            pulsarAdmin.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    pulsarAdmin.close();
                }
            }
        }
        catch (Exception e) {
            log.error("create pulsar subscription error for groupId={}, streamId={}", new Object[]{groupId, streamId, e});
            throw new WorkflowListenerException("create pulsar subscription error, reason: " + e.getMessage());
        }
        log.info("finish to create single pulsar subscription for groupId={}, streamId={}", (Object)groupId, (Object)streamId);
        return ListenerResult.success();
    }

    public boolean async() {
        return false;
    }
}

