/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.thirdpart.mq;

import java.util.List;
import org.apache.inlong.manager.common.beans.ClusterBean;
import org.apache.inlong.manager.common.pojo.business.BusinessInfo;
import org.apache.inlong.manager.common.pojo.pulsar.PulsarTopicBean;
import org.apache.inlong.manager.dao.entity.DataStreamEntity;
import org.apache.inlong.manager.dao.mapper.DataStreamEntityMapper;
import org.apache.inlong.manager.service.core.BusinessService;
import org.apache.inlong.manager.service.core.ConsumptionService;
import org.apache.inlong.manager.service.thirdpart.mq.PulsarOptService;
import org.apache.inlong.manager.service.thirdpart.mq.util.PulsarUtils;
import org.apache.inlong.manager.service.workflow.business.BusinessResourceWorkflowForm;
import org.apache.inlong.manager.workflow.core.event.ListenerResult;
import org.apache.inlong.manager.workflow.core.event.task.TaskEvent;
import org.apache.inlong.manager.workflow.core.event.task.TaskEventListener;
import org.apache.inlong.manager.workflow.exception.WorkflowListenerException;
import org.apache.inlong.manager.workflow.model.WorkflowContext;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CreatePulsarGroupTaskListener
implements TaskEventListener {
    private static final Logger log = LoggerFactory.getLogger(CreatePulsarGroupTaskListener.class);
    @Autowired
    private ClusterBean clusterBean;
    @Autowired
    private BusinessService businessService;
    @Autowired
    private ConsumptionService consumptionService;
    @Autowired
    private DataStreamEntityMapper dataStreamMapper;
    @Autowired
    private PulsarOptService pulsarOptService;

    public TaskEvent event() {
        return TaskEvent.COMPLETE;
    }

    public ListenerResult listen(WorkflowContext context) throws WorkflowListenerException {
        BusinessResourceWorkflowForm form = (BusinessResourceWorkflowForm)context.getProcessForm();
        String groupId = form.getInlongGroupId();
        BusinessInfo bizInfo = this.businessService.get(groupId);
        if (bizInfo == null) {
            log.error("business not found with groupId={}", (Object)groupId);
            throw new WorkflowListenerException("business not found with groupId=" + groupId);
        }
        List streamEntities = this.dataStreamMapper.selectByGroupId(groupId);
        if (streamEntities == null || streamEntities.isEmpty()) {
            log.warn("data stream is empty for groupId={}, skip to create pulsar subscription", (Object)groupId);
            return ListenerResult.success();
        }
        try (PulsarAdmin globalPulsarAdmin = PulsarUtils.getPulsarAdmin(this.clusterBean.getPulsarAdminUrl());){
            String tenant = this.clusterBean.getDefaultTenant();
            String namespace = bizInfo.getMqResourceObj();
            for (DataStreamEntity streamEntity : streamEntities) {
                PulsarTopicBean topicBean = new PulsarTopicBean();
                topicBean.setTenant(tenant);
                topicBean.setNamespace(namespace);
                String topic = streamEntity.getMqResourceObj();
                topicBean.setTopicName(topic);
                List<String> pulsarClusters = PulsarUtils.getPulsarClusters(globalPulsarAdmin);
                for (String cluster : pulsarClusters) {
                    String url = PulsarUtils.getServiceUrl(globalPulsarAdmin, cluster);
                    PulsarAdmin pulsarAdmin = PulsarUtils.getPulsarAdmin(url);
                    Throwable throwable = null;
                    try {
                        boolean exist = this.pulsarOptService.topicIsExists(pulsarAdmin, tenant, namespace, topic);
                        if (!exist) {
                            String topicFull = tenant + "/" + namespace + "/" + topic;
                            log.error("topic={} not exists in {}", (Object)topicFull, (Object)url);
                            throw new WorkflowListenerException("topic=" + topicFull + " not exists in " + url);
                        }
                        String subscription = this.clusterBean.getAppName() + "_" + topic + "_consumer_group";
                        this.pulsarOptService.createSubscription(pulsarAdmin, topicBean, subscription);
                        this.consumptionService.saveSortConsumption(bizInfo, topic, subscription);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (pulsarAdmin == null) continue;
                        if (throwable != null) {
                            try {
                                pulsarAdmin.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        pulsarAdmin.close();
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("create pulsar subscription error for groupId={}", (Object)groupId);
            throw new WorkflowListenerException("create pulsar subscription error: " + e.getMessage());
        }
        log.info("success to create pulsar subscription for groupId={}", (Object)groupId);
        return ListenerResult.success();
    }

    public boolean async() {
        return false;
    }
}

