/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.thirdpart.mq;

import java.util.Collections;
import org.apache.inlong.manager.common.beans.ReTryConfigBean;
import org.apache.inlong.manager.common.pojo.business.BusinessInfo;
import org.apache.inlong.manager.common.pojo.tubemq.AddTubeConsumeGroupRequest;
import org.apache.inlong.manager.common.pojo.tubemq.QueryTubeTopicRequest;
import org.apache.inlong.manager.dao.mapper.ClusterInfoMapper;
import org.apache.inlong.manager.service.core.BusinessService;
import org.apache.inlong.manager.service.thirdpart.mq.TubeMqOptService;
import org.apache.inlong.manager.service.workflow.business.BusinessResourceWorkflowForm;
import org.apache.inlong.manager.workflow.core.event.ListenerResult;
import org.apache.inlong.manager.workflow.core.event.task.TaskEvent;
import org.apache.inlong.manager.workflow.core.event.task.TaskEventListener;
import org.apache.inlong.manager.workflow.exception.WorkflowListenerException;
import org.apache.inlong.manager.workflow.model.WorkflowContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class CreateTubeGroupTaskListener
implements TaskEventListener {
    private static final Logger log = LoggerFactory.getLogger(CreateTubeGroupTaskListener.class);
    @Autowired
    BusinessService businessService;
    @Autowired
    ClusterInfoMapper clusterInfoMapper;
    @Autowired
    TubeMqOptService tubeMqOptService;
    @Value(value="${cluster.tube.clusterId}")
    Integer clusterId;
    @Autowired
    ReTryConfigBean reTryConfigBean;

    public TaskEvent event() {
        return TaskEvent.COMPLETE;
    }

    public ListenerResult listen(WorkflowContext context) throws WorkflowListenerException {
        BusinessResourceWorkflowForm form = (BusinessResourceWorkflowForm)context.getProcessForm();
        String groupId = form.getInlongGroupId();
        log.info("try to create consumer group for groupId {}", (Object)groupId);
        BusinessInfo businessInfo = this.businessService.get(groupId);
        String topicName = businessInfo.getMqResourceObj();
        QueryTubeTopicRequest queryTubeTopicRequest = QueryTubeTopicRequest.builder().topicName(topicName).clusterId(this.clusterId).user(businessInfo.getCreator()).build();
        boolean topicExist = this.tubeMqOptService.queryTopicIsExist(queryTubeTopicRequest);
        Integer tryNumber = this.reTryConfigBean.getMaxAttempts();
        Long delay = this.reTryConfigBean.getDelay();
        while (!topicExist && (tryNumber = Integer.valueOf(tryNumber - 1)) > 0) {
            log.info("check whether the tube topic exists, try count={}", (Object)tryNumber);
            try {
                Thread.sleep(delay);
                delay = delay * (long)this.reTryConfigBean.getMultiplier().intValue();
                topicExist = this.tubeMqOptService.queryTopicIsExist(queryTubeTopicRequest);
            }
            catch (InterruptedException e) {
                log.error("check the tube topic exists error", (Throwable)e);
            }
        }
        AddTubeConsumeGroupRequest addTubeConsumeGroupRequest = new AddTubeConsumeGroupRequest();
        addTubeConsumeGroupRequest.setClusterId(this.clusterId.intValue());
        addTubeConsumeGroupRequest.setCreateUser(businessInfo.getCreator());
        AddTubeConsumeGroupRequest.GroupNameJsonSetBean groupNameJsonSetBean = new AddTubeConsumeGroupRequest.GroupNameJsonSetBean();
        groupNameJsonSetBean.setTopicName(topicName);
        String consumeGroupName = "sort_" + topicName + "_group";
        groupNameJsonSetBean.setGroupName(consumeGroupName);
        addTubeConsumeGroupRequest.setGroupNameJsonSet(Collections.singletonList(groupNameJsonSetBean));
        try {
            this.tubeMqOptService.createNewConsumerGroup(addTubeConsumeGroupRequest);
        }
        catch (Exception e) {
            throw new WorkflowListenerException("create tube consumer group for groupId=" + groupId + " error", (Throwable)e);
        }
        log.info("finish to create consumer group for {}", (Object)groupId);
        return ListenerResult.success();
    }

    public boolean async() {
        return true;
    }
}

