/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.thirdpart.mq;

import java.util.Collections;
import org.apache.inlong.manager.common.pojo.business.BusinessInfo;
import org.apache.inlong.manager.common.pojo.tubemq.AddTubeMqTopicRequest;
import org.apache.inlong.manager.service.core.BusinessService;
import org.apache.inlong.manager.service.thirdpart.mq.TubeMqOptService;
import org.apache.inlong.manager.service.workflow.business.BusinessResourceWorkflowForm;
import org.apache.inlong.manager.workflow.core.event.ListenerResult;
import org.apache.inlong.manager.workflow.core.event.task.TaskEvent;
import org.apache.inlong.manager.workflow.core.event.task.TaskEventListener;
import org.apache.inlong.manager.workflow.exception.WorkflowListenerException;
import org.apache.inlong.manager.workflow.model.WorkflowContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CreateTubeTopicTaskListener
implements TaskEventListener {
    private static final Logger log = LoggerFactory.getLogger(CreateTubeTopicTaskListener.class);
    @Autowired
    private TubeMqOptService tubeMqOptService;
    @Autowired
    private BusinessService businessService;

    public TaskEvent event() {
        return TaskEvent.COMPLETE;
    }

    public ListenerResult listen(WorkflowContext context) throws WorkflowListenerException {
        BusinessResourceWorkflowForm form = (BusinessResourceWorkflowForm)context.getProcessForm();
        log.info("begin create tube topic for groupId={}", (Object)form.getInlongGroupId());
        String groupId = form.getInlongGroupId();
        try {
            BusinessInfo businessInfo = this.businessService.get(groupId);
            String topicName = businessInfo.getMqResourceObj();
            AddTubeMqTopicRequest request = new AddTubeMqTopicRequest();
            request.setUser("inlong-manager");
            AddTubeMqTopicRequest.AddTopicTasksBean tasksBean = new AddTubeMqTopicRequest.AddTopicTasksBean();
            tasksBean.setTopicName(topicName);
            request.setAddTopicTasks(Collections.singletonList(tasksBean));
            this.tubeMqOptService.createNewTopic(request);
            log.info("finish to create tube topic for groupId={}", (Object)groupId);
        }
        catch (Exception e) {
            log.error("create tube topic for groupId={} error, exception {} ", new Object[]{groupId, e.getMessage(), e});
        }
        return ListenerResult.success();
    }

    public boolean async() {
        return false;
    }
}

