/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.workflow.business;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.inlong.manager.common.pojo.business.BusinessInfo;
import org.apache.inlong.manager.dao.entity.DataStreamEntity;
import org.apache.inlong.manager.dao.mapper.DataStreamEntityMapper;
import org.apache.inlong.manager.service.core.StorageService;
import org.apache.inlong.manager.service.thirdpart.hive.CreateHiveTableListener;
import org.apache.inlong.manager.service.thirdpart.mq.CreatePulsarGroupTaskListener;
import org.apache.inlong.manager.service.thirdpart.mq.CreatePulsarResourceTaskListener;
import org.apache.inlong.manager.service.thirdpart.mq.CreateTubeGroupTaskListener;
import org.apache.inlong.manager.service.thirdpart.mq.CreateTubeTopicTaskListener;
import org.apache.inlong.manager.service.thirdpart.sort.PushHiveConfigTaskListener;
import org.apache.inlong.manager.service.workflow.ProcessName;
import org.apache.inlong.manager.service.workflow.WorkflowDefinition;
import org.apache.inlong.manager.service.workflow.business.BusinessResourceWorkflowForm;
import org.apache.inlong.manager.service.workflow.business.listener.BusinessCompleteProcessListener;
import org.apache.inlong.manager.service.workflow.business.listener.BusinessFailedProcessListener;
import org.apache.inlong.manager.service.workflow.business.listener.InitBusinessInfoListener;
import org.apache.inlong.manager.workflow.core.event.process.ProcessEventListener;
import org.apache.inlong.manager.workflow.core.event.task.TaskEventListener;
import org.apache.inlong.manager.workflow.model.definition.Element;
import org.apache.inlong.manager.workflow.model.definition.EndEvent;
import org.apache.inlong.manager.workflow.model.definition.Process;
import org.apache.inlong.manager.workflow.model.definition.ServiceTask;
import org.apache.inlong.manager.workflow.model.definition.StartEvent;
import org.apache.inlong.manager.workflow.model.definition.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CreateBusinessWorkflowDefinition
implements WorkflowDefinition {
    private static final Logger log = LoggerFactory.getLogger(CreateBusinessWorkflowDefinition.class);
    @Autowired
    private InitBusinessInfoListener initBusinessInfoListener;
    @Autowired
    private BusinessCompleteProcessListener businessCompleteProcessListener;
    @Autowired
    private BusinessFailedProcessListener businessFailedProcessListener;
    @Autowired
    private CreateTubeTopicTaskListener createTubeTopicTaskListener;
    @Autowired
    private CreateTubeGroupTaskListener createTubeGroupTaskListener;
    @Autowired
    private CreatePulsarResourceTaskListener createPulsarResourceTaskListener;
    @Autowired
    private CreatePulsarGroupTaskListener createPulsarGroupTaskListener;
    @Autowired
    private CreateHiveTableListener createHiveTableListener;
    @Autowired
    private PushHiveConfigTaskListener pushHiveConfigTaskListener;
    @Autowired
    private StorageService storageService;
    @Autowired
    private DataStreamEntityMapper streamMapper;

    @Override
    public Process defineProcess() {
        Process process = new Process();
        process.addListener((ProcessEventListener)this.initBusinessInfoListener);
        process.addListener((ProcessEventListener)this.businessCompleteProcessListener);
        process.addListener((ProcessEventListener)this.businessFailedProcessListener);
        process.setType("Business Resource Creation");
        process.setName(this.getProcessName().name());
        process.setDisplayName(this.getProcessName().getDisplayName());
        process.setFormClass(BusinessResourceWorkflowForm.class);
        process.setVersion(1);
        process.setHidden(Boolean.valueOf(true));
        StartEvent startEvent = new StartEvent();
        process.setStartEvent(startEvent);
        EndEvent endEvent = new EndEvent();
        process.setEndEvent(endEvent);
        ServiceTask createTubeTopicTask = new ServiceTask();
        createTubeTopicTask.setSkipResolver(c -> {
            BusinessResourceWorkflowForm form = (BusinessResourceWorkflowForm)c.getProcessForm();
            BusinessInfo businessInfo = form.getBusinessInfo();
            if ("TUBE".equalsIgnoreCase(businessInfo.getMiddlewareType())) {
                return false;
            }
            log.warn("not need to create tube resource for groupId={}, as the middleware type is {}", (Object)businessInfo.getMiddlewareType(), (Object)form.getInlongGroupId());
            return true;
        });
        createTubeTopicTask.setName("createTubeTopic");
        createTubeTopicTask.setDisplayName("Business-CreateTubeTopic");
        createTubeTopicTask.addListener((TaskEventListener)this.createTubeTopicTaskListener);
        process.addTask((Task)createTubeTopicTask);
        ServiceTask createTubeConsumerTask = new ServiceTask();
        createTubeConsumerTask.setSkipResolver(c -> {
            BusinessResourceWorkflowForm form = (BusinessResourceWorkflowForm)c.getProcessForm();
            String middlewareType = form.getBusinessInfo().getMiddlewareType();
            if ("TUBE".equalsIgnoreCase(middlewareType)) {
                return false;
            }
            log.warn("no need to create tube resource for groupId={}, as the middleware type is {}", (Object)form.getInlongGroupId(), (Object)middlewareType);
            return true;
        });
        createTubeConsumerTask.setName("createConsumerGroup");
        createTubeConsumerTask.setDisplayName("Business-CreateTubeConsumer");
        createTubeConsumerTask.addListener((TaskEventListener)this.createTubeGroupTaskListener);
        process.addTask((Task)createTubeConsumerTask);
        ServiceTask createPulsarResourceTask = new ServiceTask();
        createPulsarResourceTask.setSkipResolver(c -> {
            BusinessResourceWorkflowForm form = (BusinessResourceWorkflowForm)c.getProcessForm();
            String middlewareType = form.getBusinessInfo().getMiddlewareType();
            if ("PULSAR".equalsIgnoreCase(middlewareType)) {
                return false;
            }
            log.warn("no need to create pulsar resource for groupId={}, as the middlewareType={}", (Object)form.getInlongGroupId(), (Object)middlewareType);
            return true;
        });
        createPulsarResourceTask.setName("createPulsarResource");
        createPulsarResourceTask.setDisplayName("Business-CreatePulsarResource");
        createPulsarResourceTask.addListener((TaskEventListener)this.createPulsarResourceTaskListener);
        process.addTask((Task)createPulsarResourceTask);
        ServiceTask createPulsarSubscriptionTask = new ServiceTask();
        createPulsarSubscriptionTask.setSkipResolver(c -> {
            BusinessResourceWorkflowForm form = (BusinessResourceWorkflowForm)c.getProcessForm();
            String middlewareType = form.getBusinessInfo().getMiddlewareType();
            if ("PULSAR".equalsIgnoreCase(middlewareType)) {
                return false;
            }
            log.warn("no need to create pulsar subscription group for groupId={}, as the middlewareType={}", (Object)form.getInlongGroupId(), (Object)middlewareType);
            return true;
        });
        createPulsarSubscriptionTask.setName("createPulsarSubscriptionTask");
        createPulsarSubscriptionTask.setDisplayName("Business-CreatePulsarSubscription");
        createPulsarSubscriptionTask.addListener((TaskEventListener)this.createPulsarGroupTaskListener);
        process.addTask((Task)createPulsarSubscriptionTask);
        ServiceTask createHiveTablesTask = new ServiceTask();
        createHiveTablesTask.setSkipResolver(c -> {
            BusinessResourceWorkflowForm form = (BusinessResourceWorkflowForm)c.getProcessForm();
            String groupId = form.getInlongGroupId();
            List<String> dsForHive = this.storageService.filterStreamIdByStorageType(groupId, "HIVE", this.streamMapper.selectByGroupId(groupId).stream().map(DataStreamEntity::getInlongStreamId).collect(Collectors.toList()));
            if (CollectionUtils.isEmpty(dsForHive)) {
                log.warn("groupId={} streamId={} does not have storage, skip to create hive table ", (Object)groupId, (Object)form.getInlongStreamId());
                return true;
            }
            return false;
        });
        createHiveTablesTask.setName("createHiveTableTask");
        createHiveTablesTask.setDisplayName("Business-CreateHiveTable");
        createHiveTablesTask.addListener((TaskEventListener)this.createHiveTableListener);
        process.addTask((Task)createHiveTablesTask);
        ServiceTask pushSortConfig = new ServiceTask();
        pushSortConfig.setName("pushSortConfig");
        pushSortConfig.setDisplayName("Business-PushSortConfig");
        pushSortConfig.addListener((TaskEventListener)this.pushHiveConfigTaskListener);
        process.addTask((Task)pushSortConfig);
        startEvent.addNext((Element)createTubeTopicTask);
        createTubeTopicTask.addNext((Element)createTubeConsumerTask);
        createTubeConsumerTask.addNext((Element)createPulsarResourceTask);
        createPulsarResourceTask.addNext((Element)createPulsarSubscriptionTask);
        createPulsarSubscriptionTask.addNext((Element)createHiveTablesTask);
        createHiveTablesTask.addNext((Element)pushSortConfig);
        pushSortConfig.addNext((Element)endEvent);
        return process;
    }

    @Override
    public ProcessName getProcessName() {
        return ProcessName.CREATE_BUSINESS_RESOURCE;
    }
}

