/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.workflow.business.listener;

import org.apache.inlong.manager.common.enums.EntityStatus;
import org.apache.inlong.manager.dao.mapper.SourceFileDetailEntityMapper;
import org.apache.inlong.manager.service.core.BusinessService;
import org.apache.inlong.manager.service.core.DataStreamService;
import org.apache.inlong.manager.service.workflow.business.BusinessResourceWorkflowForm;
import org.apache.inlong.manager.workflow.core.event.ListenerResult;
import org.apache.inlong.manager.workflow.core.event.process.ProcessEvent;
import org.apache.inlong.manager.workflow.core.event.process.ProcessEventListener;
import org.apache.inlong.manager.workflow.exception.WorkflowListenerException;
import org.apache.inlong.manager.workflow.model.WorkflowContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BusinessCompleteProcessListener
implements ProcessEventListener {
    private static final Logger log = LoggerFactory.getLogger(BusinessCompleteProcessListener.class);
    @Autowired
    private BusinessService businessService;
    @Autowired
    private DataStreamService dataStreamService;
    @Autowired
    private SourceFileDetailEntityMapper fileDetailMapper;

    public ProcessEvent event() {
        return ProcessEvent.COMPLETE;
    }

    public ListenerResult listen(WorkflowContext context) throws WorkflowListenerException {
        BusinessResourceWorkflowForm form = (BusinessResourceWorkflowForm)context.getProcessForm();
        String groupId = form.getInlongGroupId();
        String username = context.getApplicant();
        this.businessService.updateStatus(groupId, EntityStatus.BIZ_CONFIG_SUCCESSFUL.getCode(), username);
        this.dataStreamService.updateStatus(groupId, null, EntityStatus.DATA_STREAM_CONFIG_SUCCESSFUL.getCode(), username);
        this.fileDetailMapper.updateStatusAfterApprove(groupId, null, EntityStatus.AGENT_ADD.getCode(), username);
        return ListenerResult.success();
    }

    public boolean async() {
        return false;
    }
}

