/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.workflow.business.listener;

import java.util.List;
import org.apache.inlong.manager.common.pojo.business.BusinessApproveInfo;
import org.apache.inlong.manager.common.pojo.datastream.DataStreamApproveInfo;
import org.apache.inlong.manager.service.core.BusinessService;
import org.apache.inlong.manager.service.core.DataStreamService;
import org.apache.inlong.manager.service.workflow.business.BusinessAdminApproveForm;
import org.apache.inlong.manager.workflow.core.event.ListenerResult;
import org.apache.inlong.manager.workflow.core.event.task.TaskEvent;
import org.apache.inlong.manager.workflow.core.event.task.TaskEventListener;
import org.apache.inlong.manager.workflow.exception.WorkflowListenerException;
import org.apache.inlong.manager.workflow.model.WorkflowContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BusinessPassTaskListener
implements TaskEventListener {
    private static final Logger log = LoggerFactory.getLogger(BusinessPassTaskListener.class);
    @Autowired
    private BusinessService businessService;
    @Autowired
    private DataStreamService dataStreamService;

    public TaskEvent event() {
        return TaskEvent.APPROVE;
    }

    public ListenerResult listen(WorkflowContext context) throws WorkflowListenerException {
        BusinessAdminApproveForm approveForm = (BusinessAdminApproveForm)context.getActionContext().getForm();
        BusinessApproveInfo approveInfo = approveForm.getBusinessApproveInfo();
        this.businessService.updateAfterApprove(approveInfo, context.getApplicant());
        List<DataStreamApproveInfo> streamApproveInfoList = approveForm.getStreamApproveInfoList();
        this.dataStreamService.updateAfterApprove(streamApproveInfoList, context.getApplicant());
        return ListenerResult.success();
    }

    public boolean async() {
        return false;
    }
}

