/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.workflow.business.listener;

import org.apache.inlong.manager.common.enums.EntityStatus;
import org.apache.inlong.manager.service.core.BusinessService;
import org.apache.inlong.manager.service.workflow.business.NewBusinessWorkflowForm;
import org.apache.inlong.manager.workflow.core.event.ListenerResult;
import org.apache.inlong.manager.workflow.core.event.process.ProcessEvent;
import org.apache.inlong.manager.workflow.core.event.process.ProcessEventListener;
import org.apache.inlong.manager.workflow.exception.WorkflowListenerException;
import org.apache.inlong.manager.workflow.model.WorkflowContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BusinessRejectProcessListener
implements ProcessEventListener {
    private static final Logger log = LoggerFactory.getLogger(BusinessRejectProcessListener.class);
    @Autowired
    private BusinessService businessService;

    public ProcessEvent event() {
        return ProcessEvent.REJECT;
    }

    public ListenerResult listen(WorkflowContext context) throws WorkflowListenerException {
        NewBusinessWorkflowForm form = (NewBusinessWorkflowForm)context.getProcessForm();
        String groupId = form.getInlongGroupId();
        String username = context.getApplicant();
        this.businessService.updateStatus(groupId, EntityStatus.BIZ_APPROVE_REJECTED.getCode(), username);
        return ListenerResult.success();
    }

    public boolean async() {
        return false;
    }
}

