/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.workflow.consumption.listener;

import com.alibaba.druid.util.StringUtils;
import org.apache.inlong.manager.common.enums.BizErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.pojo.consumption.ConsumptionInfo;
import org.apache.inlong.manager.service.core.ConsumptionService;
import org.apache.inlong.manager.service.workflow.consumption.ConsumptionAdminApproveForm;
import org.apache.inlong.manager.service.workflow.consumption.NewConsumptionWorkflowForm;
import org.apache.inlong.manager.workflow.core.event.ListenerResult;
import org.apache.inlong.manager.workflow.core.event.task.TaskEvent;
import org.apache.inlong.manager.workflow.core.event.task.TaskEventListener;
import org.apache.inlong.manager.workflow.exception.WorkflowListenerException;
import org.apache.inlong.manager.workflow.model.WorkflowContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConsumptionPassTaskListener
implements TaskEventListener {
    private static final Logger log = LoggerFactory.getLogger(ConsumptionPassTaskListener.class);
    @Autowired
    private ConsumptionService consumptionService;

    public TaskEvent event() {
        return TaskEvent.APPROVE;
    }

    public ListenerResult listen(WorkflowContext context) throws WorkflowListenerException {
        NewConsumptionWorkflowForm form = (NewConsumptionWorkflowForm)context.getProcessForm();
        ConsumptionAdminApproveForm approveForm = (ConsumptionAdminApproveForm)context.getActionContext().getForm();
        ConsumptionInfo info = form.getConsumptionInfo();
        if (StringUtils.equals((String)approveForm.getConsumerGroupId(), (String)info.getConsumerGroupId())) {
            return ListenerResult.success((String)"The consumer group name has not been modified");
        }
        boolean exist = this.consumptionService.isConsumerGroupIdExists(approveForm.getConsumerGroupId(), info.getId());
        if (exist) {
            log.error("consumerGroupId already exist! duplicate :{}", (Object)approveForm.getConsumerGroupId());
            throw new BusinessException(BizErrorCodeEnum.CONSUMER_GROUP_NAME_DUPLICATED);
        }
        return ListenerResult.success((String)("Consumer group name from" + info.getConsumerGroupId() + "change to " + approveForm.getConsumerGroupId()));
    }

    public boolean async() {
        return false;
    }
}

