/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.workflow.stream;

import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.inlong.manager.service.core.StorageService;
import org.apache.inlong.manager.service.thirdpart.hive.CreateHiveTableForStreamListener;
import org.apache.inlong.manager.service.thirdpart.mq.CreatePulsarGroupForStreamTaskListener;
import org.apache.inlong.manager.service.thirdpart.mq.CreatePulsarTopicForStreamTaskListener;
import org.apache.inlong.manager.service.thirdpart.sort.PushHiveConfigTaskListener;
import org.apache.inlong.manager.service.workflow.ProcessName;
import org.apache.inlong.manager.service.workflow.WorkflowDefinition;
import org.apache.inlong.manager.service.workflow.business.BusinessResourceWorkflowForm;
import org.apache.inlong.manager.service.workflow.business.listener.InitBusinessInfoListener;
import org.apache.inlong.manager.service.workflow.stream.StreamCompleteProcessListener;
import org.apache.inlong.manager.service.workflow.stream.StreamFailedProcessListener;
import org.apache.inlong.manager.workflow.core.event.process.ProcessEventListener;
import org.apache.inlong.manager.workflow.core.event.task.TaskEventListener;
import org.apache.inlong.manager.workflow.model.definition.Element;
import org.apache.inlong.manager.workflow.model.definition.EndEvent;
import org.apache.inlong.manager.workflow.model.definition.Process;
import org.apache.inlong.manager.workflow.model.definition.ServiceTask;
import org.apache.inlong.manager.workflow.model.definition.StartEvent;
import org.apache.inlong.manager.workflow.model.definition.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CreateStreamWorkflowDefinition
implements WorkflowDefinition {
    private static final Logger log = LoggerFactory.getLogger(CreateStreamWorkflowDefinition.class);
    @Autowired
    private StorageService storageService;
    @Autowired
    private InitBusinessInfoListener initBusinessInfoListener;
    @Autowired
    private StreamFailedProcessListener streamFailedProcessListener;
    @Autowired
    private StreamCompleteProcessListener streamCompleteProcessListener;
    @Autowired
    private CreateHiveTableForStreamListener createHiveTableListener;
    @Autowired
    private PushHiveConfigTaskListener pushHiveConfigTaskListener;
    @Autowired
    private CreatePulsarTopicForStreamTaskListener createPulsarTopicTaskListener;
    @Autowired
    private CreatePulsarGroupForStreamTaskListener createPulsarGroupTaskListener;

    @Override
    public Process defineProcess() {
        Process process = new Process();
        process.addListener((ProcessEventListener)this.initBusinessInfoListener);
        process.addListener((ProcessEventListener)this.streamFailedProcessListener);
        process.addListener((ProcessEventListener)this.streamCompleteProcessListener);
        process.setType("Data stream access resource creation");
        process.setName(this.getProcessName().name());
        process.setDisplayName(this.getProcessName().getDisplayName());
        process.setFormClass(BusinessResourceWorkflowForm.class);
        process.setVersion(1);
        process.setHidden(Boolean.valueOf(true));
        StartEvent startEvent = new StartEvent();
        process.setStartEvent(startEvent);
        EndEvent endEvent = new EndEvent();
        process.setEndEvent(endEvent);
        ServiceTask createPulsarTopicTask = new ServiceTask();
        createPulsarTopicTask.setSkipResolver(c -> {
            BusinessResourceWorkflowForm form = (BusinessResourceWorkflowForm)c.getProcessForm();
            String middlewareType = form.getBusinessInfo().getMiddlewareType();
            if ("PULSAR".equalsIgnoreCase(middlewareType)) {
                return false;
            }
            log.warn("no need to create pulsar topic for groupId={}, streamId={}, as the middlewareType={}", new Object[]{form.getInlongGroupId(), form.getInlongStreamId(), middlewareType});
            return true;
        });
        createPulsarTopicTask.setName("createPulsarTopic");
        createPulsarTopicTask.setDisplayName("Stream-CreatePulsarTopic");
        createPulsarTopicTask.addListener((TaskEventListener)this.createPulsarTopicTaskListener);
        process.addTask((Task)createPulsarTopicTask);
        ServiceTask createPulsarSubscriptionGroupTask = new ServiceTask();
        createPulsarSubscriptionGroupTask.setSkipResolver(c -> {
            BusinessResourceWorkflowForm form = (BusinessResourceWorkflowForm)c.getProcessForm();
            String middlewareType = form.getBusinessInfo().getMiddlewareType();
            if ("PULSAR".equalsIgnoreCase(middlewareType)) {
                return false;
            }
            log.warn("no need to create pulsar subscription for groupId={}, streamId={}, as the middlewareType={}", new Object[]{form.getInlongGroupId(), form.getInlongStreamId(), middlewareType});
            return true;
        });
        createPulsarSubscriptionGroupTask.setName("createPulsarSubscription");
        createPulsarSubscriptionGroupTask.setDisplayName("Stream-CreatePulsarSubscription");
        createPulsarSubscriptionGroupTask.addListener((TaskEventListener)this.createPulsarGroupTaskListener);
        process.addTask((Task)createPulsarSubscriptionGroupTask);
        ServiceTask createHiveTableTask = new ServiceTask();
        createHiveTableTask.setSkipResolver(c -> {
            String streamId;
            BusinessResourceWorkflowForm form = (BusinessResourceWorkflowForm)c.getProcessForm();
            String groupId = form.getInlongGroupId();
            List<String> dsForHive = this.storageService.filterStreamIdByStorageType(groupId, "HIVE", Collections.singletonList(streamId = form.getInlongStreamId()));
            if (CollectionUtils.isEmpty(dsForHive)) {
                log.warn("business [{}] adn data stream [{}] does not have storage, skip create hive table", (Object)groupId, (Object)streamId);
                return true;
            }
            return false;
        });
        createHiveTableTask.setName("createHiveTable");
        createHiveTableTask.setDisplayName("Stream-CreateHiveTable");
        createHiveTableTask.addListener((TaskEventListener)this.createHiveTableListener);
        process.addTask((Task)createHiveTableTask);
        ServiceTask pushSortConfig = new ServiceTask();
        pushSortConfig.setName("pushSortConfig");
        pushSortConfig.setDisplayName("Stream-PushSortConfig");
        pushSortConfig.addListener((TaskEventListener)this.pushHiveConfigTaskListener);
        process.addTask((Task)pushSortConfig);
        startEvent.addNext((Element)createPulsarTopicTask);
        createPulsarTopicTask.addNext((Element)createPulsarSubscriptionGroupTask);
        createPulsarSubscriptionGroupTask.addNext((Element)createHiveTableTask);
        createHiveTableTask.addNext((Element)pushSortConfig);
        pushSortConfig.addNext((Element)endEvent);
        return process;
    }

    @Override
    public ProcessName getProcessName() {
        return ProcessName.CREATE_DATASTREAM_RESOURCE;
    }
}

