/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.core.impl;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.TreeMap;
import org.apache.inlong.manager.common.pojo.agent.AgentSysConfig;
import org.apache.inlong.manager.common.pojo.agent.AgentSysconfRequest;
import org.apache.inlong.manager.common.util.AgentConstants;
import org.apache.inlong.manager.dao.entity.AgentSysConfigEntity;
import org.apache.inlong.manager.dao.mapper.AgentSysConfigEntityMapper;
import org.apache.inlong.manager.service.core.AgentSysConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AgentSysConfigServiceImpl
implements AgentSysConfigService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgentSysConfigServiceImpl.class);
    @Autowired
    private AgentSysConfigEntityMapper agentSysConfigEntityMapper;

    @Override
    public AgentSysConfig getAgentSysConfig(AgentSysconfRequest request) {
        AgentSysConfigEntity entity = this.agentSysConfigEntityMapper.selectByPrimaryKey(request.getAgentIp());
        if (entity != null) {
            AgentSysConfig agentSysConfig = AgentSysConfig.builder().msgQueueSize((long)entity.getMsgQueueSize().intValue()).clearDayOffset(entity.getClearDayOffset().intValue()).bufferSize(entity.getBuffersize().intValue()).flushEventTimeoutMillSec(entity.getFlushEventTimeoutMillSec().intValue()).threadManagerSleepInterval(entity.getThreadManagerSleepInterval().intValue()).sendRunnableSize(entity.getSendRunnableSize().intValue()).minRetryThreads(entity.getMinRetryThreads().intValue()).clearIntervalSec((long)entity.getClearIntervalSec().intValue()).maxReaderCnt(entity.getMaxReaderCnt().intValue()).sendTimeoutMillSec(entity.getSendTimeoutMillSec().intValue()).bufferSizeInBytes(entity.getBufferSizeInBytes().intValue()).maxRetryThreads(entity.getMaxRetryThreads().intValue()).dbPath(entity.getDbPath()).scanIntervalSec(entity.getScanIntervalSec().intValue()).compress(entity.getCompress() == 1).isCalcMd5(entity.getIsCalmd5() == 1).ip(entity.getIp()).flowSize((long)entity.getFlowSize().intValue()).onelineSize(entity.getOnelineSize().intValue()).eventCheckInterval(entity.getEventCheckInterval().intValue()).confRefreshIntervalSecs(entity.getConfRefreshIntervalSecs().intValue()).statIntervalSec(entity.getStatIntervalSec().intValue()).msgSize(entity.getMsgSize().intValue()).batchSize(entity.getBatchSize().intValue()).agentRpcReconnectTime(entity.getAgentRpcReconnectTime().intValue()).md5(null).build();
            return agentSysConfig;
        }
        throw new IllegalArgumentException("do not get config from database");
    }

    public String calcMd5(AgentSysConfigEntity entity) {
        TreeMap<String, String> propertiesMap = new TreeMap<String, String>();
        propertiesMap.put(AgentConstants.NAME, "inlong_agent");
        propertiesMap.put(AgentConstants.IP, entity.getIp());
        propertiesMap.put(AgentConstants.DB_PATH, entity.getDbPath());
        propertiesMap.put(AgentConstants.SCAN_INTERVAL_SEC, "" + entity.getScanIntervalSec());
        propertiesMap.put(AgentConstants.BATCH_SIZE, "" + entity.getBatchSize());
        propertiesMap.put(AgentConstants.MSG_SIZE, "" + entity.getMsgSize());
        propertiesMap.put(AgentConstants.SEND_RUNNABLEC_SIZE, "" + entity.getSendRunnableSize());
        propertiesMap.put(AgentConstants.MSG_QUEUE_SIZE, "" + entity.getMsgQueueSize());
        propertiesMap.put(AgentConstants.ONELINE_SIZE, "" + entity.getOnelineSize());
        propertiesMap.put(AgentConstants.STAT_INTERVAL_SEC, "" + entity.getStatIntervalSec());
        propertiesMap.put(AgentConstants.MAX_READER_CNT, "" + entity.getMaxReaderCnt());
        propertiesMap.put(AgentConstants.COMPRESS, "" + (entity.getCompress() == 1));
        propertiesMap.put(AgentConstants.IS_SEND, "" + AgentConstants.DEFAULT_IS_SEND);
        propertiesMap.put(AgentConstants.IS_PACKAGE, "" + AgentConstants.DEFAULT_BPACKAGE);
        propertiesMap.put(AgentConstants.BUFFER_SIZE, "" + entity.getBuffersize());
        propertiesMap.put(AgentConstants.IS_WRITE, "" + AgentConstants.DEFAULT_IS_WRITE);
        propertiesMap.put(AgentConstants.IS_CALC_MD5, "" + (entity.getIsCalmd5() == 1));
        propertiesMap.put(AgentConstants.SEND_TIMEOUT_MILL_SEC, "" + entity.getSendTimeoutMillSec());
        propertiesMap.put(AgentConstants.FLUSH_EVENT_TIMEOUT_MILL_SEC, "" + entity.getFlushEventTimeoutMillSec());
        propertiesMap.put(AgentConstants.RPC_CLIENT_RECONNECT, "" + entity.getAgentRpcReconnectTime());
        propertiesMap.put(AgentConstants.FLOW_SIZE, "" + entity.getFlowSize());
        propertiesMap.put(AgentConstants.CLEAR_INTERVAL_SEC, "" + entity.getClearIntervalSec());
        propertiesMap.put(AgentConstants.CLEAR_DAY_OFFSET, "" + entity.getClearDayOffset());
        propertiesMap.put(AgentConstants.MIN_RETRY_THREADS, "" + entity.getMinRetryThreads());
        propertiesMap.put(AgentConstants.MAX_RETRY_THREADS, "" + entity.getMaxRetryThreads());
        propertiesMap.put(AgentConstants.EVENT_CHECK_INTERVAL, "" + entity.getEventCheckInterval());
        propertiesMap.put(AgentConstants.THREAD_MANAGER_SLEEP_INTERVAL, "" + entity.getThreadManagerSleepInterval());
        propertiesMap.put(AgentConstants.BUFFER_SIZE_IN_BYTES, "" + entity.getBufferSizeInBytes());
        propertiesMap.put(AgentConstants.CONF_REFRESH_INTERVAL_SECS, "" + entity.getConfRefreshIntervalSecs());
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        for (Map.Entry entry : propertiesMap.entrySet()) {
            md.update(((String)entry.getKey()).getBytes(), 0, ((String)entry.getKey()).length());
            md.update(((String)entry.getValue()).getBytes(), 0, ((String)entry.getValue()).length());
        }
        byte[] mdbytes = md.digest();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < mdbytes.length; ++i) {
            sb.append(Integer.toString((mdbytes[i] & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString();
    }
}

