/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.core.impl;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.inlong.manager.common.enums.EntityStatus;
import org.apache.inlong.manager.common.pojo.commonserver.CommonDbServerInfo;
import org.apache.inlong.manager.common.pojo.commonserver.CommonDbServerListVo;
import org.apache.inlong.manager.common.pojo.commonserver.CommonDbServerPageRequest;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.LoginUserUtil;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.CommonDbServerEntity;
import org.apache.inlong.manager.dao.mapper.CommonDbServerEntityMapper;
import org.apache.inlong.manager.service.core.CommonDBServerService;
import org.apache.inlong.manager.service.core.builder.CommonDBServerInfoBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CommonDBServerServiceImpl
implements CommonDBServerService {
    private static final Logger log = LoggerFactory.getLogger(CommonDBServerServiceImpl.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(CommonDBServerServiceImpl.class);
    @Autowired
    private CommonDbServerEntityMapper commonDbServerMapper;

    public static boolean checkStrLen(String text, int maxLength) {
        return text != null && text.length() > maxLength;
    }

    public static boolean ipCheck(String text) {
        if (text != null && !text.isEmpty()) {
            String regex = "^(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|[1-9])\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)$";
            return text.matches(regex);
        }
        return false;
    }

    @Override
    public int create(CommonDbServerInfo info) throws Exception {
        LOGGER.debug("create CommonDbServer info=[{}]", (Object)info);
        this.checkValidity(info);
        List entities = this.commonDbServerMapper.selectByUsernameAndIpPort(info.getUsername(), info.getDbType(), info.getDbServerIp(), info.getPort());
        if (entities != null && entities.size() > 0) {
            for (CommonDbServerEntity entry : entities) {
                if (entry.getIsDeleted() != 0) continue;
                throw new IllegalArgumentException("Already have a CommonDbServer [" + entry.getId() + "] have the same username/dbType/dbServerIp/port = [" + entry.getUsername() + "/" + entry.getDbType() + "/" + entry.getDbServerIp() + "/" + entry.getPort() + "]");
            }
        }
        CommonDbServerEntity record = (CommonDbServerEntity)CommonBeanUtils.copyProperties((Object)info, CommonDbServerEntity::new);
        record.setStatus(Integer.valueOf(0));
        String userName = LoginUserUtil.getLoginUserDetail().getUserName();
        record.setCreator(userName);
        record.setModifier(userName);
        Date now = new Date();
        record.setCreateTime(now);
        record.setModifyTime(now);
        record.setIsDeleted(EntityStatus.UN_DELETED.getCode());
        int success = this.commonDbServerMapper.insert(record);
        Preconditions.checkTrue((success == 1 ? 1 : 0) != 0, (String)"insert into db failed");
        LOGGER.debug("success create CommonDbServer info=[{}] into db entry id={}", (Object)info, (Object)record.getId());
        return record.getId();
    }

    private void checkValidity(CommonDbServerInfo commonDbServerInfo) throws Exception {
        if (commonDbServerInfo.getId() > 0) {
            throw new IllegalArgumentException("CommonDbServer id [" + commonDbServerInfo.getId() + "] has already exists, please check");
        }
        if (!CommonDBServerServiceImpl.ipCheck(commonDbServerInfo.getDbServerIp())) {
            throw new IllegalArgumentException("CommonDbServer dbServerIp = [" + commonDbServerInfo.getDbServerIp() + "] is not valid ip, please check");
        }
        this.checkStrFieldLength(commonDbServerInfo);
    }

    private void checkStrFieldLength(CommonDbServerInfo commonDbServerInfo) throws Exception {
        if (CommonDBServerServiceImpl.checkStrLen(commonDbServerInfo.getConnectionName(), 128)) {
            throw new IllegalArgumentException("CommonDbServerInfo connectionName = [" + commonDbServerInfo.getConnectionName() + "] length is " + commonDbServerInfo.getConnectionName().length() + " and too large, The maximum size for the field length is 128.");
        }
        if (CommonDBServerServiceImpl.checkStrLen(commonDbServerInfo.getDbType(), 128)) {
            throw new IllegalArgumentException("CommonDbServerInfo dbType = [" + commonDbServerInfo.getDbType() + "] length is " + commonDbServerInfo.getDbType().length() + " and too large, The maximum size for the field length is 128.");
        }
        if (CommonDBServerServiceImpl.checkStrLen(commonDbServerInfo.getDbName(), 128)) {
            throw new IllegalArgumentException("CommonDbServerInfo dbName = [" + commonDbServerInfo.getDbName() + "] length is " + commonDbServerInfo.getDbName().length() + " and too large, The maximum size for the field length is 128.");
        }
        if (CommonDBServerServiceImpl.checkStrLen(commonDbServerInfo.getUsername(), 64)) {
            throw new IllegalArgumentException("CommonDbServerInfo username = [" + commonDbServerInfo.getUsername() + "] length is " + commonDbServerInfo.getUsername().length() + " and too large, The maximum size for the field length is 64.");
        }
        if (CommonDBServerServiceImpl.checkStrLen(commonDbServerInfo.getPassword(), 64)) {
            throw new IllegalArgumentException("CommonDbServerInfo password = [" + commonDbServerInfo.getPassword() + "] length is " + commonDbServerInfo.getPassword().length() + " and too large, The maximum size for the field length is 64.");
        }
        if (CommonDBServerServiceImpl.checkStrLen(commonDbServerInfo.getInCharges(), 512)) {
            throw new IllegalArgumentException("CommonDbServerInfo inCharges = [" + commonDbServerInfo.getInCharges() + "] length is " + commonDbServerInfo.getInCharges().length() + " and too large, The maximum size for the field length is 512.");
        }
        if (CommonDBServerServiceImpl.checkStrLen(commonDbServerInfo.getDbDescription(), 256)) {
            throw new IllegalArgumentException("CommonDbServerInfo dbDescription = [" + commonDbServerInfo.getDbDescription() + "] length is " + commonDbServerInfo.getDbDescription().length() + " and too large, The maximum size for the field length is 256.");
        }
        if (CommonDBServerServiceImpl.checkStrLen(commonDbServerInfo.getVisiblePerson(), 1024)) {
            throw new IllegalArgumentException("CommonDbServerInfo visiblePerson = [" + commonDbServerInfo.getVisiblePerson() + "] length is " + commonDbServerInfo.getVisiblePerson().length() + " and too large, The maximum size for the field length is 1024.");
        }
        if (CommonDBServerServiceImpl.checkStrLen(commonDbServerInfo.getVisibleGroup(), 1024)) {
            throw new IllegalArgumentException("CommonDbServerInfo visibleGroup = [" + commonDbServerInfo.getVisibleGroup() + "] length is " + commonDbServerInfo.getVisibleGroup().length() + " and too large, The maximum size for the field length is 1024.");
        }
    }

    @Override
    public CommonDbServerInfo get(int id) throws Exception {
        CommonDbServerEntity entity = this.commonDbServerMapper.selectByPrimaryKey(Integer.valueOf(id));
        Preconditions.checkNotNull((Object)entity, (String)("CommonDbServerEntity not found by id=" + id));
        Preconditions.checkTrue((entity.getIsDeleted() == 0 ? 1 : 0) != 0, (String)("CommonDbServerEntity has been deleted, id=" + id));
        String userName = LoginUserUtil.getLoginUserDetail().getUserName();
        if (this.checkVisible(userName, entity)) {
            return CommonDBServerInfoBuilder.buildInfoFromEntity(entity);
        }
        throw new IllegalArgumentException(userName + " has no right to get id=" + id + ", please contact " + entity.getCreator());
    }

    @Override
    public void delete(int id) throws Exception {
        String userName = LoginUserUtil.getLoginUserDetail().getUserName();
        LOGGER.info("user={} delete CommonDbServerInfo id=[{}]", (Object)userName, (Object)id);
        CommonDbServerEntity entity = this.commonDbServerMapper.selectByPrimaryKey(Integer.valueOf(id));
        Preconditions.checkNotNull((Object)entity, (String)("CommonDbServerEntity not found by id=" + id));
        Preconditions.checkTrue((entity.getIsDeleted() == 0 ? 1 : 0) != 0, (String)("CommonDbServerEntity has been deleted, id=" + id));
        if (!this.checkCreator(userName, entity)) {
            throw new IllegalArgumentException(userName + " is not creator, has no right to delete id=" + id + ", please contact " + entity.getCreator());
        }
        Date now = new Date();
        entity.setIsDeleted(Integer.valueOf(1));
        entity.setModifier(userName);
        entity.setModifyTime(now);
        int success = this.commonDbServerMapper.updateByPrimaryKey(entity);
        Preconditions.checkTrue((success == 1 ? 1 : 0) != 0, (String)("DataBase delete id = " + id + " failed "));
        LOGGER.info("user={} success delete CommonDbServer id={}", (Object)userName, (Object)id);
    }

    @Override
    public CommonDbServerInfo update(CommonDbServerInfo commonDbServerInfo) throws Exception {
        String userName = LoginUserUtil.getLoginUserDetail().getUserName();
        LOGGER.info("user={} update CommonDbServerInfo info=[{}]", (Object)userName, (Object)commonDbServerInfo);
        CommonDbServerEntity entity = this.commonDbServerMapper.selectByPrimaryKey(Integer.valueOf(commonDbServerInfo.getId()));
        Preconditions.checkNotNull((Object)entity, (String)("CommonDbServerEntity not found by id=" + commonDbServerInfo.getId()));
        Preconditions.checkTrue((entity.getIsDeleted() == 0 ? 1 : 0) != 0, (String)("CommonDbServerEntity has been deleted, id=" + commonDbServerInfo.getId()));
        if (commonDbServerInfo.getUsername() != null && !commonDbServerInfo.getUsername().equals(entity.getUsername())) {
            throw new IllegalArgumentException(entity.getId() + " username=" + entity.getUsername() + " can not be updated.");
        }
        if (commonDbServerInfo.getDbType() != null && !commonDbServerInfo.getDbType().equals(entity.getDbType())) {
            throw new IllegalArgumentException(entity.getId() + " dbType=" + entity.getDbType() + " can not be updated.");
        }
        if (commonDbServerInfo.getDbServerIp() != null && !commonDbServerInfo.getDbServerIp().equals(entity.getDbServerIp())) {
            throw new IllegalArgumentException(entity.getId() + " dbServerIp=" + entity.getDbServerIp() + " can not be updated.");
        }
        if (commonDbServerInfo.getPort() != 0 && commonDbServerInfo.getPort() != entity.getPort().intValue()) {
            throw new IllegalArgumentException(entity.getId() + " port = " + entity.getPort() + " can not be updated.");
        }
        commonDbServerInfo.setPort(entity.getPort().intValue());
        this.checkStrFieldLength(commonDbServerInfo);
        if (!this.checkCreator(userName, entity)) {
            throw new IllegalArgumentException(userName + " is not creator, has no right to update id=" + entity.getId() + ", please contact " + entity.getCreator());
        }
        CommonDbServerEntity record = new CommonDbServerEntity();
        BeanUtils.copyProperties((Object)commonDbServerInfo, (Object)record);
        record.setIsDeleted(null);
        record.setCreateTime(null);
        Date now = new Date();
        record.setModifier(userName);
        record.setModifyTime(now);
        int success = this.commonDbServerMapper.updateByPrimaryKeySelective(record);
        Preconditions.checkTrue((success == 1 ? 1 : 0) != 0, (String)("Database update id = " + entity.getId() + " failed "));
        LOGGER.info("user={} success update CommonDbServer id={}", (Object)userName, (Object)entity.getId());
        return CommonDBServerInfoBuilder.buildInfoFromEntity(this.commonDbServerMapper.selectByPrimaryKey(Integer.valueOf(commonDbServerInfo.getId())));
    }

    @Override
    public List<CommonDbServerInfo> getByUser(String user) throws Exception {
        List all = this.commonDbServerMapper.selectAll();
        List<String> groups = this.getUserGroups(user);
        ArrayList<CommonDbServerInfo> results = new ArrayList<CommonDbServerInfo>();
        Splitter commaSplitter = Splitter.on((char)',');
        for (CommonDbServerEntity entry : all) {
            List vGroup;
            List vPersion;
            if (entry.getCreator().equals(user)) {
                results.add(CommonDBServerInfoBuilder.buildInfoFromEntity(entry));
                continue;
            }
            List inChargeSplits = commaSplitter.splitToList((CharSequence)entry.getInCharges());
            if (!this.checkUserVisible(user, groups, inChargeSplits, vPersion = commaSplitter.splitToList((CharSequence)entry.getVisiblePerson()), vGroup = commaSplitter.splitToList((CharSequence)entry.getVisibleGroup()))) continue;
            results.add(CommonDBServerInfoBuilder.buildInfoFromEntity(entry));
        }
        return results;
    }

    private boolean checkUserVisible(String user, List<String> groups, List<String> inCharges, List<String> vPersion, List<String> vGroup) {
        for (String entry : inCharges) {
            if (!entry.equals(user)) continue;
            return true;
        }
        for (String persion : vPersion) {
            if (!persion.equals(user)) continue;
            return true;
        }
        for (String group : vGroup) {
            for (String g : groups) {
                if (!group.equals(g)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public CommonDbServerInfo addVisiblePerson(Integer id, String visiblePerson) {
        String username = LoginUserUtil.getLoginUserDetail().getUserName();
        LOGGER.info("user={}, add visible person, id={}, visible group={}", new Object[]{username, id, visiblePerson});
        CommonDbServerEntity entity = this.commonDbServerMapper.selectByPrimaryKey(id);
        Preconditions.checkNotNull((Object)entity, (String)("CommonDbServerEntity not found by id=" + id));
        Preconditions.checkTrue((entity.getIsDeleted() == 0 ? 1 : 0) != 0, (String)("CommonDbServerEntity has been deleted, id=" + id));
        if (!this.checkCreator(username, entity)) {
            throw new IllegalArgumentException(username + " is not creator, has no right to addVisiblePerson id=" + entity.getId() + ", please contact " + entity.getCreator());
        }
        Splitter commaSplitter = Splitter.on((char)',').omitEmptyStrings().trimResults();
        List adds = commaSplitter.splitToList((CharSequence)visiblePerson);
        List alreadyExists = commaSplitter.splitToList((CharSequence)entity.getVisiblePerson());
        HashSet all = new HashSet();
        all.addAll(alreadyExists);
        all.addAll(adds);
        Joiner joiner = Joiner.on((String)",").skipNulls();
        String result = joiner.join(all);
        entity.setVisiblePerson(result);
        if (CommonDBServerServiceImpl.checkStrLen(entity.getVisiblePerson(), 1024)) {
            throw new IllegalArgumentException("CommonFileServer visiblePerson = [" + entity.getVisiblePerson() + "] length is " + entity.getVisiblePerson().length() + " and too large, The maximum size for the field length is 1024.");
        }
        Date now = new Date();
        entity.setModifier(username);
        entity.setModifyTime(now);
        int success = this.commonDbServerMapper.updateByPrimaryKey(entity);
        Preconditions.checkTrue((success == 1 ? 1 : 0) != 0, (String)("DataBase update for id = " + entity.getId() + " failed "));
        LOGGER.info("user={} success addVisiblePerson for CommonDbServer id={}", (Object)username, (Object)entity.getId());
        return CommonDBServerInfoBuilder.buildInfoFromEntity(this.commonDbServerMapper.selectByPrimaryKey(id));
    }

    @Override
    public CommonDbServerInfo deleteVisiblePerson(Integer id, String visiblePerson) {
        String username = LoginUserUtil.getLoginUserDetail().getUserName();
        LOGGER.info("user={}, delete visible group, id={}, visible group={}", new Object[]{username, id, visiblePerson});
        CommonDbServerEntity entity = this.commonDbServerMapper.selectByPrimaryKey(id);
        Preconditions.checkNotNull((Object)entity, (String)("CommonDbServerEntity not found by id=" + id));
        Preconditions.checkTrue((entity.getIsDeleted() == 0 ? 1 : 0) != 0, (String)("CommonDbServerEntity has been deleted, id=" + id));
        if (!this.checkCreator(username, entity)) {
            throw new IllegalArgumentException(username + " is not creator, has no right to deleteVisiblePerson id=" + entity.getId() + ", please contact " + entity.getCreator());
        }
        Splitter commaSplitter = Splitter.on((char)',').omitEmptyStrings().trimResults();
        List removes = commaSplitter.splitToList((CharSequence)visiblePerson);
        List alreadyExists = commaSplitter.splitToList((CharSequence)entity.getVisiblePerson());
        HashSet all = new HashSet(alreadyExists);
        removes.forEach(all::remove);
        Joiner joiner = Joiner.on((String)",").skipNulls();
        String result = joiner.join(all);
        entity.setVisiblePerson(result);
        Date now = new Date();
        entity.setModifier(username);
        entity.setModifyTime(now);
        int success = this.commonDbServerMapper.updateByPrimaryKey(entity);
        Preconditions.checkTrue((success == 1 ? 1 : 0) != 0, (String)("DataBase update for id = " + entity.getId() + " failed "));
        LOGGER.info("user={} success deleteVisiblePerson for CommonDbServer id={}", (Object)username, (Object)entity.getId());
        return CommonDBServerInfoBuilder.buildInfoFromEntity(this.commonDbServerMapper.selectByPrimaryKey(id));
    }

    @Override
    public CommonDbServerInfo addVisibleGroup(Integer id, String visibleGroup) {
        String username = LoginUserUtil.getLoginUserDetail().getUserName();
        LOGGER.info("user={}, add visible group, id={}, visible group={}", new Object[]{username, id, visibleGroup});
        CommonDbServerEntity entity = this.commonDbServerMapper.selectByPrimaryKey(id);
        Preconditions.checkNotNull((Object)entity, (String)("CommonDbServerEntity not found by id=" + id));
        Preconditions.checkTrue((entity.getIsDeleted() == 0 ? 1 : 0) != 0, (String)("CommonDbServerEntity has been deleted, id=" + id));
        if (!this.checkCreator(username, entity)) {
            throw new IllegalArgumentException(username + " is not creator, has no right to addVisibleGroup id=" + entity.getId() + ", please contact " + entity.getCreator());
        }
        Splitter commaSplitter = Splitter.on((char)',').omitEmptyStrings().trimResults();
        List adds = commaSplitter.splitToList((CharSequence)visibleGroup);
        List alreadyExists = commaSplitter.splitToList((CharSequence)entity.getVisibleGroup());
        HashSet all = new HashSet();
        all.addAll(alreadyExists);
        all.addAll(adds);
        Joiner joiner = Joiner.on((String)",").skipNulls();
        String result = joiner.join(all);
        entity.setVisibleGroup(result);
        if (CommonDBServerServiceImpl.checkStrLen(entity.getVisibleGroup(), 1024)) {
            throw new IllegalArgumentException("CommonFileServer visibleGroup = [" + entity.getVisibleGroup() + "] length is " + entity.getVisibleGroup().length() + " and too large, The maximum size for the field length is 1024.");
        }
        Date now = new Date();
        entity.setModifier(username);
        entity.setModifyTime(now);
        int success = this.commonDbServerMapper.updateByPrimaryKey(entity);
        Preconditions.checkTrue((success == 1 ? 1 : 0) != 0, (String)("DataBase update for id = " + entity.getId() + " failed "));
        LOGGER.info("user={} success addVisibleGroup for CommonDbServer id={}", (Object)username, (Object)entity.getId());
        return CommonDBServerInfoBuilder.buildInfoFromEntity(this.commonDbServerMapper.selectByPrimaryKey(id));
    }

    @Override
    public CommonDbServerInfo deleteVisibleGroup(Integer id, String visibleGroup) {
        String username = LoginUserUtil.getLoginUserDetail().getUserName();
        LOGGER.info("user={}, delete visible group, id={}, visible group={}", new Object[]{username, id, visibleGroup});
        CommonDbServerEntity entity = this.commonDbServerMapper.selectByPrimaryKey(id);
        Preconditions.checkNotNull((Object)entity, (String)("CommonDbServerEntity not found by id=" + id));
        Preconditions.checkTrue((entity.getIsDeleted() == 0 ? 1 : 0) != 0, (String)("CommonDbServerEntity has been deleted, id=" + id));
        if (!this.checkCreator(username, entity)) {
            throw new IllegalArgumentException(username + " is not creator, has no right to deleteVisibleGroup id=" + entity.getId() + ", please contact " + entity.getCreator());
        }
        Splitter commaSplitter = Splitter.on((char)',').omitEmptyStrings().trimResults();
        List removes = commaSplitter.splitToList((CharSequence)visibleGroup);
        List alreadyExists = commaSplitter.splitToList((CharSequence)entity.getVisibleGroup());
        HashSet all = new HashSet(alreadyExists);
        removes.forEach(all::remove);
        Joiner joiner = Joiner.on((String)",").skipNulls();
        String result = joiner.join(all);
        entity.setVisibleGroup(result);
        Date now = new Date();
        entity.setModifier(username);
        entity.setModifyTime(now);
        int success = this.commonDbServerMapper.updateByPrimaryKey(entity);
        Preconditions.checkTrue((success == 1 ? 1 : 0) != 0, (String)("DataBase update for id = " + entity.getId() + " failed "));
        LOGGER.info("user={} success deleteVisibleGroup for CommonDbServer id={}", (Object)username, (Object)entity.getId());
        return CommonDBServerInfoBuilder.buildInfoFromEntity(this.commonDbServerMapper.selectByPrimaryKey(id));
    }

    @Override
    public PageInfo<CommonDbServerListVo> listByCondition(CommonDbServerPageRequest request) throws Exception {
        String username = LoginUserUtil.getLoginUserDetail().getUserName();
        LOGGER.debug("{} begin to list CommonDbServer info by {}", (Object)username, (Object)request);
        request.setCurrentUser(username);
        List<String> groups = this.getUserGroups(username);
        request.setUserGroups(groups);
        PageHelper.startPage((int)request.getPageNum(), (int)request.getPageSize());
        Page entityPage = (Page)this.commonDbServerMapper.selectByCondition(request);
        List dbServerList = CommonBeanUtils.copyListProperties((List)entityPage, CommonDbServerListVo::new);
        PageInfo page = new PageInfo(dbServerList);
        page.setTotal(entityPage.getTotal());
        LOGGER.info("success to list CommonFileServer info");
        return page;
    }

    private List<String> getUserGroups(String userName) {
        return new ArrayList<String>();
    }

    private boolean checkVisible(String userName, CommonDbServerEntity entity) {
        boolean passed = false;
        boolean bl = passed = passed || this.checkCreator(userName, entity);
        if (!passed) {
            boolean bl2 = passed = passed || this.checkVisiblePerson(userName, entity);
            if (!passed) {
                passed = passed || this.checkVisibleGroup(userName, entity);
            }
        }
        return passed;
    }

    private boolean checkCreator(String username, CommonDbServerEntity entity) {
        return entity.getCreator().equals(username);
    }

    private boolean checkVisiblePerson(String username, CommonDbServerEntity entity) {
        return this.contains(username, entity.getVisiblePerson());
    }

    private boolean contains(String name, String visibles) {
        if (visibles == null || visibles.isEmpty()) {
            return false;
        }
        Splitter commaSplitter = Splitter.on((char)',').omitEmptyStrings().trimResults();
        for (String entry : commaSplitter.split((CharSequence)visibles)) {
            if (!entry.equals(name)) continue;
            return true;
        }
        return false;
    }

    private boolean checkVisibleGroup(String username, CommonDbServerEntity entity) {
        String visibleGroup = entity.getVisibleGroup();
        if (visibleGroup == null || visibleGroup.isEmpty()) {
            return false;
        }
        List<String> groups = this.getUserGroups(username);
        for (String group : groups) {
            if (!this.contains(group, visibleGroup)) continue;
            return true;
        }
        return false;
    }
}

