/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.core.impl;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.BizErrorCodeEnum;
import org.apache.inlong.manager.common.enums.EntityStatus;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.pojo.cluster.DataProxyClusterInfo;
import org.apache.inlong.manager.common.pojo.cluster.DataProxyClusterPageRequest;
import org.apache.inlong.manager.common.pojo.dataproxy.DataProxyConfig;
import org.apache.inlong.manager.common.pojo.dataproxy.DataProxyIpRequest;
import org.apache.inlong.manager.common.pojo.dataproxy.DataProxyIpResponse;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.DataProxyClusterEntity;
import org.apache.inlong.manager.dao.entity.SourceFileDetailEntity;
import org.apache.inlong.manager.dao.mapper.BusinessEntityMapper;
import org.apache.inlong.manager.dao.mapper.DataProxyClusterEntityMapper;
import org.apache.inlong.manager.dao.mapper.SourceFileDetailEntityMapper;
import org.apache.inlong.manager.service.core.DataProxyClusterService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DataProxyClusterServiceImpl
implements DataProxyClusterService {
    private static final Logger log = LoggerFactory.getLogger(DataProxyClusterServiceImpl.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(DataProxyClusterServiceImpl.class);
    @Autowired
    private DataProxyClusterEntityMapper dataProxyClusterMapper;
    @Autowired
    private SourceFileDetailEntityMapper sourceFileDetailMapper;
    @Autowired
    private BusinessEntityMapper businessEntityMapper;

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public Integer save(DataProxyClusterInfo clusterInfo, String operator) {
        LOGGER.info("begin to save data proxy cluster={}", (Object)clusterInfo);
        Preconditions.checkNotNull((Object)clusterInfo, (String)"data proxy cluster is empty");
        DataProxyClusterEntity entity = (DataProxyClusterEntity)CommonBeanUtils.copyProperties((Object)clusterInfo, DataProxyClusterEntity::new);
        entity.setCreator(operator);
        entity.setModifier(operator);
        entity.setCreateTime(new Date());
        this.dataProxyClusterMapper.insertSelective(entity);
        LOGGER.info("success to save data proxy cluster");
        return entity.getId();
    }

    @Override
    public DataProxyClusterInfo get(Integer id) {
        LOGGER.info("begin to get data proxy cluster by id={}", (Object)id);
        Preconditions.checkNotNull((Object)id, (String)"data proxy cluster id is empty");
        DataProxyClusterEntity entity = this.dataProxyClusterMapper.selectByPrimaryKey(id);
        if (entity == null) {
            LOGGER.error("data proxy cluster not found by id={}", (Object)id);
            throw new BusinessException(BizErrorCodeEnum.CLUSTER_NOT_FOUND);
        }
        DataProxyClusterInfo clusterInfo = (DataProxyClusterInfo)CommonBeanUtils.copyProperties((Object)entity, DataProxyClusterInfo::new);
        LOGGER.info("success to get data proxy cluster info");
        return clusterInfo;
    }

    @Override
    public PageInfo<DataProxyClusterInfo> listByCondition(DataProxyClusterPageRequest request) {
        LOGGER.info("begin to list data proxy cluster by {}", (Object)request);
        PageHelper.startPage((int)request.getPageNum(), (int)request.getPageSize());
        Page entityPage = (Page)this.dataProxyClusterMapper.selectByCondition(request);
        List clusterList = CommonBeanUtils.copyListProperties((List)entityPage, DataProxyClusterInfo::new);
        PageInfo page = new PageInfo(clusterList);
        page.setTotal(entityPage.getTotal());
        LOGGER.info("success to list data proxy cluster");
        return page;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public Boolean update(DataProxyClusterInfo clusterInfo, String operator) {
        LOGGER.info("begin to update data proxy cluster={}", (Object)clusterInfo);
        Preconditions.checkNotNull((Object)clusterInfo, (String)"data proxy cluster is empty");
        Integer id = clusterInfo.getId();
        Preconditions.checkNotNull((Object)id, (String)"data proxy cluster id is empty");
        DataProxyClusterEntity entity = this.dataProxyClusterMapper.selectByPrimaryKey(id);
        if (entity == null) {
            LOGGER.error("data proxy cluster not found by id={}", (Object)id);
            throw new BusinessException(BizErrorCodeEnum.CLUSTER_NOT_FOUND);
        }
        CommonBeanUtils.copyProperties((Object)clusterInfo, (Object)entity, (boolean)true);
        entity.setModifier(operator);
        this.dataProxyClusterMapper.updateByPrimaryKeySelective(entity);
        LOGGER.info("success to update data proxy cluster");
        return true;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public Boolean delete(Integer id, String operator) {
        LOGGER.info("begin to delete data proxy cluster by id={}", (Object)id);
        Preconditions.checkNotNull((Object)id, (String)"data proxy cluster id is empty");
        DataProxyClusterEntity entity = this.dataProxyClusterMapper.selectByPrimaryKey(id);
        if (entity == null) {
            LOGGER.error("data proxy cluster not found by id={}", (Object)id);
            throw new BusinessException(BizErrorCodeEnum.CLUSTER_NOT_FOUND);
        }
        entity.setIsDeleted(EntityStatus.IS_DELETED.getCode());
        entity.setStatus(EntityStatus.DELETED.getCode());
        entity.setModifier(operator);
        this.dataProxyClusterMapper.updateByPrimaryKey(entity);
        LOGGER.info("success to delete data proxy cluster");
        return true;
    }

    @Override
    public DataProxyIpResponse getIpList(DataProxyIpRequest request, HttpServletRequest httpServletRequest) {
        String netTag = request.getNetTag();
        if (StringUtils.isEmpty((CharSequence)netTag)) {
            List fileEntityList = this.sourceFileDetailMapper.selectByIp(request.getIp());
            for (SourceFileDetailEntity fileConfig : fileEntityList) {
                int innerIp = fileConfig.getIsInnerIp();
                if (innerIp == 1) {
                    netTag = "auto";
                    break;
                }
                if (0 != innerIp) continue;
                netTag = fileConfig.getNetTag();
                break;
            }
            if (StringUtils.isEmpty((CharSequence)netTag)) {
                netTag = "all";
            }
        }
        String filterNetTag = netTag;
        if (!netTag.equals("all")) {
            DataProxyIpResponse response = new DataProxyIpResponse();
            List address = response.getAddress().stream().filter(a -> a.getNetTag().equals(filterNetTag)).collect(Collectors.toList());
            response.setAddress(address);
            return response;
        }
        return null;
    }

    @Override
    public List<DataProxyConfig> getConfig() {
        return this.businessEntityMapper.queryDataProxyConfig();
    }
}

