/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.core.impl;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.BizErrorCodeEnum;
import org.apache.inlong.manager.common.enums.EntityStatus;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.pojo.datasource.SourceDbBasicInfo;
import org.apache.inlong.manager.common.pojo.datasource.SourceDbDetailInfo;
import org.apache.inlong.manager.common.pojo.datasource.SourceFileBasicInfo;
import org.apache.inlong.manager.common.pojo.datasource.SourceFileDetailInfo;
import org.apache.inlong.manager.common.pojo.datastorage.BaseStorageInfo;
import org.apache.inlong.manager.common.pojo.datastorage.StorageSummaryInfo;
import org.apache.inlong.manager.common.pojo.datastream.DataStreamApproveInfo;
import org.apache.inlong.manager.common.pojo.datastream.DataStreamExtInfo;
import org.apache.inlong.manager.common.pojo.datastream.DataStreamFieldInfo;
import org.apache.inlong.manager.common.pojo.datastream.DataStreamInfo;
import org.apache.inlong.manager.common.pojo.datastream.DataStreamInfoToHiveConfig;
import org.apache.inlong.manager.common.pojo.datastream.DataStreamListVO;
import org.apache.inlong.manager.common.pojo.datastream.DataStreamPageRequest;
import org.apache.inlong.manager.common.pojo.datastream.DataStreamSummaryInfo;
import org.apache.inlong.manager.common.pojo.datastream.FullDataStreamPageRequest;
import org.apache.inlong.manager.common.pojo.datastream.FullPageInfo;
import org.apache.inlong.manager.common.pojo.datastream.FullPageUpdateInfo;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.BusinessEntity;
import org.apache.inlong.manager.dao.entity.DataStreamEntity;
import org.apache.inlong.manager.dao.entity.DataStreamExtEntity;
import org.apache.inlong.manager.dao.entity.DataStreamFieldEntity;
import org.apache.inlong.manager.dao.mapper.BusinessEntityMapper;
import org.apache.inlong.manager.dao.mapper.DataStreamEntityMapper;
import org.apache.inlong.manager.dao.mapper.DataStreamExtEntityMapper;
import org.apache.inlong.manager.dao.mapper.DataStreamFieldEntityMapper;
import org.apache.inlong.manager.service.core.DataStreamService;
import org.apache.inlong.manager.service.core.SourceDbService;
import org.apache.inlong.manager.service.core.SourceFileService;
import org.apache.inlong.manager.service.core.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DataStreamServiceImpl
implements DataStreamService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataStreamServiceImpl.class);
    @Autowired
    private DataStreamEntityMapper streamMapper;
    @Autowired
    private DataStreamExtEntityMapper streamExtMapper;
    @Autowired
    private DataStreamFieldEntityMapper streamFieldMapper;
    @Autowired
    private BusinessEntityMapper businessMapper;
    @Autowired
    private SourceFileService sourceFileService;
    @Autowired
    private SourceDbService sourceDbService;
    @Autowired
    private StorageService storageService;

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public Integer save(DataStreamInfo dataStreamInfo, String operator) {
        LOGGER.debug("begin to save data stream info={}", (Object)dataStreamInfo);
        Preconditions.checkNotNull((Object)dataStreamInfo, (String)"data stream info is empty");
        String bid = dataStreamInfo.getBusinessIdentifier();
        String dsid = dataStreamInfo.getDataStreamIdentifier();
        Preconditions.checkNotNull((Object)bid, (String)"businessIdentifier is empty");
        Preconditions.checkNotNull((Object)dsid, (String)"dataStreamIdentifier is empty");
        BusinessEntity businessEntity = this.checkBizIsTempStatus(bid);
        Integer count = this.streamMapper.selectExistByIdentifier(bid, dsid);
        if (count >= 1) {
            LOGGER.error("data stream id [{}] has already exists", (Object)dsid);
            throw new BusinessException(BizErrorCodeEnum.DATA_STREAM_ID_DUPLICATE);
        }
        DataStreamEntity streamEntity = (DataStreamEntity)CommonBeanUtils.copyProperties((Object)dataStreamInfo, DataStreamEntity::new);
        Date date = new Date();
        streamEntity.setStatus(EntityStatus.DATA_STREAM_NEW.getCode());
        streamEntity.setModifier(operator);
        streamEntity.setCreateTime(date);
        this.streamMapper.insertSelective(streamEntity);
        this.saveExt(bid, dsid, dataStreamInfo.getExtList(), date);
        this.saveField(bid, dsid, dataStreamInfo.getFieldList());
        LOGGER.info("success to save data stream info");
        return streamEntity.getId();
    }

    @Override
    public DataStreamInfo get(String bid, String dsid) {
        LOGGER.debug("begin to get data stream by bid={}, dsid={}", (Object)bid, (Object)dsid);
        Preconditions.checkNotNull((Object)bid, (String)"businessIdentifier is empty");
        Preconditions.checkNotNull((Object)dsid, (String)"dataStreamIdentifier is empty");
        DataStreamEntity streamEntity = this.streamMapper.selectByIdentifier(bid, dsid);
        if (streamEntity == null) {
            LOGGER.error("data stream not found by bid={}, dsid={}", (Object)bid, (Object)dsid);
            throw new BusinessException(BizErrorCodeEnum.DATA_STREAM_NOT_FOUND);
        }
        DataStreamInfo streamInfo = (DataStreamInfo)CommonBeanUtils.copyProperties((Object)streamEntity, DataStreamInfo::new);
        this.setStreamExtAndField(bid, dsid, streamInfo);
        LOGGER.info("success to get data stream");
        return streamInfo;
    }

    private void setStreamExtAndField(String bid, String dsid, DataStreamInfo streamInfo) {
        List fieldEntityList;
        List extEntityList = this.streamExtMapper.selectByIdentifier(bid, dsid);
        if (CollectionUtils.isNotEmpty((Collection)extEntityList)) {
            streamInfo.setExtList(CommonBeanUtils.copyListProperties((List)extEntityList, DataStreamExtInfo::new));
        }
        if (CollectionUtils.isNotEmpty((Collection)(fieldEntityList = this.streamFieldMapper.selectByIdentifier(bid, dsid)))) {
            streamInfo.setFieldList(CommonBeanUtils.copyListProperties((List)fieldEntityList, DataStreamFieldInfo::new));
        }
    }

    @Override
    public List<DataStreamInfoToHiveConfig> queryHiveConfigForAllDataStream(String businessId) {
        return this.streamMapper.queryStreamToHiveBaseInfoByBid(businessId);
    }

    @Override
    public DataStreamInfoToHiveConfig queryHiveConfigForOneDataStream(String bid, String dsid) {
        return this.streamMapper.queryStreamToHiveBaseInfoByIdentifier(bid, dsid);
    }

    @Override
    public PageInfo<DataStreamListVO> listByCondition(DataStreamPageRequest request) {
        LOGGER.debug("begin to list data stream page by {}", (Object)request);
        PageHelper.startPage((int)request.getPageNum(), (int)request.getPageSize());
        Page entityPage = (Page)this.streamMapper.selectByCondition(request);
        List dataStreamList = CommonBeanUtils.copyListProperties((List)entityPage, DataStreamListVO::new);
        String bid = request.getBid();
        String storageType = request.getStorageType();
        if (StringUtils.isNotEmpty((CharSequence)storageType)) {
            List<String> dsidList = dataStreamList.stream().map(DataStreamListVO::getDataStreamIdentifier).distinct().collect(Collectors.toList());
            List<String> resultList = this.storageService.filterStreamIdByStorageType(bid, storageType, dsidList);
            dataStreamList.removeIf(entity -> resultList.contains(entity.getDataStreamIdentifier()));
        }
        if (request.getNeedStorageList() == 1) {
            dataStreamList.forEach(stream -> {
                String dsid = stream.getDataStreamIdentifier();
                List<String> storageTypeList = this.storageService.getStorageTypeList(bid, dsid);
                stream.setStorageTypeList(storageTypeList);
            });
        }
        PageInfo page = new PageInfo(dataStreamList);
        page.setTotal((long)dataStreamList.size());
        LOGGER.debug("success to list data stream info");
        return page;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public boolean update(DataStreamInfo streamInfo, String operator) {
        LOGGER.debug("begin to update data stream info={}", (Object)streamInfo);
        Preconditions.checkNotNull((Object)streamInfo, (String)"data stream info is empty");
        String bid = streamInfo.getBusinessIdentifier();
        Preconditions.checkNotNull((Object)bid, (String)"businessIdentifier is empty");
        String dsid = streamInfo.getDataStreamIdentifier();
        Preconditions.checkNotNull((Object)dsid, (String)"dataStreamIdentifier is empty");
        BusinessEntity businessEntity = this.checkBizIsTempStatus(bid);
        DataStreamEntity streamEntity = this.streamMapper.selectByIdentifier(bid, dsid);
        if (streamEntity == null) {
            this.save(streamInfo, operator);
        } else {
            this.checkCanUpdate(businessEntity.getStatus(), streamEntity, streamInfo);
            CommonBeanUtils.copyProperties((Object)streamInfo, (Object)streamEntity, (boolean)true);
            streamEntity.setModifier(operator);
            streamEntity.setStatus(EntityStatus.BIZ_CONFIG_ING.getCode());
            this.streamMapper.updateByIdentifierSelective(streamEntity);
            this.updateExt(bid, dsid, streamInfo.getExtList());
            this.updateField(bid, dsid, streamInfo.getFieldList());
        }
        LOGGER.info("success to update business info");
        return true;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public boolean delete(String bid, String dsid, String operator) {
        LOGGER.debug("begin to delete data stream, bid={}, dsid={}", (Object)bid, (Object)dsid);
        Preconditions.checkNotNull((Object)bid, (String)"businessIdentifier is empty");
        Preconditions.checkNotNull((Object)dsid, (String)"dataStreamIdentifier is empty");
        BusinessEntity businessEntity = this.checkBizIsTempStatus(bid);
        DataStreamEntity entity = this.streamMapper.selectByIdentifier(bid, dsid);
        if (entity == null) {
            LOGGER.error("data stream not found by bid={}, dsid={}", (Object)bid, (Object)dsid);
            throw new BusinessException(BizErrorCodeEnum.DATA_STREAM_NOT_FOUND);
        }
        boolean dataSourceExist = this.hasDataSource(bid, dsid, entity.getDataSourceType());
        if (dataSourceExist) {
            LOGGER.error("data stream has undeleted data sources, delete failed");
            throw new BusinessException(BizErrorCodeEnum.DATA_STREAM_DELETE_HAS_SOURCE);
        }
        boolean dataStorageExist = this.hasDataStorage(bid, dsid);
        if (dataStorageExist) {
            LOGGER.error("data stream has undeleted data storages, delete failed");
            throw new BusinessException(BizErrorCodeEnum.DATA_STREAM_DELETE_HAS_STORAGE);
        }
        entity.setIsDeleted(Integer.valueOf(1));
        entity.setModifier(operator);
        this.streamMapper.updateByPrimaryKey(entity);
        LOGGER.debug("begin to delete data stream ext property, bid={}, dsid={}", (Object)bid, (Object)dsid);
        this.streamExtMapper.logicDeleteAllByIdentifier(bid, dsid);
        LOGGER.debug("begin to delete data stream field, dsid={}", (Object)dsid);
        this.streamFieldMapper.logicDeleteAllByIdentifier(bid, dsid);
        LOGGER.info("success to delete data stream, ext property and fields");
        return true;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public boolean logicDeleteAllByBid(String bid, String operator) {
        LOGGER.debug("begin to delete all data stream by bid={}", (Object)bid);
        Preconditions.checkNotNull((Object)bid, (String)"businessIdentifier is empty");
        this.checkBizIsTempStatus(bid);
        List entityList = this.streamMapper.selectByBid(bid);
        if (CollectionUtils.isEmpty((Collection)entityList)) {
            LOGGER.info("data stream not found by bid={}", (Object)bid);
            return true;
        }
        for (DataStreamEntity entity : entityList) {
            entity.setIsDeleted(Integer.valueOf(1));
            entity.setModifier(operator);
            this.streamMapper.updateByIdentifierSelective(entity);
            String dsid = entity.getDataStreamIdentifier();
            this.streamExtMapper.logicDeleteAllByIdentifier(bid, dsid);
            this.streamFieldMapper.logicDeleteAllByIdentifier(bid, dsid);
            this.sourceFileService.logicDeleteAllByIdentifier(bid, dsid, operator);
            this.sourceDbService.logicDeleteAllByIdentifier(bid, dsid, operator);
            this.storageService.logicDeleteAllByIdentifier(bid, dsid, operator);
        }
        LOGGER.info("success to delete all data stream, ext property and fields by bid={}", (Object)bid);
        return true;
    }

    private boolean hasDataStorage(String bid, String dsid) {
        int count = this.storageService.getCountByIdentifier(bid, dsid);
        return count > 0;
    }

    private boolean hasDataSource(String bid, String dsid, String dataSourceType) {
        boolean exist;
        if ("FILE".equalsIgnoreCase(dataSourceType)) {
            List<SourceFileDetailInfo> fileDetailList = this.sourceFileService.listDetailByIdentifier(bid, dsid);
            exist = CollectionUtils.isNotEmpty(fileDetailList);
        } else if ("DB".equalsIgnoreCase(dataSourceType)) {
            List<SourceDbDetailInfo> dbDetailList = this.sourceDbService.listDetailByIdentifier(bid, dsid);
            exist = CollectionUtils.isNotEmpty(dbDetailList);
        } else {
            exist = false;
        }
        return exist;
    }

    @Override
    public List<DataStreamSummaryInfo> getSummaryList(String bid) {
        LOGGER.debug("begin to get data stream summary list by bid={}", (Object)bid);
        Preconditions.checkNotNull((Object)bid, (String)"businessIdentifier is empty");
        List entityList = this.streamMapper.selectByBid(bid);
        List summaryInfoList = CommonBeanUtils.copyListProperties((List)entityList, DataStreamSummaryInfo::new);
        for (DataStreamSummaryInfo summaryInfo : summaryInfoList) {
            String dsid = summaryInfo.getDataStreamIdentifier();
            List<StorageSummaryInfo> storageList = this.storageService.listSummaryByIdentifier(bid, dsid);
            summaryInfo.setStorageList(storageList);
        }
        LOGGER.info("success to get data stream summary list");
        return summaryInfoList;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public boolean saveAll(FullPageInfo fullPageInfo, String operator) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("begin to save all stream page info: {}", (Object)fullPageInfo);
        }
        Preconditions.checkNotNull((Object)fullPageInfo, (String)"fullPageInfo is empty");
        DataStreamInfo streamInfo = fullPageInfo.getStreamInfo();
        Preconditions.checkNotNull((Object)streamInfo, (String)"data stream info is empty");
        this.save(streamInfo, operator);
        if (fullPageInfo.getFileBasicInfo() != null) {
            this.sourceFileService.saveBasic(fullPageInfo.getFileBasicInfo(), operator);
        }
        if (CollectionUtils.isNotEmpty((Collection)fullPageInfo.getFileDetailInfoList())) {
            for (SourceFileDetailInfo detailInfo : fullPageInfo.getFileDetailInfoList()) {
                this.sourceFileService.saveDetail(detailInfo, operator);
            }
        }
        if (fullPageInfo.getDbBasicInfo() != null) {
            this.sourceDbService.saveBasic(fullPageInfo.getDbBasicInfo(), operator);
        }
        if (CollectionUtils.isNotEmpty((Collection)fullPageInfo.getDbDetailInfoList())) {
            for (SourceFileDetailInfo detailInfo : fullPageInfo.getDbDetailInfoList()) {
                this.sourceDbService.saveDetail((SourceDbDetailInfo)detailInfo, operator);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)fullPageInfo.getStorageInfo())) {
            for (BaseStorageInfo storageInfo : fullPageInfo.getStorageInfo()) {
                this.storageService.save(storageInfo, operator);
            }
        }
        LOGGER.info("success to save all stream page info");
        return true;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public boolean batchSaveAll(List<FullPageInfo> fullPageInfoList, String operator) {
        if (CollectionUtils.isEmpty(fullPageInfoList)) {
            return true;
        }
        LOGGER.info("begin to batch save all stream page info, batch size={}", (Object)fullPageInfoList.size());
        DataStreamInfo firstStream = fullPageInfoList.get(0).getStreamInfo();
        Preconditions.checkNotNull((Object)firstStream, (String)"data stream info is empty");
        String bid = firstStream.getBusinessIdentifier();
        this.checkBizIsTempStatus(bid);
        this.streamMapper.deleteAllByBid(bid);
        for (FullPageInfo pageInfo : fullPageInfoList) {
            DataStreamInfo streamInfo = pageInfo.getStreamInfo();
            String dsid = streamInfo.getDataStreamIdentifier();
            this.streamExtMapper.deleteAllByIdentifier(bid, dsid);
            this.streamFieldMapper.deleteAllByIdentifier(bid, dsid);
            this.sourceFileService.deleteAllByIdentifier(bid, dsid);
            this.sourceDbService.deleteAllByIdentifier(bid, dsid);
            this.storageService.deleteAllByIdentifier(bid, dsid);
            this.saveAll(pageInfo, operator);
        }
        LOGGER.info("success to batch save all stream page info");
        return true;
    }

    @Override
    public PageInfo<FullPageInfo> listAllWithBid(FullDataStreamPageRequest request) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("begin to list full data stream page by {}", (Object)request);
        }
        LOGGER.debug("begin to list full data stream page by {}", (Object)request);
        Preconditions.checkNotNull((Object)request, (String)"request is empty");
        Preconditions.checkNotNull((Object)request.getBid(), (String)"businessIdentifier is empty");
        String bid = request.getBid();
        BusinessEntity businessEntity = this.businessMapper.selectByIdentifier(bid);
        Preconditions.checkNotNull((Object)businessEntity, (String)("business not found by bid=" + bid));
        String inCharges = businessEntity.getInCharges();
        PageHelper.startPage((int)request.getPageNum(), (int)request.getPageSize());
        Page entityPage = (Page)this.streamMapper.selectByBidAndCondition(request, inCharges);
        List streamInfoList = CommonBeanUtils.copyListProperties((List)entityPage, DataStreamInfo::new);
        ArrayList<FullPageInfo> fullPageInfoList = new ArrayList<FullPageInfo>(streamInfoList.size());
        for (DataStreamInfo streamInfo : streamInfoList) {
            String dsid = streamInfo.getDataStreamIdentifier();
            this.setStreamExtAndField(bid, dsid, streamInfo);
            FullPageInfo pageInfo = new FullPageInfo();
            pageInfo.setStreamInfo(streamInfo);
            String dataSourceType = streamInfo.getDataSourceType();
            if (StringUtils.isEmpty((CharSequence)dataSourceType)) continue;
            switch (dataSourceType.toUpperCase(Locale.ROOT)) {
                case "FILE": {
                    SourceFileBasicInfo fileBasicInfo = this.sourceFileService.getBasicByIdentifier(bid, dsid);
                    pageInfo.setFileBasicInfo(fileBasicInfo);
                    List<SourceFileDetailInfo> fileDetailInfoList = this.sourceFileService.listDetailByIdentifier(bid, dsid);
                    pageInfo.setFileDetailInfoList(fileDetailInfoList);
                    break;
                }
                case "DB": {
                    SourceDbBasicInfo dbBasicInfo = this.sourceDbService.getBasicByIdentifier(bid, dsid);
                    pageInfo.setDbBasicInfo(dbBasicInfo);
                    List<SourceDbDetailInfo> dbDetailInfoList = this.sourceDbService.listDetailByIdentifier(bid, dsid);
                    pageInfo.setDbDetailInfoList(dbDetailInfoList);
                    break;
                }
                case "AUTO_PUSH": {
                    break;
                }
                default: {
                    throw new BusinessException(BizErrorCodeEnum.DATA_SOURCE_TYPE_NOT_SUPPORTED);
                }
            }
            List<BaseStorageInfo> storageInfoList = this.storageService.listByIdentifier(bid, dsid);
            pageInfo.setStorageInfo(storageInfoList);
            fullPageInfoList.add(pageInfo);
        }
        PageInfo page = new PageInfo(fullPageInfoList);
        page.setTotal(entityPage.getTotal());
        LOGGER.info("success to list full data stream info");
        return page;
    }

    @Override
    public List<DataStreamInfo> listAllByBid(String bid) {
        LOGGER.debug("begin to list all data stream page by bid={}", (Object)bid);
        Preconditions.checkNotNull((Object)bid, (String)"businessIdentifier is empty");
        List entityList = this.streamMapper.selectByBid(bid);
        List streamInfoList = CommonBeanUtils.copyListProperties((List)entityList, DataStreamInfo::new);
        for (DataStreamInfo streamInfo : streamInfoList) {
            String dsid = streamInfo.getDataStreamIdentifier();
            this.setStreamExtAndField(bid, dsid, streamInfo);
        }
        LOGGER.info("success to list all data stream page by bid={}", (Object)bid);
        return streamInfoList;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public boolean updateAll(FullPageUpdateInfo updateInfo, String operator) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("begin to update all stream page info: {}", (Object)updateInfo);
        }
        Preconditions.checkNotNull((Object)updateInfo, (String)"updateInfo is empty");
        Preconditions.checkNotNull((Object)updateInfo.getStreamInfo(), (String)"data stream info is empty");
        this.update(updateInfo.getStreamInfo(), operator);
        if (updateInfo.getFileBasicInfo() != null) {
            this.sourceFileService.updateBasic(updateInfo.getFileBasicInfo(), operator);
        }
        if (updateInfo.getDbBasicInfo() != null) {
            this.sourceDbService.updateBasic(updateInfo.getDbBasicInfo(), operator);
        }
        LOGGER.info("success to update all stream page info");
        return true;
    }

    @Override
    public int selectCountByBid(String bid) {
        LOGGER.debug("begin bo get count by bid={}", (Object)bid);
        if (StringUtils.isEmpty((CharSequence)bid)) {
            return 0;
        }
        int count = this.streamMapper.selectCountByBid(bid);
        LOGGER.info("success to get count");
        return count;
    }

    @Override
    public boolean updateAfterApprove(List<DataStreamApproveInfo> streamApproveList, String operator) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("begin to update stream after approve={}", streamApproveList);
        }
        if (CollectionUtils.isEmpty(streamApproveList)) {
            return true;
        }
        for (DataStreamApproveInfo info : streamApproveList) {
            DataStreamEntity streamEntity = new DataStreamEntity();
            streamEntity.setBusinessIdentifier(info.getBusinessIdentifier());
            streamEntity.setDataStreamIdentifier(info.getDataStreamIdentifier());
            streamEntity.setStatus(EntityStatus.DATA_STREAM_CONFIG_ING.getCode());
            this.streamMapper.updateByIdentifierSelective(streamEntity);
            this.storageService.updateAfterApprove(info.getStorageList(), operator);
        }
        LOGGER.info("success to update stream after approve");
        return true;
    }

    @Override
    public boolean updateStatus(String bid, String dsid, Integer status, String operator) {
        LOGGER.debug("begin to update status by bid={}, dsid={}", (Object)bid, (Object)dsid);
        this.streamMapper.updateStatusByIdentifier(bid, dsid, status, operator);
        LOGGER.info("success to update stream after approve");
        return true;
    }

    @Transactional(rollbackFor={Throwable.class})
    void updateExt(String bid, String dsid, List<DataStreamExtInfo> extInfoList) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("begin to update data stream ext, bid={}, dsid={}, ext={}", new Object[]{bid, dsid, extInfoList});
        }
        try {
            this.streamExtMapper.deleteAllByIdentifier(bid, dsid);
            this.saveExt(bid, dsid, extInfoList, new Date());
            LOGGER.info("success to update data stream ext");
        }
        catch (Exception e) {
            LOGGER.error("failed to update data stream ext: ", (Throwable)e);
            throw new BusinessException(BizErrorCodeEnum.DATA_STREAM_EXT_SAVE_FAILED);
        }
    }

    @Transactional(rollbackFor={Throwable.class})
    void saveExt(String bid, String dsid, List<DataStreamExtInfo> infoList, Date date) {
        if (CollectionUtils.isEmpty(infoList)) {
            return;
        }
        List entityList = CommonBeanUtils.copyListProperties(infoList, DataStreamExtEntity::new);
        for (DataStreamExtEntity entity : entityList) {
            entity.setBusinessIdentifier(bid);
            entity.setDataStreamIdentifier(dsid);
            entity.setModifyTime(date);
        }
        this.streamExtMapper.insertAll(entityList);
    }

    @Transactional(rollbackFor={Throwable.class})
    void updateField(String bid, String dsid, List<DataStreamFieldInfo> fieldInfoList) {
        LOGGER.debug("begin to update data stream field, bid={}, dsid={}, field={}", new Object[]{bid, dsid, fieldInfoList});
        try {
            this.streamFieldMapper.deleteAllByIdentifier(bid, dsid);
            this.saveField(bid, dsid, fieldInfoList);
            LOGGER.info("success to update data stream field");
        }
        catch (Exception e) {
            LOGGER.error("failed to update data stream field: ", (Throwable)e);
            throw new BusinessException(BizErrorCodeEnum.DATA_STREAM_FIELD_SAVE_FAILED);
        }
    }

    @Transactional(rollbackFor={Throwable.class})
    void saveField(String bid, String dsid, List<DataStreamFieldInfo> infoList) {
        if (CollectionUtils.isEmpty(infoList)) {
            return;
        }
        List entities = CommonBeanUtils.copyListProperties(infoList, DataStreamFieldEntity::new);
        for (DataStreamFieldEntity entity : entities) {
            entity.setBusinessIdentifier(bid);
            entity.setDataStreamIdentifier(dsid);
        }
        this.streamFieldMapper.insertAll(entities);
    }

    private BusinessEntity checkBizIsTempStatus(String bid) {
        BusinessEntity businessEntity = this.businessMapper.selectByIdentifier(bid);
        Preconditions.checkNotNull((Object)businessEntity, (String)"businessIdentifier is invalid");
        if (EntityStatus.BIZ_TEMP_STATUS.contains(businessEntity.getStatus())) {
            LOGGER.error("business status was not allowed to add/update/delete data stream");
            throw new BusinessException(BizErrorCodeEnum.DATA_STREAM_OPT_NOT_ALLOWED);
        }
        return businessEntity;
    }

    private void checkCanUpdate(Integer bizStatus, DataStreamEntity streamEntity, DataStreamInfo streamInfo) {
        List<Integer> statusList;
        if (streamEntity == null || streamInfo == null) {
            return;
        }
        if (EntityStatus.BIZ_CONFIG_SUCCESSFUL.getCode().equals(bizStatus)) {
            this.checkUpdatedFields(streamEntity, streamInfo);
        }
        if ((statusList = Arrays.asList(EntityStatus.BIZ_WAIT_SUBMIT.getCode(), EntityStatus.BIZ_APPROVE_REJECTED.getCode(), EntityStatus.BIZ_CONFIG_FAILED.getCode())).contains(bizStatus)) {
            String bid = streamInfo.getBusinessIdentifier();
            String dsid = streamInfo.getDataStreamIdentifier();
            boolean dataSourceExist = this.hasDataSource(bid, dsid, streamInfo.getDataSourceType());
            boolean dataStorageExist = this.hasDataStorage(bid, dsid);
            if (dataSourceExist || dataStorageExist) {
                this.checkUpdatedFields(streamEntity, streamInfo);
            }
        }
    }

    private void checkUpdatedFields(DataStreamEntity streamEntity, DataStreamInfo streamInfo) {
        String newBid = streamInfo.getBusinessIdentifier();
        if (newBid != null && !newBid.equals(streamEntity.getBusinessIdentifier())) {
            LOGGER.error("current status was not allowed to update business identifier");
            throw new BusinessException(BizErrorCodeEnum.DATA_STREAM_BID_UPDATE_NOT_ALLOWED);
        }
        String newDsid = streamInfo.getDataStreamIdentifier();
        if (newDsid != null && !newDsid.equals(streamEntity.getDataStreamIdentifier())) {
            LOGGER.error("current status was not allowed to update data stream identifier");
            throw new BusinessException(BizErrorCodeEnum.DATA_STREAM_ID_UPDATE_NOT_ALLOWED);
        }
        String newSourceType = streamInfo.getDataSourceType();
        if (newSourceType != null && !newSourceType.equals(streamEntity.getDataSourceType())) {
            LOGGER.error("current status was not allowed to update data source type");
            throw new BusinessException(BizErrorCodeEnum.DATA_STREAM_SOURCE_UPDATE_NOT_ALLOWED);
        }
    }
}

