/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.thirdpart.hive;

import org.apache.inlong.manager.common.pojo.datastream.DataStreamInfoToHiveConfig;
import org.apache.inlong.manager.service.core.DataStreamService;
import org.apache.inlong.manager.service.thirdpart.hive.HiveTableOperator;
import org.apache.inlong.manager.service.workflow.newbusiness.CreateResourceWorkflowForm;
import org.apache.inlong.manager.workflow.core.event.ListenerResult;
import org.apache.inlong.manager.workflow.core.event.task.TaskEvent;
import org.apache.inlong.manager.workflow.core.event.task.TaskEventListener;
import org.apache.inlong.manager.workflow.model.WorkflowContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CreateHiveTableForOneStreamListener
implements TaskEventListener {
    private static final Logger log = LoggerFactory.getLogger(CreateHiveTableForOneStreamListener.class);
    @Autowired
    private DataStreamService dataStreamService;
    @Autowired
    private HiveTableOperator hiveTableOperator;

    public TaskEvent event() {
        return TaskEvent.COMPLETE;
    }

    public ListenerResult listen(WorkflowContext context) {
        CreateResourceWorkflowForm form = (CreateResourceWorkflowForm)context.getProcessForm();
        String bid = form.getBusinessId();
        String dsid = form.getDataStreamIdentifier();
        log.info("begin create hive table for bid={}, dsid={}", (Object)bid, (Object)dsid);
        DataStreamInfoToHiveConfig hiveConfig = this.dataStreamService.queryHiveConfigForOneDataStream(bid, dsid);
        if (hiveConfig == null) {
            return ListenerResult.success();
        }
        this.hiveTableOperator.createHiveTable(bid, hiveConfig);
        log.info("finish create hive table for business {} - {} ", (Object)bid, (Object)dsid);
        return ListenerResult.success();
    }

    public boolean async() {
        return false;
    }
}

