/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.workflow;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.inlong.manager.common.beans.PageResult;
import org.apache.inlong.manager.common.util.PageUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.service.workflow.ProcessName;
import org.apache.inlong.manager.service.workflow.WorkflowDefinition;
import org.apache.inlong.manager.service.workflow.WorkflowResult;
import org.apache.inlong.manager.service.workflow.WorkflowService;
import org.apache.inlong.manager.service.workflow.WorkflowTaskExecuteLog;
import org.apache.inlong.manager.service.workflow.WorkflowTaskExecuteLogQuery;
import org.apache.inlong.manager.workflow.core.QueryService;
import org.apache.inlong.manager.workflow.core.WorkflowEngine;
import org.apache.inlong.manager.workflow.exception.WorkflowNoRollbackException;
import org.apache.inlong.manager.workflow.model.TaskState;
import org.apache.inlong.manager.workflow.model.definition.Process;
import org.apache.inlong.manager.workflow.model.definition.ProcessForm;
import org.apache.inlong.manager.workflow.model.definition.TaskForm;
import org.apache.inlong.manager.workflow.model.definition.UserTask;
import org.apache.inlong.manager.workflow.model.instance.ProcessInstance;
import org.apache.inlong.manager.workflow.model.view.EventLogQuery;
import org.apache.inlong.manager.workflow.model.view.ProcessDetail;
import org.apache.inlong.manager.workflow.model.view.ProcessListView;
import org.apache.inlong.manager.workflow.model.view.ProcessQuery;
import org.apache.inlong.manager.workflow.model.view.ProcessSummaryQuery;
import org.apache.inlong.manager.workflow.model.view.ProcessSummaryView;
import org.apache.inlong.manager.workflow.model.view.TaskListView;
import org.apache.inlong.manager.workflow.model.view.TaskQuery;
import org.apache.inlong.manager.workflow.model.view.TaskSummaryQuery;
import org.apache.inlong.manager.workflow.model.view.TaskSummaryView;
import org.apache.inlong.manager.workflow.util.WorkflowFormParserUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class WorkflowServiceImpl
implements WorkflowService {
    private static final Logger log = LoggerFactory.getLogger(WorkflowServiceImpl.class);
    private WorkflowEngine workflowEngine;
    @Autowired
    private List<WorkflowDefinition> workflowDefinitions;

    @Autowired
    public WorkflowServiceImpl(WorkflowEngine workflowEngine) {
        this.workflowEngine = workflowEngine;
    }

    @PostConstruct
    private void init() {
        log.info("start init workflow service");
        this.workflowDefinitions.forEach(definition -> {
            this.workflowEngine.processDefinitionService().register(definition.define());
            log.info("success register workflow definition: {}", (Object)definition.getName());
        });
        log.info("success init workflow service");
    }

    @Override
    @Transactional(noRollbackFor={WorkflowNoRollbackException.class}, rollbackFor={Exception.class})
    public WorkflowResult start(ProcessName name, String applicant, ProcessForm form) {
        return WorkflowResult.of(this.workflowEngine.processService().start(name.name(), applicant, form));
    }

    @Override
    @Transactional(noRollbackFor={WorkflowNoRollbackException.class}, rollbackFor={Exception.class})
    public WorkflowResult cancel(Integer processInstId, String operator, String remark) {
        return WorkflowResult.of(this.workflowEngine.processService().cancel(processInstId, operator, remark));
    }

    @Override
    @Transactional(noRollbackFor={WorkflowNoRollbackException.class}, rollbackFor={Exception.class})
    public WorkflowResult approve(Integer taskId, String remark, TaskForm form, String operator) {
        return WorkflowResult.of(this.workflowEngine.taskService().approve(taskId, remark, form, operator));
    }

    @Override
    @Transactional(noRollbackFor={WorkflowNoRollbackException.class}, rollbackFor={Exception.class})
    public WorkflowResult reject(Integer taskId, String remark, String operator) {
        return WorkflowResult.of(this.workflowEngine.taskService().reject(taskId, remark, operator));
    }

    @Override
    @Transactional(noRollbackFor={WorkflowNoRollbackException.class}, rollbackFor={Exception.class})
    public WorkflowResult transfer(Integer taskId, String remark, List<String> to, String operator) {
        return WorkflowResult.of(this.workflowEngine.taskService().transfer(taskId, remark, to, operator));
    }

    @Override
    @Transactional(noRollbackFor={WorkflowNoRollbackException.class}, rollbackFor={Exception.class})
    public WorkflowResult complete(Integer taskId, String remark, String operator) {
        return WorkflowResult.of(this.workflowEngine.taskService().complete(taskId, remark, operator));
    }

    @Override
    public ProcessDetail detail(Integer processInstId, Integer taskInstId) {
        return this.workflowEngine.queryService().detail(processInstId, taskInstId);
    }

    @Override
    public PageResult<ProcessListView> listProcess(ProcessQuery query) {
        PageHelper.startPage((int)query.getPageNum(), (int)query.getPageSize());
        Page result = (Page)this.workflowEngine.queryService().listProcess(query);
        PageInfo pageInfo = result.toPageInfo(processInstance -> {
            ProcessListView processListView = ProcessListView.fromProcessInstance((ProcessInstance)processInstance);
            if (query.isIncludeShowInList()) {
                processListView.setShowInList(this.getShowInList((ProcessInstance)processInstance));
            }
            return processListView;
        });
        pageInfo.setTotal(result.getTotal());
        if (query.isIncludeCurrentTask()) {
            TaskQuery baseTaskQuery = TaskQuery.builder().type(UserTask.class.getSimpleName()).states(Collections.singleton(TaskState.PENDING)).build();
            PageHelper.startPage((int)0, (int)100);
            pageInfo.getList().forEach(this.addCurrentTask(baseTaskQuery));
        }
        return PageUtils.getPageResult((PageInfo)pageInfo);
    }

    @Override
    public PageResult<TaskListView> listTask(TaskQuery query) {
        PageHelper.startPage((int)query.getPageNum(), (int)query.getPageSize());
        Page result = (Page)this.workflowEngine.queryService().listTask(query);
        PageInfo pageInfo = result.toPageInfo(TaskListView::fromTaskInstance);
        this.addShowInListForEachTask(pageInfo.getList());
        pageInfo.setTotal(result.getTotal());
        return PageUtils.getPageResult((PageInfo)pageInfo);
    }

    @Override
    public ProcessSummaryView processSummary(ProcessSummaryQuery query) {
        return this.workflowEngine.queryService().processSummary(query);
    }

    @Override
    public TaskSummaryView taskSummary(TaskSummaryQuery query) {
        return this.workflowEngine.queryService().taskSummary(query);
    }

    @Override
    public List<WorkflowTaskExecuteLog> listTaskExecuteLogs(WorkflowTaskExecuteLogQuery query) {
        Preconditions.checkNotNull((Object)query, (String)"query params can't be null");
        Preconditions.checkNotEmpty((String)query.getBusinessId(), (String)"business id can't be null");
        Preconditions.checkNotEmpty(query.getProcessNames(), (String)"process names can't be null");
        List<WorkflowTaskExecuteLog> workflowTaskExecuteLogs = query.getProcessNames().stream().map(processName -> ProcessQuery.builder().businessId(query.getBusinessId()).name(processName).build()).map(arg_0 -> ((QueryService)this.workflowEngine.queryService()).listProcess(arg_0)).flatMap(Collection::stream).map(WorkflowTaskExecuteLog::buildBaseInfoFromProcessInst).collect(Collectors.toList());
        workflowTaskExecuteLogs.forEach(executeLog -> {
            List<WorkflowTaskExecuteLog.TaskExecutorLog> taskExecutorLogs = this.getTaskExecutorLogs(executeLog.getProcessInstId(), query.getTaskType());
            taskExecutorLogs.forEach(taskExecutorLog -> taskExecutorLog.setListenerExecutorLogs(this.getListenerExecutorLogs((WorkflowTaskExecuteLog.TaskExecutorLog)taskExecutorLog)));
            executeLog.setTaskExecutorLogs(taskExecutorLogs);
        });
        return workflowTaskExecuteLogs;
    }

    private List<WorkflowTaskExecuteLog.TaskExecutorLog> getTaskExecutorLogs(Integer processInstId, String taskType) {
        return this.workflowEngine.queryService().listTask(TaskQuery.builder().processInstId(processInstId).type(taskType).build()).stream().map(WorkflowTaskExecuteLog.TaskExecutorLog::buildFromTaskInst).collect(Collectors.toList());
    }

    private List<WorkflowTaskExecuteLog.ListenerExecutorLog> getListenerExecutorLogs(WorkflowTaskExecuteLog.TaskExecutorLog taskExecutorLog) {
        return this.workflowEngine.queryService().listEventLog(EventLogQuery.builder().taskInstId(taskExecutorLog.getTaskInstId()).build()).stream().map(WorkflowTaskExecuteLog.ListenerExecutorLog::fromEventLog).collect(Collectors.toList());
    }

    private Consumer<ProcessListView> addCurrentTask(TaskQuery baseTaskQuery) {
        return plv -> {
            baseTaskQuery.setProcessInstId(plv.getId());
            plv.setCurrentTasks(this.listTask(baseTaskQuery).getList());
        };
    }

    private Map<String, Object> getShowInList(ProcessInstance processInstance) {
        Process process = this.workflowEngine.processDefinitionService().getByName(processInstance.getName());
        if (process == null || process.getFormClass() == null) {
            return null;
        }
        try {
            ProcessForm processForm = WorkflowFormParserUtils.parseProcessForm((String)processInstance.getFormData(), (Process)process);
            return processForm.showInList();
        }
        catch (Exception e) {
            log.error("get showIn list err", (Throwable)e);
            return null;
        }
    }

    private void addShowInListForEachTask(List<TaskListView> taskList) {
        if (CollectionUtils.isEmpty(taskList)) {
            return;
        }
        PageHelper.clearPage();
        List processInstIds = taskList.stream().map(TaskListView::getProcessInstId).distinct().collect(Collectors.toList());
        List processInstances = this.workflowEngine.queryService().listProcess(ProcessQuery.builder().ids(processInstIds).build());
        HashMap process2ShowInListMap = Maps.newHashMap();
        processInstances.forEach(p -> process2ShowInListMap.put(p.getId(), this.getShowInList((ProcessInstance)p)));
        taskList.forEach(task -> task.setShowInList((Map)process2ShowInListMap.get(task.getProcessInstId())));
    }
}

