/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.workflow.newconsumption;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.inlong.manager.common.pojo.business.BusinessInfo;
import org.apache.inlong.manager.common.pojo.dataconsumption.ConsumptionInfo;
import org.apache.inlong.manager.common.pojo.workflow.WorkflowApproverFilterContext;
import org.apache.inlong.manager.service.core.BusinessService;
import org.apache.inlong.manager.service.core.WorkflowApproverService;
import org.apache.inlong.manager.service.workflow.ProcessName;
import org.apache.inlong.manager.service.workflow.WorkflowDefinition;
import org.apache.inlong.manager.service.workflow.newconsumption.NewConsumptionApproveForm;
import org.apache.inlong.manager.service.workflow.newconsumption.NewConsumptionProcessDetailHandler;
import org.apache.inlong.manager.service.workflow.newconsumption.NewConsumptionWorkflowForm;
import org.apache.inlong.manager.service.workflow.newconsumption.listener.ConsumptionApproveTaskListener;
import org.apache.inlong.manager.service.workflow.newconsumption.listener.ConsumptionCancelProcessListener;
import org.apache.inlong.manager.service.workflow.newconsumption.listener.ConsumptionCompleteProcessListener;
import org.apache.inlong.manager.service.workflow.newconsumption.listener.ConsumptionRejectProcessListener;
import org.apache.inlong.manager.workflow.core.event.process.ProcessEventListener;
import org.apache.inlong.manager.workflow.core.event.task.TaskEventListener;
import org.apache.inlong.manager.workflow.model.WorkflowContext;
import org.apache.inlong.manager.workflow.model.definition.Element;
import org.apache.inlong.manager.workflow.model.definition.EndEvent;
import org.apache.inlong.manager.workflow.model.definition.Process;
import org.apache.inlong.manager.workflow.model.definition.ProcessDetailHandler;
import org.apache.inlong.manager.workflow.model.definition.StartEvent;
import org.apache.inlong.manager.workflow.model.definition.Task;
import org.apache.inlong.manager.workflow.model.definition.UserTask;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NewConsumptionWorkflowDefinition
implements WorkflowDefinition {
    public static final String UT_ADMINT_NAME = "ut_admin";
    public static final String UT_BIZ_OWNER_NAME = "ut_biz_owner";
    @Autowired
    private ConsumptionCompleteProcessListener consumptionCompleteProcessListener;
    @Autowired
    private ConsumptionApproveTaskListener consumptionApproveTaskListener;
    @Autowired
    private ConsumptionRejectProcessListener consumptionRejectProcessListener;
    @Autowired
    private ConsumptionCancelProcessListener consumptionCancelProcessListener;
    @Autowired
    private WorkflowApproverService workflowApproverService;
    @Autowired
    private NewConsumptionProcessDetailHandler newConsumptionProcessDetailHandler;
    @Autowired
    private BusinessService businessService;

    @Override
    public Process define() {
        Process process = new Process();
        process.setType("Data Consumption Resource Creation");
        process.setName(this.getName().name());
        process.setDisplayName(this.getName().getDisplayName());
        process.setFormClass(NewConsumptionWorkflowForm.class);
        process.setVersion(1);
        process.setProcessDetailHandler((ProcessDetailHandler)this.newConsumptionProcessDetailHandler);
        StartEvent startEvent = new StartEvent();
        process.setStartEvent(startEvent);
        EndEvent endEvent = new EndEvent();
        process.setEndEvent(endEvent);
        UserTask bizOwnerUserTask = new UserTask();
        bizOwnerUserTask.setName(UT_BIZ_OWNER_NAME);
        bizOwnerUserTask.setDisplayName("Business Approval");
        bizOwnerUserTask.setApproverAssign(this::bizOwnerUserTaskApprover);
        process.addTask((Task)bizOwnerUserTask);
        UserTask adminUserTask = new UserTask();
        adminUserTask.setName(UT_ADMINT_NAME);
        adminUserTask.setDisplayName("System Administrator");
        adminUserTask.setFormClass(NewConsumptionApproveForm.class);
        adminUserTask.setApproverAssign(this::adminUserTaskApprover);
        adminUserTask.addListener((TaskEventListener)this.consumptionApproveTaskListener);
        process.addTask((Task)adminUserTask);
        startEvent.addNext((Element)bizOwnerUserTask);
        bizOwnerUserTask.addNext((Element)adminUserTask);
        adminUserTask.addNext((Element)endEvent);
        process.addListener((ProcessEventListener)this.consumptionCompleteProcessListener);
        process.addListener((ProcessEventListener)this.consumptionRejectProcessListener);
        process.addListener((ProcessEventListener)this.consumptionCancelProcessListener);
        return process;
    }

    private List<String> adminUserTaskApprover(WorkflowContext context) {
        NewConsumptionWorkflowForm form = (NewConsumptionWorkflowForm)context.getProcessForm();
        ConsumptionInfo consumptionInfo = Optional.ofNullable(form.getConsumptionInfo()).orElseGet(ConsumptionInfo::new);
        return this.workflowApproverService.getApprovers(this.getName().name(), UT_ADMINT_NAME, new WorkflowApproverFilterContext());
    }

    private List<String> bizOwnerUserTaskApprover(WorkflowContext context) {
        NewConsumptionWorkflowForm form = (NewConsumptionWorkflowForm)context.getProcessForm();
        BusinessInfo businessInfo = this.businessService.get(form.getConsumptionInfo().getBusinessIdentifier());
        Iterable inChargesIterator = Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)businessInfo.getInCharges());
        ArrayList inCharges = Lists.newArrayList();
        inChargesIterator.forEach(inCharges::add);
        return inCharges;
    }

    @Override
    public ProcessName getName() {
        return ProcessName.NEW_CONSUMPTION_WORKFLOW;
    }
}

