/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.core.impl;

import java.util.Date;
import java.util.List;
import org.apache.inlong.manager.common.enums.BizErrorCodeEnum;
import org.apache.inlong.manager.common.enums.EntityStatus;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.pojo.business.BusinessInfo;
import org.apache.inlong.manager.common.pojo.business.BusinessMqExtBase;
import org.apache.inlong.manager.common.pojo.business.BusinessPulsarInfo;
import org.apache.inlong.manager.common.pojo.datastream.DataStreamSummaryInfo;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.BusinessEntity;
import org.apache.inlong.manager.dao.entity.BusinessPulsarEntity;
import org.apache.inlong.manager.dao.mapper.BusinessEntityMapper;
import org.apache.inlong.manager.dao.mapper.BusinessPulsarEntityMapper;
import org.apache.inlong.manager.service.core.DataStreamService;
import org.apache.inlong.manager.service.workflow.ProcessName;
import org.apache.inlong.manager.service.workflow.WorkflowResult;
import org.apache.inlong.manager.service.workflow.WorkflowService;
import org.apache.inlong.manager.service.workflow.business.NewBusinessWorkflowForm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BusinessProcessOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger(BusinessProcessOperation.class);
    @Autowired
    BusinessPulsarEntityMapper businessPulsarMapper;
    @Autowired
    private BusinessEntityMapper businessMapper;
    @Autowired
    private WorkflowService workflowService;
    @Autowired
    private DataStreamService streamService;

    public WorkflowResult startProcess(String groupId, String operator) {
        LOGGER.info("begin to start approve process, groupId={}", (Object)groupId);
        Preconditions.checkNotNull((Object)groupId, (String)"business group id is empty");
        BusinessEntity entity = this.businessMapper.selectByIdentifier(groupId);
        if (entity == null) {
            LOGGER.error("business not found by groupId={}", (Object)groupId);
            throw new BusinessException(BizErrorCodeEnum.BUSINESS_NOT_FOUND);
        }
        Preconditions.checkTrue((boolean)EntityStatus.ALLOW_START_WORKFLOW_STATUS.contains(entity.getStatus()), (String)"current status was not allowed to start workflow");
        entity.setModifier(operator);
        entity.setModifyTime(new Date());
        entity.setStatus(EntityStatus.BIZ_WAIT_APPROVAL.getCode());
        int success = this.businessMapper.updateByIdentifierSelective(entity);
        Preconditions.checkTrue((success == 1 ? 1 : 0) != 0, (String)"failed to update business during assign and start process");
        BusinessInfo businessInfo = (BusinessInfo)CommonBeanUtils.copyProperties((Object)entity, BusinessInfo::new);
        NewBusinessWorkflowForm form = this.genNewBusinessWorkflowForm(businessInfo);
        return this.workflowService.start(ProcessName.NEW_BUSINESS_WORKFLOW, operator, form);
    }

    public NewBusinessWorkflowForm genNewBusinessWorkflowForm(BusinessInfo businessInfo) {
        NewBusinessWorkflowForm form = new NewBusinessWorkflowForm();
        form.setBusinessInfo(businessInfo);
        if ("PULSAR".equalsIgnoreCase(businessInfo.getMiddlewareType())) {
            BusinessPulsarEntity pulsarEntity = this.businessPulsarMapper.selectByGroupId(businessInfo.getInlongGroupId());
            BusinessPulsarInfo pulsarInfo = (BusinessPulsarInfo)CommonBeanUtils.copyProperties((Object)pulsarEntity, BusinessPulsarInfo::new);
            businessInfo.setMqExtInfo((BusinessMqExtBase)pulsarInfo);
        }
        form.setBusinessInfo(businessInfo);
        List<DataStreamSummaryInfo> infoList = this.streamService.getSummaryList(businessInfo.getInlongGroupId());
        form.setStreamInfoList(infoList);
        return form;
    }
}

