/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.core.impl;

import org.apache.inlong.manager.common.enums.DBCollectorDetailTaskEntityStatus;
import org.apache.inlong.manager.common.enums.DBCollectorTaskReturnCode;
import org.apache.inlong.manager.common.pojo.dbcollector.DBCollectorReportTaskRequest;
import org.apache.inlong.manager.common.pojo.dbcollector.DBCollectorTaskInfo;
import org.apache.inlong.manager.common.pojo.dbcollector.DBCollectorTaskRequest;
import org.apache.inlong.manager.dao.entity.DBCollectorDetailTaskEntity;
import org.apache.inlong.manager.dao.mapper.DBCollectorDetailTaskMapper;
import org.apache.inlong.manager.service.core.DBCollectorTaskService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DBCollectorTaskServiceImpl
implements DBCollectorTaskService {
    private static final Logger log = LoggerFactory.getLogger(DBCollectorTaskServiceImpl.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(DBCollectorTaskServiceImpl.class);
    @Autowired
    private DBCollectorDetailTaskMapper detailTaskMapper;

    @Override
    public DBCollectorTaskInfo getTask(DBCollectorTaskRequest req) {
        LOGGER.warn("DBCollectorTaskInfo ", (Object)req.toString());
        if (!"1.0".equals(req.getVersion())) {
            DBCollectorTaskInfo taskInfo = DBCollectorTaskInfo.builder().version("1.0").returnCode(DBCollectorTaskReturnCode.INVALID_VERSION.getCode().intValue()).build();
            return taskInfo;
        }
        DBCollectorDetailTaskEntity entity = this.detailTaskMapper.selectOneByState(DBCollectorDetailTaskEntityStatus.INIT.getCode().intValue());
        if (entity == null) {
            DBCollectorTaskInfo taskInfo = DBCollectorTaskInfo.builder().version("1.0").returnCode(DBCollectorTaskReturnCode.EMPTY.getCode().intValue()).build();
            return taskInfo;
        }
        int ret = this.detailTaskMapper.changeState(entity.getId().intValue(), 0, DBCollectorDetailTaskEntityStatus.INIT.getCode().intValue(), DBCollectorDetailTaskEntityStatus.DISPATCHED.getCode().intValue());
        if (ret == 0) {
            DBCollectorTaskInfo taskInfo = DBCollectorTaskInfo.builder().version("1.0").returnCode(DBCollectorTaskReturnCode.EMPTY.getCode().intValue()).build();
            return taskInfo;
        }
        DBCollectorTaskInfo.TaskInfo task = new DBCollectorTaskInfo.TaskInfo();
        task.setId(entity.getId().intValue());
        task.setType(entity.getType().intValue());
        task.setDBType(entity.getDbType().intValue());
        task.setIp(entity.getIp());
        task.setDBPort(entity.getPort().intValue());
        task.setDBName(entity.getDbName());
        task.setUser(entity.getUser());
        task.setPassword(entity.getPassword());
        task.setSqlStatement(entity.getSqlStatement());
        task.setTotalLimit(entity.getTotalLimit().intValue());
        task.setOnceLimit(entity.getOnceLimit().intValue());
        task.setTimeLimit(entity.getTimeLimit().intValue());
        task.setRetryTimes(entity.getRetryTimes().intValue());
        task.setInlongGroupId(entity.getGroupId());
        task.setInlongStreamId(entity.getStreamId());
        DBCollectorTaskInfo taskInfo = DBCollectorTaskInfo.builder().version("1.0").returnCode(DBCollectorTaskReturnCode.SUCC.getCode().intValue()).data(task).build();
        return taskInfo;
    }

    @Override
    public Integer reportTask(DBCollectorReportTaskRequest req) {
        if (req.getVersion() != "1.0") {
            return DBCollectorTaskReturnCode.INVALID_VERSION.getCode();
        }
        DBCollectorDetailTaskEntity entity = this.detailTaskMapper.selectByTaskId(req.getId());
        if (entity == null) {
            return DBCollectorTaskReturnCode.EMPTY.getCode();
        }
        if (req.getState() != DBCollectorDetailTaskEntityStatus.DISPATCHED.getCode().intValue() && req.getState() != DBCollectorDetailTaskEntityStatus.DONE.getCode().intValue() && req.getState() != DBCollectorDetailTaskEntityStatus.FAILED.getCode().intValue()) {
            return DBCollectorTaskReturnCode.INVALID_STATE.getCode();
        }
        int ret = this.detailTaskMapper.changeState(entity.getId().intValue(), req.getOffset(), DBCollectorDetailTaskEntityStatus.DISPATCHED.getCode().intValue(), req.getState());
        if (ret == 0) {
            return DBCollectorTaskReturnCode.EMPTY.getCode();
        }
        return DBCollectorTaskReturnCode.SUCC.getCode();
    }
}

