/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.core.impl;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.commons.pojo.dataproxy.DataProxyConfigResponse;
import org.apache.inlong.manager.common.beans.ClusterBean;
import org.apache.inlong.manager.common.enums.BizErrorCodeEnum;
import org.apache.inlong.manager.common.enums.EntityStatus;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.pojo.cluster.DataProxyClusterInfo;
import org.apache.inlong.manager.common.pojo.cluster.DataProxyClusterPageRequest;
import org.apache.inlong.manager.common.pojo.dataproxy.DataProxyClusterSet;
import org.apache.inlong.manager.common.pojo.dataproxy.DataProxyIpRequest;
import org.apache.inlong.manager.common.pojo.dataproxy.DataProxyIpResponse;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.BusinessEntity;
import org.apache.inlong.manager.dao.entity.DataProxyClusterEntity;
import org.apache.inlong.manager.dao.entity.DataProxyConfig;
import org.apache.inlong.manager.dao.entity.DataStreamEntity;
import org.apache.inlong.manager.dao.mapper.BusinessEntityMapper;
import org.apache.inlong.manager.dao.mapper.DataProxyClusterEntityMapper;
import org.apache.inlong.manager.dao.mapper.DataStreamEntityMapper;
import org.apache.inlong.manager.service.core.DataProxyClusterService;
import org.apache.inlong.manager.service.repository.DataProxyConfigRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DataProxyClusterServiceImpl
implements DataProxyClusterService {
    private static final Logger log = LoggerFactory.getLogger(DataProxyClusterServiceImpl.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(DataProxyClusterServiceImpl.class);
    @Autowired
    private DataProxyClusterEntityMapper dataProxyClusterMapper;
    @Autowired
    private BusinessEntityMapper businessMapper;
    @Autowired
    private DataStreamEntityMapper dataStreamMapper;
    @Autowired
    private DataProxyConfigRepository proxyRepository;
    @Autowired
    private ClusterBean clusterBean;

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public Integer save(DataProxyClusterInfo clusterInfo, String operator) {
        LOGGER.info("begin to save data proxy cluster={}", (Object)clusterInfo);
        Preconditions.checkNotNull((Object)clusterInfo, (String)"data proxy cluster is empty");
        DataProxyClusterEntity entity = (DataProxyClusterEntity)CommonBeanUtils.copyProperties((Object)clusterInfo, DataProxyClusterEntity::new);
        entity.setCreator(operator);
        entity.setModifier(operator);
        entity.setCreateTime(new Date());
        this.dataProxyClusterMapper.insertSelective(entity);
        LOGGER.info("success to save data proxy cluster");
        return entity.getId();
    }

    @Override
    public DataProxyClusterInfo get(Integer id) {
        LOGGER.info("begin to get data proxy cluster by id={}", (Object)id);
        Preconditions.checkNotNull((Object)id, (String)"data proxy cluster id is empty");
        DataProxyClusterEntity entity = this.dataProxyClusterMapper.selectByPrimaryKey(id);
        if (entity == null) {
            LOGGER.error("data proxy cluster not found by id={}", (Object)id);
            throw new BusinessException(BizErrorCodeEnum.CLUSTER_NOT_FOUND);
        }
        DataProxyClusterInfo clusterInfo = (DataProxyClusterInfo)CommonBeanUtils.copyProperties((Object)entity, DataProxyClusterInfo::new);
        LOGGER.info("success to get data proxy cluster info");
        return clusterInfo;
    }

    @Override
    public PageInfo<DataProxyClusterInfo> listByCondition(DataProxyClusterPageRequest request) {
        LOGGER.info("begin to list data proxy cluster by {}", (Object)request);
        PageHelper.startPage((int)request.getPageNum(), (int)request.getPageSize());
        Page entityPage = (Page)this.dataProxyClusterMapper.selectByCondition(request);
        List clusterList = CommonBeanUtils.copyListProperties((List)entityPage, DataProxyClusterInfo::new);
        PageInfo page = new PageInfo(clusterList);
        page.setTotal(entityPage.getTotal());
        LOGGER.info("success to list data proxy cluster");
        return page;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public Boolean update(DataProxyClusterInfo clusterInfo, String operator) {
        LOGGER.info("begin to update data proxy cluster={}", (Object)clusterInfo);
        Preconditions.checkNotNull((Object)clusterInfo, (String)"data proxy cluster is empty");
        Integer id = clusterInfo.getId();
        Preconditions.checkNotNull((Object)id, (String)"data proxy cluster id is empty");
        DataProxyClusterEntity entity = this.dataProxyClusterMapper.selectByPrimaryKey(id);
        if (entity == null) {
            LOGGER.error("data proxy cluster not found by id={}", (Object)id);
            throw new BusinessException(BizErrorCodeEnum.CLUSTER_NOT_FOUND);
        }
        CommonBeanUtils.copyProperties((Object)clusterInfo, (Object)entity, (boolean)true);
        entity.setModifier(operator);
        this.dataProxyClusterMapper.updateByPrimaryKeySelective(entity);
        LOGGER.info("success to update data proxy cluster");
        return true;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public Boolean delete(Integer id, String operator) {
        LOGGER.info("begin to delete data proxy cluster by id={}", (Object)id);
        Preconditions.checkNotNull((Object)id, (String)"data proxy cluster id is empty");
        DataProxyClusterEntity entity = this.dataProxyClusterMapper.selectByPrimaryKey(id);
        if (entity == null) {
            LOGGER.error("data proxy cluster not found by id={}", (Object)id);
            throw new BusinessException(BizErrorCodeEnum.CLUSTER_NOT_FOUND);
        }
        entity.setIsDeleted(EntityStatus.IS_DELETED.getCode());
        entity.setStatus(EntityStatus.DELETED.getCode());
        entity.setModifier(operator);
        this.dataProxyClusterMapper.updateByPrimaryKey(entity);
        LOGGER.info("success to delete data proxy cluster");
        return true;
    }

    @Override
    public List<DataProxyIpResponse> getIpList(DataProxyIpRequest request) {
        LOGGER.debug("begin to get data proxy ip list, request: {}", (Object)request);
        List entityList = this.dataProxyClusterMapper.selectAll();
        if (entityList == null || entityList.isEmpty()) {
            LOGGER.info("success to get data proxy ip list, but result is empty, request ip={}", (Object)request.getIp());
            return null;
        }
        String requestNetTag = request.getNetTag();
        ArrayList<DataProxyIpResponse> responseList = new ArrayList<DataProxyIpResponse>();
        for (DataProxyClusterEntity entity : entityList) {
            int innerIp;
            String netTag = requestNetTag;
            if (StringUtils.isEmpty((CharSequence)netTag) && StringUtils.isEmpty((CharSequence)(netTag = (innerIp = entity.getIsInnerIp().intValue()) == 1 ? "auto" : entity.getNetType()))) {
                netTag = "all";
            }
            DataProxyIpResponse response = new DataProxyIpResponse();
            response.setId(entity.getId());
            response.setPort(entity.getPort());
            response.setIp(entity.getAddress());
            response.setNetTag(netTag);
            responseList.add(response);
        }
        LOGGER.info("success to get data proxy ip list, response size={}", (Object)responseList.size());
        return responseList;
    }

    @Override
    public List<DataProxyConfig> getConfig() {
        List bizEntityList = this.businessMapper.selectAll(EntityStatus.BIZ_CONFIG_SUCCESSFUL.getCode());
        ArrayList<DataProxyConfig> configList = new ArrayList<DataProxyConfig>();
        for (BusinessEntity entity : bizEntityList) {
            String groupId = entity.getInlongGroupId();
            String bizResource = entity.getMqResourceObj();
            DataProxyConfig config = new DataProxyConfig();
            config.setM(entity.getSchemaName());
            if ("TUBE".equals(entity.getMiddlewareType())) {
                config.setInlongGroupId(groupId);
                config.setTopic(bizResource);
            } else if ("PULSAR".equals(entity.getMiddlewareType())) {
                List streamList = this.dataStreamMapper.selectByGroupId(groupId);
                for (DataStreamEntity stream : streamList) {
                    String streamId = stream.getInlongStreamId();
                    config.setInlongGroupId(groupId + "/" + streamId);
                    config.setTopic("persistent://" + this.clusterBean.getDefaultTenant() + "/" + groupId + "/" + streamId);
                }
            }
            configList.add(config);
        }
        return configList;
    }

    @Override
    public String getAllConfig(String clusterName, String setName, String md5) {
        DataProxyClusterSet setObj = this.proxyRepository.getDataProxyClusterSet(setName);
        if (setObj == null) {
            return this.getErrorAllConfig();
        }
        String configMd5 = (String)setObj.getMd5Map().get(clusterName);
        if (configMd5 == null || !configMd5.equals(md5)) {
            return this.getErrorAllConfig();
        }
        String configJson = (String)setObj.getProxyConfigJson().get(clusterName);
        if (configJson == null) {
            return this.getErrorAllConfig();
        }
        return configJson;
    }

    private String getErrorAllConfig() {
        DataProxyConfigResponse response = new DataProxyConfigResponse();
        response.setResult(Boolean.valueOf(false));
        response.setErrCode(Integer.valueOf(-101));
        Gson gson = new Gson();
        return gson.toJson((Object)response);
    }
}

