/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.core.impl;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.BizErrorCodeEnum;
import org.apache.inlong.manager.common.enums.EntityStatus;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.pojo.datasource.SourceDbBasicInfo;
import org.apache.inlong.manager.common.pojo.datasource.SourceDbDetailInfo;
import org.apache.inlong.manager.common.pojo.datasource.SourceFileBasicInfo;
import org.apache.inlong.manager.common.pojo.datasource.SourceFileDetailInfo;
import org.apache.inlong.manager.common.pojo.datastorage.BaseStorageRequest;
import org.apache.inlong.manager.common.pojo.datastorage.BaseStorageResponse;
import org.apache.inlong.manager.common.pojo.datastorage.StorageSummaryInfo;
import org.apache.inlong.manager.common.pojo.datastream.DataStreamApproveInfo;
import org.apache.inlong.manager.common.pojo.datastream.DataStreamExtInfo;
import org.apache.inlong.manager.common.pojo.datastream.DataStreamFieldInfo;
import org.apache.inlong.manager.common.pojo.datastream.DataStreamInfo;
import org.apache.inlong.manager.common.pojo.datastream.DataStreamListVO;
import org.apache.inlong.manager.common.pojo.datastream.DataStreamPageRequest;
import org.apache.inlong.manager.common.pojo.datastream.DataStreamSummaryInfo;
import org.apache.inlong.manager.common.pojo.datastream.DataStreamTopicVO;
import org.apache.inlong.manager.common.pojo.datastream.FullPageUpdateInfo;
import org.apache.inlong.manager.common.pojo.datastream.FullStreamRequest;
import org.apache.inlong.manager.common.pojo.datastream.FullStreamResponse;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.BusinessEntity;
import org.apache.inlong.manager.dao.entity.DataStreamEntity;
import org.apache.inlong.manager.dao.entity.DataStreamExtEntity;
import org.apache.inlong.manager.dao.entity.DataStreamFieldEntity;
import org.apache.inlong.manager.dao.mapper.BusinessEntityMapper;
import org.apache.inlong.manager.dao.mapper.DataStreamEntityMapper;
import org.apache.inlong.manager.dao.mapper.DataStreamExtEntityMapper;
import org.apache.inlong.manager.dao.mapper.DataStreamFieldEntityMapper;
import org.apache.inlong.manager.service.core.DataStreamService;
import org.apache.inlong.manager.service.core.SourceDbService;
import org.apache.inlong.manager.service.core.SourceFileService;
import org.apache.inlong.manager.service.core.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DataStreamServiceImpl
implements DataStreamService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataStreamServiceImpl.class);
    @Autowired
    private DataStreamEntityMapper streamMapper;
    @Autowired
    private DataStreamExtEntityMapper streamExtMapper;
    @Autowired
    private DataStreamFieldEntityMapper streamFieldMapper;
    @Autowired
    private BusinessEntityMapper businessMapper;
    @Autowired
    private SourceFileService sourceFileService;
    @Autowired
    private SourceDbService sourceDbService;
    @Autowired
    private StorageService storageService;

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public Integer save(DataStreamInfo streamInfo, String operator) {
        LOGGER.debug("begin to save data stream info={}", (Object)streamInfo);
        Preconditions.checkNotNull((Object)streamInfo, (String)"data stream info is empty");
        String groupId = streamInfo.getInlongGroupId();
        String streamId = streamInfo.getInlongStreamId();
        Preconditions.checkNotNull((Object)groupId, (String)"business group id is empty");
        Preconditions.checkNotNull((Object)streamId, (String)"data stream id is empty");
        BusinessEntity businessEntity = this.checkBizIsTempStatus(groupId);
        Integer count = this.streamMapper.selectExistByIdentifier(groupId, streamId);
        if (count >= 1) {
            LOGGER.error("data stream id [{}] has already exists", (Object)streamId);
            throw new BusinessException(BizErrorCodeEnum.DATA_STREAM_ID_DUPLICATE);
        }
        streamInfo.setMqResourceObj(streamId);
        DataStreamEntity streamEntity = (DataStreamEntity)CommonBeanUtils.copyProperties((Object)streamInfo, DataStreamEntity::new);
        Date date = new Date();
        streamEntity.setStatus(EntityStatus.DATA_STREAM_NEW.getCode());
        streamEntity.setModifier(operator);
        streamEntity.setCreateTime(date);
        this.streamMapper.insertSelective(streamEntity);
        this.saveExt(groupId, streamId, streamInfo.getExtList(), date);
        this.saveField(groupId, streamId, streamInfo.getFieldList());
        LOGGER.info("success to save data stream info for groupId={}", (Object)groupId);
        return streamEntity.getId();
    }

    @Override
    public DataStreamInfo get(String groupId, String streamId) {
        LOGGER.debug("begin to get data stream by groupId={}, streamId={}", (Object)groupId, (Object)streamId);
        Preconditions.checkNotNull((Object)groupId, (String)"business group id is empty");
        Preconditions.checkNotNull((Object)streamId, (String)"data stream id is empty");
        DataStreamEntity streamEntity = this.streamMapper.selectByIdentifier(groupId, streamId);
        if (streamEntity == null) {
            LOGGER.error("data stream not found by groupId={}, streamId={}", (Object)groupId, (Object)streamId);
            throw new BusinessException(BizErrorCodeEnum.DATA_STREAM_NOT_FOUND);
        }
        DataStreamInfo streamInfo = (DataStreamInfo)CommonBeanUtils.copyProperties((Object)streamEntity, DataStreamInfo::new);
        this.setStreamExtAndField(groupId, streamId, streamInfo);
        LOGGER.info("success to get data stream for groupId={}", (Object)groupId);
        return streamInfo;
    }

    @Override
    public Boolean exist(String groupId, String streamId) {
        Preconditions.checkNotNull((Object)groupId, (String)"business group id is empty");
        DataStreamEntity streamEntity = this.streamMapper.selectByIdentifier(groupId, streamId);
        return streamEntity != null;
    }

    private void setStreamExtAndField(String groupId, String streamId, DataStreamInfo streamInfo) {
        List fieldEntityList;
        List extEntityList = this.streamExtMapper.selectByIdentifier(groupId, streamId);
        if (CollectionUtils.isNotEmpty((Collection)extEntityList)) {
            streamInfo.setExtList(CommonBeanUtils.copyListProperties((List)extEntityList, DataStreamExtInfo::new));
        }
        if (CollectionUtils.isNotEmpty((Collection)(fieldEntityList = this.streamFieldMapper.selectByIdentifier(groupId, streamId)))) {
            streamInfo.setFieldList(CommonBeanUtils.copyListProperties((List)fieldEntityList, DataStreamFieldInfo::new));
        }
    }

    @Override
    public PageInfo<DataStreamListVO> listByCondition(DataStreamPageRequest request) {
        LOGGER.debug("begin to list data stream page by {}", (Object)request);
        PageHelper.startPage((int)request.getPageNum(), (int)request.getPageSize());
        Page entityPage = (Page)this.streamMapper.selectByCondition(request);
        List dataStreamList = CommonBeanUtils.copyListProperties((List)entityPage, DataStreamListVO::new);
        String groupId = request.getInlongGroupId();
        String storageType = request.getStorageType();
        if (StringUtils.isNotEmpty((CharSequence)storageType)) {
            List<String> streamIdList = dataStreamList.stream().map(DataStreamListVO::getInlongStreamId).distinct().collect(Collectors.toList());
            List<String> resultList = this.storageService.filterStreamIdByStorageType(groupId, storageType, streamIdList);
            dataStreamList.removeIf(entity -> resultList.contains(entity.getInlongStreamId()));
        }
        if (request.getNeedStorageList() == 1) {
            dataStreamList.forEach(stream -> {
                String streamId = stream.getInlongStreamId();
                List<String> storageTypeList = this.storageService.getStorageTypeList(groupId, streamId);
                stream.setStorageTypeList(storageTypeList);
            });
        }
        PageInfo page = new PageInfo(dataStreamList);
        page.setTotal((long)dataStreamList.size());
        LOGGER.debug("success to list data stream info for groupId={}", (Object)groupId);
        return page;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public boolean update(DataStreamInfo streamInfo, String operator) {
        LOGGER.debug("begin to update data stream info={}", (Object)streamInfo);
        Preconditions.checkNotNull((Object)streamInfo, (String)"data stream info is empty");
        String groupId = streamInfo.getInlongGroupId();
        Preconditions.checkNotNull((Object)groupId, (String)"business group id is empty");
        String streamId = streamInfo.getInlongStreamId();
        Preconditions.checkNotNull((Object)streamId, (String)"data stream id is empty");
        BusinessEntity businessEntity = this.checkBizIsTempStatus(groupId);
        DataStreamEntity streamEntity = this.streamMapper.selectByIdentifier(groupId, streamId);
        if (streamEntity == null) {
            this.save(streamInfo, operator);
        } else {
            this.checkCanUpdate(businessEntity.getStatus(), streamEntity, streamInfo);
            CommonBeanUtils.copyProperties((Object)streamInfo, (Object)streamEntity, (boolean)true);
            streamEntity.setModifier(operator);
            streamEntity.setStatus(EntityStatus.BIZ_CONFIG_ING.getCode());
            this.streamMapper.updateByIdentifierSelective(streamEntity);
            this.updateExt(groupId, streamId, streamInfo.getExtList());
            this.updateField(groupId, streamId, streamInfo.getFieldList());
        }
        LOGGER.info("success to update business info for groupId={}", (Object)groupId);
        return true;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public boolean delete(String groupId, String streamId, String operator) {
        LOGGER.debug("begin to delete data stream, groupId={}, streamId={}", (Object)groupId, (Object)streamId);
        Preconditions.checkNotNull((Object)groupId, (String)"business group id is empty");
        Preconditions.checkNotNull((Object)streamId, (String)"data stream id is empty");
        BusinessEntity businessEntity = this.checkBizIsTempStatus(groupId);
        DataStreamEntity entity = this.streamMapper.selectByIdentifier(groupId, streamId);
        if (entity == null) {
            LOGGER.error("data stream not found by groupId={}, streamId={}", (Object)groupId, (Object)streamId);
            throw new BusinessException(BizErrorCodeEnum.DATA_STREAM_NOT_FOUND);
        }
        boolean dataSourceExist = this.hasDataSource(groupId, streamId, entity.getDataSourceType());
        if (dataSourceExist) {
            LOGGER.error("data stream has undeleted data sources, delete failed");
            throw new BusinessException(BizErrorCodeEnum.DATA_STREAM_DELETE_HAS_SOURCE);
        }
        boolean dataStorageExist = this.hasDataStorage(groupId, streamId);
        if (dataStorageExist) {
            LOGGER.error("data stream has undeleted data storages, delete failed");
            throw new BusinessException(BizErrorCodeEnum.DATA_STREAM_DELETE_HAS_STORAGE);
        }
        entity.setIsDeleted(Integer.valueOf(1));
        entity.setModifier(operator);
        this.streamMapper.updateByPrimaryKey(entity);
        LOGGER.debug("begin to delete data stream ext property, groupId={}, streamId={}", (Object)groupId, (Object)streamId);
        this.streamExtMapper.logicDeleteAllByIdentifier(groupId, streamId);
        LOGGER.debug("begin to delete data stream field, streamId={}", (Object)streamId);
        this.streamFieldMapper.logicDeleteAllByIdentifier(groupId, streamId);
        LOGGER.info("success to delete data stream, ext property and fields for groupId={}", (Object)groupId);
        return true;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public boolean logicDeleteAll(String groupId, String operator) {
        LOGGER.debug("begin to delete all data stream by groupId={}", (Object)groupId);
        Preconditions.checkNotNull((Object)groupId, (String)"business group id is empty");
        this.checkBizIsTempStatus(groupId);
        List entityList = this.streamMapper.selectByGroupId(groupId);
        if (CollectionUtils.isEmpty((Collection)entityList)) {
            LOGGER.info("data stream not found by groupId={}", (Object)groupId);
            return true;
        }
        for (DataStreamEntity entity : entityList) {
            entity.setIsDeleted(Integer.valueOf(1));
            entity.setModifier(operator);
            this.streamMapper.updateByIdentifierSelective(entity);
            String streamId = entity.getInlongStreamId();
            this.streamExtMapper.logicDeleteAllByIdentifier(groupId, streamId);
            this.streamFieldMapper.logicDeleteAllByIdentifier(groupId, streamId);
            this.sourceFileService.logicDeleteAllByIdentifier(groupId, streamId, operator);
            this.sourceDbService.logicDeleteAllByIdentifier(groupId, streamId, operator);
            this.storageService.logicDeleteAllByIdentifier(groupId, streamId, operator);
        }
        LOGGER.info("success to delete all data stream, ext property and fields by groupId={}", (Object)groupId);
        return true;
    }

    private boolean hasDataStorage(String groupId, String streamId) {
        Integer count = this.storageService.getCountByIdentifier(groupId, streamId);
        return count > 0;
    }

    private boolean hasDataSource(String groupId, String streamId, String dataSourceType) {
        boolean exist;
        if ("FILE".equalsIgnoreCase(dataSourceType)) {
            List<SourceFileDetailInfo> fileDetailList = this.sourceFileService.listDetailByIdentifier(groupId, streamId);
            exist = CollectionUtils.isNotEmpty(fileDetailList);
        } else if ("DB".equalsIgnoreCase(dataSourceType)) {
            List<SourceDbDetailInfo> dbDetailList = this.sourceDbService.listDetailByIdentifier(groupId, streamId);
            exist = CollectionUtils.isNotEmpty(dbDetailList);
        } else {
            exist = false;
        }
        return exist;
    }

    @Override
    public List<DataStreamSummaryInfo> getSummaryList(String groupId) {
        LOGGER.debug("begin to get data stream summary list by groupId={}", (Object)groupId);
        Preconditions.checkNotNull((Object)groupId, (String)"business group id is empty");
        List entityList = this.streamMapper.selectByGroupId(groupId);
        List summaryInfoList = CommonBeanUtils.copyListProperties((List)entityList, DataStreamSummaryInfo::new);
        for (DataStreamSummaryInfo summaryInfo : summaryInfoList) {
            String streamId = summaryInfo.getInlongStreamId();
            List<StorageSummaryInfo> storageList = this.storageService.listSummaryByIdentifier(groupId, streamId);
            summaryInfo.setStorageList(storageList);
        }
        LOGGER.info("success to get data stream summary list for groupId={}", (Object)groupId);
        return summaryInfoList;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public boolean saveAll(FullStreamRequest fullStreamRequest, String operator) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("begin to save all stream page info: {}", (Object)fullStreamRequest);
        }
        Preconditions.checkNotNull((Object)fullStreamRequest, (String)"fullStreamRequest is empty");
        DataStreamInfo streamInfo = fullStreamRequest.getStreamInfo();
        Preconditions.checkNotNull((Object)streamInfo, (String)"data stream info is empty");
        this.save(streamInfo, operator);
        if (fullStreamRequest.getFileBasicInfo() != null) {
            this.sourceFileService.saveBasic(fullStreamRequest.getFileBasicInfo(), operator);
        }
        if (CollectionUtils.isNotEmpty((Collection)fullStreamRequest.getFileDetailInfoList())) {
            for (SourceFileDetailInfo detailInfo : fullStreamRequest.getFileDetailInfoList()) {
                this.sourceFileService.saveDetail(detailInfo, operator);
            }
        }
        if (fullStreamRequest.getDbBasicInfo() != null) {
            this.sourceDbService.saveBasic(fullStreamRequest.getDbBasicInfo(), operator);
        }
        if (CollectionUtils.isNotEmpty((Collection)fullStreamRequest.getDbDetailInfoList())) {
            for (SourceFileDetailInfo detailInfo : fullStreamRequest.getDbDetailInfoList()) {
                this.sourceDbService.saveDetail((SourceDbDetailInfo)detailInfo, operator);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)fullStreamRequest.getStorageInfo())) {
            for (BaseStorageRequest storageInfo : fullStreamRequest.getStorageInfo()) {
                this.storageService.save(storageInfo, operator);
            }
        }
        LOGGER.info("success to save all stream page info");
        return true;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public boolean batchSaveAll(List<FullStreamRequest> fullStreamRequestList, String operator) {
        if (CollectionUtils.isEmpty(fullStreamRequestList)) {
            return true;
        }
        LOGGER.info("begin to batch save all stream page info, batch size={}", (Object)fullStreamRequestList.size());
        DataStreamInfo firstStream = fullStreamRequestList.get(0).getStreamInfo();
        Preconditions.checkNotNull((Object)firstStream, (String)"data stream info is empty");
        String groupId = firstStream.getInlongGroupId();
        this.checkBizIsTempStatus(groupId);
        this.streamMapper.deleteAllByGroupId(groupId);
        for (FullStreamRequest pageInfo : fullStreamRequestList) {
            DataStreamInfo streamInfo = pageInfo.getStreamInfo();
            String streamId = streamInfo.getInlongStreamId();
            this.streamExtMapper.deleteAllByIdentifier(groupId, streamId);
            this.streamFieldMapper.deleteAllByIdentifier(groupId, streamId);
            this.sourceFileService.deleteAllByIdentifier(groupId, streamId);
            this.sourceDbService.deleteAllByIdentifier(groupId, streamId);
            this.storageService.deleteAllByIdentifier(groupId, streamId);
            this.saveAll(pageInfo, operator);
        }
        LOGGER.info("success to batch save all stream page info");
        return true;
    }

    @Override
    public PageInfo<FullStreamResponse> listAllWithGroupId(DataStreamPageRequest request) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("begin to list full data stream page by {}", (Object)request);
        }
        LOGGER.debug("begin to list full data stream page by {}", (Object)request);
        Preconditions.checkNotNull((Object)request, (String)"request is empty");
        Preconditions.checkNotNull((Object)request.getInlongGroupId(), (String)"business group id is empty");
        String groupId = request.getInlongGroupId();
        BusinessEntity businessEntity = this.businessMapper.selectByIdentifier(groupId);
        Preconditions.checkNotNull((Object)businessEntity, (String)("business not found by groupId=" + groupId));
        String inCharges = businessEntity.getInCharges();
        request.setInCharges(inCharges);
        PageHelper.startPage((int)request.getPageNum(), (int)request.getPageSize());
        Page page = (Page)this.streamMapper.selectByCondition(request);
        List streamInfoList = CommonBeanUtils.copyListProperties((List)page, DataStreamInfo::new);
        ArrayList<FullStreamResponse> responseList = new ArrayList<FullStreamResponse>(streamInfoList.size());
        for (DataStreamInfo streamInfo : streamInfoList) {
            String streamId = streamInfo.getInlongStreamId();
            this.setStreamExtAndField(groupId, streamId, streamInfo);
            FullStreamResponse pageInfo = new FullStreamResponse();
            pageInfo.setStreamInfo(streamInfo);
            String dataSourceType = streamInfo.getDataSourceType();
            if (StringUtils.isEmpty((CharSequence)dataSourceType)) continue;
            switch (dataSourceType.toUpperCase(Locale.ROOT)) {
                case "FILE": {
                    SourceFileBasicInfo fileBasicInfo = this.sourceFileService.getBasicByIdentifier(groupId, streamId);
                    pageInfo.setFileBasicInfo(fileBasicInfo);
                    List<SourceFileDetailInfo> fileDetailInfoList = this.sourceFileService.listDetailByIdentifier(groupId, streamId);
                    pageInfo.setFileDetailInfoList(fileDetailInfoList);
                    break;
                }
                case "DB": {
                    SourceDbBasicInfo dbBasicInfo = this.sourceDbService.getBasicByIdentifier(groupId, streamId);
                    pageInfo.setDbBasicInfo(dbBasicInfo);
                    List<SourceDbDetailInfo> dbDetailInfoList = this.sourceDbService.listDetailByIdentifier(groupId, streamId);
                    pageInfo.setDbDetailInfoList(dbDetailInfoList);
                    break;
                }
                case "AUTO_PUSH": {
                    break;
                }
                default: {
                    throw new BusinessException(BizErrorCodeEnum.DATA_SOURCE_TYPE_NOT_SUPPORTED);
                }
            }
            List<BaseStorageResponse> storageInfoList = this.storageService.listByIdentifier(groupId, streamId);
            pageInfo.setStorageInfo(storageInfoList);
            responseList.add(pageInfo);
        }
        PageInfo pageInfo = new PageInfo(responseList);
        pageInfo.setTotal(pageInfo.getTotal());
        LOGGER.info("success to list full data stream info");
        return pageInfo;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public boolean updateAll(FullPageUpdateInfo updateInfo, String operator) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("begin to update all stream page info: {}", (Object)updateInfo);
        }
        Preconditions.checkNotNull((Object)updateInfo, (String)"updateInfo is empty");
        Preconditions.checkNotNull((Object)updateInfo.getStreamInfo(), (String)"data stream info is empty");
        this.update(updateInfo.getStreamInfo(), operator);
        if (updateInfo.getFileBasicInfo() != null) {
            this.sourceFileService.updateBasic(updateInfo.getFileBasicInfo(), operator);
        }
        if (updateInfo.getDbBasicInfo() != null) {
            this.sourceDbService.updateBasic(updateInfo.getDbBasicInfo(), operator);
        }
        LOGGER.info("success to update all stream page info");
        return true;
    }

    @Override
    public int selectCountByGroupId(String groupId) {
        LOGGER.debug("begin to get count by groupId={}", (Object)groupId);
        if (StringUtils.isEmpty((CharSequence)groupId)) {
            return 0;
        }
        int count = this.streamMapper.selectCountByGroupId(groupId);
        LOGGER.info("success to get count");
        return count;
    }

    @Override
    public List<DataStreamTopicVO> getTopicList(String groupId) {
        LOGGER.debug("begin bo get topic list by group id={}", (Object)groupId);
        Preconditions.checkNotNull((Object)groupId, (String)"business group id is empty");
        List topicList = this.streamMapper.selectTopicList(groupId);
        LOGGER.debug("success to get topic list by groupId={}", (Object)groupId);
        return topicList;
    }

    @Override
    public boolean updateAfterApprove(List<DataStreamApproveInfo> streamApproveList, String operator) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("begin to update stream after approve={}", streamApproveList);
        }
        if (CollectionUtils.isEmpty(streamApproveList)) {
            return true;
        }
        String groupId = null;
        for (DataStreamApproveInfo info : streamApproveList) {
            DataStreamEntity streamEntity = new DataStreamEntity();
            groupId = info.getInlongGroupId();
            streamEntity.setInlongGroupId(groupId);
            streamEntity.setInlongStreamId(info.getInlongStreamId());
            streamEntity.setStatus(EntityStatus.DATA_STREAM_CONFIG_ING.getCode());
            this.streamMapper.updateByIdentifierSelective(streamEntity);
            this.storageService.updateAfterApprove(info.getStorageList(), operator);
        }
        LOGGER.info("success to update stream after approve for groupId={}", groupId);
        return true;
    }

    @Override
    public boolean updateStatus(String groupId, String streamId, Integer status, String operator) {
        LOGGER.debug("begin to update status by groupId={}, streamId={}", (Object)groupId, (Object)streamId);
        this.streamMapper.updateStatusByIdentifier(groupId, streamId, status, operator);
        LOGGER.info("success to update stream after approve for groupId=" + groupId + ", streamId=" + streamId);
        return true;
    }

    @Override
    public void insertDlqOrRlq(String groupId, String topicName, String operator) {
        Integer count = this.streamMapper.selectExistByIdentifier(groupId, topicName);
        if (count >= 1) {
            LOGGER.error("DLQ/RLQ topic already exists with name={}", (Object)topicName);
            throw new BusinessException(BizErrorCodeEnum.DATA_STREAM_ID_DUPLICATE, "DLQ/RLQ topic already exists");
        }
        DataStreamEntity streamEntity = new DataStreamEntity();
        streamEntity.setInlongGroupId(groupId);
        streamEntity.setInlongStreamId(topicName);
        streamEntity.setMqResourceObj(topicName);
        streamEntity.setDescription("This is DLQ / RLQ topic created by SYSTEM");
        streamEntity.setDailyRecords(Integer.valueOf(1000));
        streamEntity.setDailyStorage(Integer.valueOf(1000));
        streamEntity.setPeakRecords(Integer.valueOf(1000));
        streamEntity.setMaxLength(Integer.valueOf(1000));
        streamEntity.setStatus(EntityStatus.DATA_STREAM_CONFIG_SUCCESSFUL.getCode());
        streamEntity.setIsDeleted(EntityStatus.UN_DELETED.getCode());
        streamEntity.setCreator(operator);
        streamEntity.setModifier(operator);
        Date now = new Date();
        streamEntity.setCreateTime(now);
        streamEntity.setModifyTime(now);
        this.streamMapper.insert(streamEntity);
    }

    @Override
    public void logicDeleteDlqOrRlq(String groupId, String topicName, String operator) {
        this.streamMapper.logicDeleteDlqOrRlq(groupId, topicName, operator);
        LOGGER.info("success to logic delete dlq or rlq by groupId={}, topicName={}", (Object)groupId, (Object)topicName);
    }

    @Transactional(rollbackFor={Throwable.class})
    void updateExt(String groupId, String streamId, List<DataStreamExtInfo> extInfoList) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("begin to update data stream ext, groupId={}, streamId={}, ext={}", new Object[]{groupId, streamId, extInfoList});
        }
        try {
            this.streamExtMapper.deleteAllByIdentifier(groupId, streamId);
            this.saveExt(groupId, streamId, extInfoList, new Date());
            LOGGER.info("success to update data stream ext for groupId={}", (Object)groupId);
        }
        catch (Exception e) {
            LOGGER.error("failed to update data stream ext: ", (Throwable)e);
            throw new BusinessException(BizErrorCodeEnum.DATA_STREAM_EXT_SAVE_FAILED);
        }
    }

    @Transactional(rollbackFor={Throwable.class})
    void saveExt(String groupId, String streamId, List<DataStreamExtInfo> infoList, Date date) {
        if (CollectionUtils.isEmpty(infoList)) {
            return;
        }
        List entityList = CommonBeanUtils.copyListProperties(infoList, DataStreamExtEntity::new);
        for (DataStreamExtEntity entity : entityList) {
            entity.setInlongGroupId(groupId);
            entity.setInlongStreamId(streamId);
            entity.setModifyTime(date);
        }
        this.streamExtMapper.insertAll(entityList);
    }

    @Transactional(rollbackFor={Throwable.class})
    void updateField(String groupId, String streamId, List<DataStreamFieldInfo> fieldInfoList) {
        LOGGER.debug("begin to update data stream field, groupId={}, streamId={}, field={}", new Object[]{groupId, streamId, fieldInfoList});
        try {
            this.streamFieldMapper.deleteAllByIdentifier(groupId, streamId);
            this.saveField(groupId, streamId, fieldInfoList);
            LOGGER.info("success to update data stream field for groupId={}", (Object)groupId);
        }
        catch (Exception e) {
            LOGGER.error("failed to update data stream field: ", (Throwable)e);
            throw new BusinessException(BizErrorCodeEnum.DATA_STREAM_FIELD_SAVE_FAILED);
        }
    }

    @Transactional(rollbackFor={Throwable.class})
    void saveField(String groupId, String streamId, List<DataStreamFieldInfo> infoList) {
        if (CollectionUtils.isEmpty(infoList)) {
            return;
        }
        List entities = CommonBeanUtils.copyListProperties(infoList, DataStreamFieldEntity::new);
        for (DataStreamFieldEntity entity : entities) {
            entity.setInlongGroupId(groupId);
            entity.setInlongStreamId(streamId);
        }
        this.streamFieldMapper.insertAll(entities);
    }

    private BusinessEntity checkBizIsTempStatus(String groupId) {
        BusinessEntity businessEntity = this.businessMapper.selectByIdentifier(groupId);
        Preconditions.checkNotNull((Object)businessEntity, (String)"groupId is invalid");
        if (EntityStatus.BIZ_TEMP_STATUS.contains((Object)businessEntity.getStatus())) {
            LOGGER.error("business status was not allowed to add/update/delete data stream");
            throw new BusinessException(BizErrorCodeEnum.DATA_STREAM_OPT_NOT_ALLOWED);
        }
        return businessEntity;
    }

    private void checkCanUpdate(Integer bizStatus, DataStreamEntity streamEntity, DataStreamInfo streamInfo) {
        List<Integer> statusList;
        if (streamEntity == null || streamInfo == null) {
            return;
        }
        if (EntityStatus.BIZ_CONFIG_SUCCESSFUL.getCode().equals(bizStatus)) {
            this.checkUpdatedFields(streamEntity, streamInfo);
        }
        if ((statusList = Arrays.asList(EntityStatus.BIZ_WAIT_SUBMIT.getCode(), EntityStatus.BIZ_APPROVE_REJECTED.getCode(), EntityStatus.BIZ_CONFIG_FAILED.getCode())).contains(bizStatus)) {
            String groupId = streamInfo.getInlongGroupId();
            String streamId = streamInfo.getInlongStreamId();
            boolean dataSourceExist = this.hasDataSource(groupId, streamId, streamInfo.getDataSourceType());
            boolean dataStorageExist = this.hasDataStorage(groupId, streamId);
            if (dataSourceExist || dataStorageExist) {
                this.checkUpdatedFields(streamEntity, streamInfo);
            }
        }
    }

    private void checkUpdatedFields(DataStreamEntity streamEntity, DataStreamInfo streamInfo) {
        String newGroupId = streamInfo.getInlongGroupId();
        if (newGroupId != null && !newGroupId.equals(streamEntity.getInlongGroupId())) {
            LOGGER.error("current status was not allowed to update business group id");
            throw new BusinessException(BizErrorCodeEnum.DATA_STREAM_ID_UPDATE_NOT_ALLOWED);
        }
        String newDsid = streamInfo.getInlongStreamId();
        if (newDsid != null && !newDsid.equals(streamEntity.getInlongStreamId())) {
            LOGGER.error("current status was not allowed to update data stream id");
            throw new BusinessException(BizErrorCodeEnum.DATA_STREAM_ID_UPDATE_NOT_ALLOWED);
        }
        String newSourceType = streamInfo.getDataSourceType();
        if (newSourceType != null && !newSourceType.equals(streamEntity.getDataSourceType())) {
            LOGGER.error("current status was not allowed to update data source type");
            throw new BusinessException(BizErrorCodeEnum.DATA_STREAM_SOURCE_UPDATE_NOT_ALLOWED);
        }
    }
}

