/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.core.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.pojo.sort.SortClusterConfigResponse;
import org.apache.inlong.manager.dao.entity.SortClusterConfigEntity;
import org.apache.inlong.manager.service.core.SortClusterConfigService;
import org.apache.inlong.manager.service.core.SortService;
import org.apache.inlong.manager.service.core.SortTaskIdParamService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SortServiceImpl
implements SortService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SortServiceImpl.class);
    @Autowired
    private SortClusterConfigService sortClusterConfigService;
    @Autowired
    private SortTaskIdParamService sortTaskIdParamService;

    @Override
    public SortClusterConfigResponse getClusterConfig(String clusterName, String md5) {
        LOGGER.info("start getClusterConfig");
        if (StringUtils.isBlank((CharSequence)clusterName)) {
            String errMsg = "Blank cluster name, return nothing";
            LOGGER.info(errMsg);
            return SortClusterConfigResponse.builder().msg(errMsg).build();
        }
        List<SortClusterConfigEntity> tasks = this.sortClusterConfigService.selectTasksByClusterName(clusterName);
        if (tasks == null || tasks.isEmpty()) {
            String errMsg = "There is not any task for cluster" + clusterName;
            LOGGER.info(errMsg);
            return SortClusterConfigResponse.builder().msg(errMsg).build();
        }
        ArrayList taskConfigs = new ArrayList();
        try {
            tasks.forEach(clusterConfig -> taskConfigs.add(this.getTaskConfig((SortClusterConfigEntity)clusterConfig)));
        }
        catch (IllegalArgumentException ex) {
            String errMsg = "Got illegal sink type from db, " + ex.getMessage();
            LOGGER.info(errMsg);
            return SortClusterConfigResponse.builder().msg(errMsg).build();
        }
        return SortClusterConfigResponse.builder().tasks(taskConfigs).msg("success").build();
    }

    private SortClusterConfigResponse.SortTaskConfig getTaskConfig(SortClusterConfigEntity clusterConfig) {
        List<Map<String, String>> idParams = this.sortTaskIdParamService.selectByTaskName(clusterConfig.getTaskName());
        return SortClusterConfigResponse.SortTaskConfig.builder().taskName(clusterConfig.getTaskName()).sinkType(SortClusterConfigResponse.SinkType.valueOf((String)clusterConfig.getSinkType().toUpperCase())).idParams(idParams).sinkParams(null).build();
    }
}

