/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.core.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.inlong.manager.dao.entity.SortTaskIdParamEntity;
import org.apache.inlong.manager.dao.mapper.SortTaskIdParamEntityMapper;
import org.apache.inlong.manager.service.core.SortTaskIdParamService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SortTaskIdParamServiceImpl
implements SortTaskIdParamService {
    private static final String KEY_GROUP_ID = "inlongGroupId";
    private static final String KEY_STREAM_ID = "inlongStreamId";
    @Autowired
    private SortTaskIdParamEntityMapper sortTaskIdParamEntityMapper;
    private final Map<String, Map<String, String>> idParams = new HashMap<String, Map<String, String>>();

    @Override
    public List<Map<String, String>> selectByTaskName(String taskName) {
        List taskIdParamEntityList = this.sortTaskIdParamEntityMapper.selectByTaskName(taskName);
        this.idParams.clear();
        taskIdParamEntityList.forEach(this::addParam);
        return new ArrayList<Map<String, String>>(this.idParams.values());
    }

    private void addParam(SortTaskIdParamEntity entity) {
        Map idParam = this.idParams.computeIfAbsent(entity.getKey(), key -> new HashMap());
        idParam.put(entity.getParamKey(), entity.getParamValue());
        idParam.putIfAbsent(KEY_GROUP_ID, entity.getGroupId());
        idParam.putIfAbsent(KEY_STREAM_ID, entity.getStreamId());
    }
}

