/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.core.impl;

import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.BizErrorCodeEnum;
import org.apache.inlong.manager.common.enums.EntityStatus;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.pojo.datastorage.BaseStorageListResponse;
import org.apache.inlong.manager.common.pojo.datastorage.BaseStorageRequest;
import org.apache.inlong.manager.common.pojo.datastorage.BaseStorageResponse;
import org.apache.inlong.manager.common.pojo.datastorage.StorageApproveInfo;
import org.apache.inlong.manager.common.pojo.datastorage.StorageHiveListResponse;
import org.apache.inlong.manager.common.pojo.datastorage.StoragePageRequest;
import org.apache.inlong.manager.common.pojo.datastorage.StorageSummaryInfo;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.BusinessEntity;
import org.apache.inlong.manager.dao.entity.StorageHiveEntity;
import org.apache.inlong.manager.dao.mapper.StorageHiveEntityMapper;
import org.apache.inlong.manager.service.core.StorageService;
import org.apache.inlong.manager.service.core.impl.StorageBaseOperation;
import org.apache.inlong.manager.service.core.impl.StorageHiveOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class StorageServiceImpl
extends StorageBaseOperation
implements StorageService {
    private static final Logger LOGGER = LoggerFactory.getLogger(StorageServiceImpl.class);
    @Autowired
    private StorageHiveOperation hiveOperation;
    @Autowired
    private StorageHiveEntityMapper hiveStorageMapper;

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public Integer save(BaseStorageRequest storageInfo, String operator) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("begin to save storage info={}", (Object)storageInfo);
        }
        Preconditions.checkNotNull((Object)storageInfo, (String)"storage info is empty");
        String groupId = storageInfo.getInlongGroupId();
        Preconditions.checkNotNull((Object)groupId, (String)"business group id is empty");
        String streamId = storageInfo.getInlongStreamId();
        Preconditions.checkNotNull((Object)streamId, (String)"data stream id is empty");
        BusinessEntity businessEntity = super.checkBizIsTempStatus(groupId);
        String storageType = storageInfo.getStorageType();
        Preconditions.checkNotNull((Object)storageType, (String)"storageType is empty");
        if (!"HIVE".equals(storageType.toUpperCase(Locale.ROOT))) {
            LOGGER.error("the storageType={} not support", (Object)storageType);
            throw new BusinessException(BizErrorCodeEnum.STORAGE_TYPE_NOT_SUPPORTED);
        }
        int id = this.hiveOperation.saveHiveStorage(storageInfo, operator);
        if (EntityStatus.BIZ_CONFIG_SUCCESSFUL.getCode().equals(businessEntity.getStatus())) {
            this.executorService.execute(new StorageBaseOperation.WorkflowStartRunnable(operator, businessEntity, streamId));
        }
        LOGGER.info("success to save storage info");
        return id;
    }

    @Override
    public BaseStorageResponse getById(String storageType, Integer id) {
        LOGGER.debug("begin to get storage by storageType={}, id={}", (Object)storageType, (Object)id);
        Preconditions.checkNotNull((Object)id, (String)"storage id is null");
        Preconditions.checkNotNull((Object)storageType, (String)"storageType is empty");
        if (!"HIVE".equals(storageType.toUpperCase(Locale.ROOT))) {
            LOGGER.error("the storageType={} not support", (Object)storageType);
            throw new BusinessException(BizErrorCodeEnum.STORAGE_TYPE_NOT_SUPPORTED);
        }
        BaseStorageResponse storageInfo = this.hiveOperation.getHiveStorage(id);
        LOGGER.info("success to get storage info");
        return storageInfo;
    }

    @Override
    public Integer getCountByIdentifier(String groupId, String streamId) {
        LOGGER.debug("begin to get storage count by groupId={}, streamId={}", (Object)groupId, (Object)streamId);
        Preconditions.checkNotNull((Object)groupId, (String)"business group id is empty");
        Preconditions.checkNotNull((Object)streamId, (String)"data stream id is empty");
        Integer count = this.hiveStorageMapper.selectCountByIdentifier(groupId, streamId);
        LOGGER.info("the storage count={} by groupId={}, streamId={}", new Object[]{count, groupId, streamId});
        return count;
    }

    @Override
    public List<BaseStorageResponse> listByIdentifier(String groupId, String streamId) {
        LOGGER.debug("begin to list storage by groupId={}, streamId={}", (Object)groupId, (Object)streamId);
        Preconditions.checkNotNull((Object)groupId, (String)"business group id is empty");
        ArrayList<BaseStorageResponse> responseList = new ArrayList<BaseStorageResponse>();
        this.hiveOperation.setHiveStorageResponse(groupId, streamId, responseList);
        LOGGER.info("success to list storage info");
        return responseList;
    }

    @Override
    public List<StorageSummaryInfo> listSummaryByIdentifier(String groupId, String streamId) {
        LOGGER.debug("begin to list storage summary by groupId={}, streamId={}", (Object)groupId, (Object)streamId);
        Preconditions.checkNotNull((Object)groupId, (String)"business group id is empty");
        Preconditions.checkNotNull((Object)streamId, (String)"data stream id is empty");
        ArrayList<StorageSummaryInfo> totalList = new ArrayList<StorageSummaryInfo>();
        List hiveSummaryList = this.hiveStorageMapper.selectSummary(groupId, streamId);
        totalList.addAll(hiveSummaryList);
        LOGGER.info("success to list storage summary");
        return totalList;
    }

    @Override
    public PageInfo<? extends BaseStorageListResponse> listByCondition(StoragePageRequest request) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("begin to list storage page by {}", (Object)request);
        }
        Preconditions.checkNotNull((Object)request.getInlongGroupId(), (String)"business group id is empty");
        String storageType = request.getStorageType();
        Preconditions.checkNotNull((Object)storageType, (String)"storageType is empty");
        if (!"HIVE".equals(storageType.toUpperCase(Locale.ROOT))) {
            LOGGER.error("the storageType={} not support", (Object)storageType);
            throw new BusinessException(BizErrorCodeEnum.STORAGE_TYPE_NOT_SUPPORTED);
        }
        PageInfo<StorageHiveListResponse> page = this.hiveOperation.getHiveStorageList(request);
        LOGGER.info("success to list storage page");
        return page;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public boolean update(BaseStorageRequest storageRequest, String operator) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("begin to update storage info={}", (Object)storageRequest);
        }
        Preconditions.checkNotNull((Object)storageRequest, (String)"storage info is empty");
        String groupId = storageRequest.getInlongGroupId();
        Preconditions.checkNotNull((Object)groupId, (String)"business group id is empty");
        String streamId = storageRequest.getInlongStreamId();
        Preconditions.checkNotNull((Object)streamId, (String)"data stream id is empty");
        BusinessEntity businessEntity = super.checkBizIsTempStatus(groupId);
        String storageType = storageRequest.getStorageType();
        Preconditions.checkNotNull((Object)storageType, (String)"storageType is empty");
        if (!"HIVE".equals(storageType.toUpperCase(Locale.ROOT))) {
            LOGGER.error("the storageType={} not support", (Object)storageType);
            throw new BusinessException(BizErrorCodeEnum.STORAGE_TYPE_NOT_SUPPORTED);
        }
        this.hiveOperation.updateHiveStorage(businessEntity.getStatus(), storageRequest, operator);
        if (EntityStatus.BIZ_CONFIG_SUCCESSFUL.getCode().equals(businessEntity.getStatus())) {
            this.executorService.execute(new StorageBaseOperation.WorkflowStartRunnable(operator, businessEntity, streamId));
        }
        LOGGER.info("success to update storage info");
        return true;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public boolean delete(String storageType, Integer id, String operator) {
        LOGGER.debug("begin to delete storage by storageType={}, id={}", (Object)storageType, (Object)id);
        Preconditions.checkNotNull((Object)id, (String)"storage id is null");
        Preconditions.checkNotNull((Object)storageType, (String)"storageType is empty");
        if (!"HIVE".equals(storageType.toUpperCase(Locale.ROOT))) {
            LOGGER.error("the storageType={} not support", (Object)storageType);
            throw new BusinessException(BizErrorCodeEnum.STORAGE_TYPE_NOT_SUPPORTED);
        }
        boolean result = this.hiveOperation.logicDeleteHiveStorage(id, operator);
        LOGGER.info("success to delete storage info");
        return result;
    }

    @Override
    public void updateHiveStatusById(int id, int status, String log) {
        StorageHiveEntity entity = new StorageHiveEntity();
        entity.setId(Integer.valueOf(id));
        entity.setStatus(Integer.valueOf(status));
        entity.setOptLog(log);
        this.hiveStorageMapper.updateStorageStatusById(entity);
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public boolean deleteAllByIdentifier(String groupId, String streamId) {
        LOGGER.debug("begin to delete all storage info by groupId={}, streamId={}", (Object)groupId, (Object)streamId);
        Preconditions.checkNotNull((Object)groupId, (String)"business group id is empty");
        Preconditions.checkNotNull((Object)streamId, (String)"data stream id is empty");
        this.checkBizIsTempStatus(groupId);
        this.hiveOperation.deleteHiveByIdentifier(groupId, streamId);
        LOGGER.info("success to delete all storage info");
        return true;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public boolean logicDeleteAllByIdentifier(String groupId, String streamId, String operator) {
        LOGGER.debug("begin to logic delete all storage info by groupId={}, streamId={}", (Object)groupId, (Object)streamId);
        Preconditions.checkNotNull((Object)groupId, (String)"business group id is empty");
        Preconditions.checkNotNull((Object)streamId, (String)"data stream id is empty");
        this.checkBizIsTempStatus(groupId);
        this.hiveOperation.logicDeleteHiveByIdentifier(groupId, streamId, operator);
        LOGGER.info("success to logic delete all storage info");
        return true;
    }

    @Override
    public List<String> filterStreamIdByStorageType(String groupId, String storageType, List<String> streamIdList) {
        LOGGER.debug("begin to filter stream by groupId={}, type={}, streamId={}", new Object[]{groupId, storageType, streamIdList});
        List<String> resultList = new ArrayList<String>();
        if (StringUtils.isEmpty((CharSequence)storageType) || CollectionUtils.isEmpty(streamIdList)) {
            return resultList;
        }
        if (!"HIVE".equals(storageType.toUpperCase(Locale.ROOT))) {
            LOGGER.error("the storageType={} not support", (Object)storageType);
            throw new BusinessException(BizErrorCodeEnum.STORAGE_TYPE_NOT_SUPPORTED);
        }
        resultList = this.hiveStorageMapper.selectDataStreamExists(groupId, streamIdList);
        LOGGER.info("success to filter stream");
        return resultList;
    }

    @Override
    public List<String> getStorageTypeList(String groupId, String streamId) {
        LOGGER.debug("begin to get storage type list by groupId={}, streamId={}", (Object)groupId, (Object)streamId);
        ArrayList<String> resultList = new ArrayList<String>();
        if (StringUtils.isEmpty((CharSequence)streamId)) {
            return resultList;
        }
        if (this.hiveStorageMapper.selectCountByIdentifier(groupId, streamId) > 0) {
            resultList.add("HIVE");
        }
        LOGGER.info("success to get storage type list");
        return resultList;
    }

    @Override
    public boolean updateAfterApprove(List<StorageApproveInfo> storageApproveList, String operator) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("begin to update storage after approve={}", storageApproveList);
        }
        if (CollectionUtils.isEmpty(storageApproveList)) {
            return true;
        }
        for (StorageApproveInfo info : storageApproveList) {
            String storageType = info.getStorageType();
            Preconditions.checkNotNull((Object)storageType, (String)"storageType is empty");
            if ("HIVE".equals(storageType.toUpperCase(Locale.ROOT))) {
                StorageHiveEntity hiveEntity = new StorageHiveEntity();
                hiveEntity.setId(info.getId());
                hiveEntity.setModifier(operator);
                hiveEntity.setStatus(EntityStatus.DATA_STORAGE_CONFIG_ING.getCode());
                this.hiveStorageMapper.updateByPrimaryKeySelective(hiveEntity);
                continue;
            }
            LOGGER.error("the storageType={} not support", (Object)storageType);
            throw new BusinessException(BizErrorCodeEnum.STORAGE_TYPE_NOT_SUPPORTED);
        }
        LOGGER.info("success to update storage after approve");
        return true;
    }
}

