/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.core.impl;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Date;
import java.util.List;
import org.apache.inlong.manager.common.enums.UserTypeEnum;
import org.apache.inlong.manager.common.pojo.user.PasswordChangeRequest;
import org.apache.inlong.manager.common.pojo.user.UserDetailListVO;
import org.apache.inlong.manager.common.pojo.user.UserDetailPageRequest;
import org.apache.inlong.manager.common.pojo.user.UserInfo;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.LoginUserUtil;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.common.util.SmallTools;
import org.apache.inlong.manager.dao.entity.UserEntity;
import org.apache.inlong.manager.dao.entity.UserEntityExample;
import org.apache.inlong.manager.dao.mapper.UserEntityMapper;
import org.apache.inlong.manager.service.core.UserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserServiceImpl
implements UserService {
    private static final Logger log = LoggerFactory.getLogger(UserServiceImpl.class);
    @Autowired
    private UserEntityMapper userMapper;

    @Override
    public UserEntity getByName(String username) {
        UserEntityExample example = new UserEntityExample();
        example.createCriteria().andNameEqualTo(username);
        List list = this.userMapper.selectByExample(example);
        return list.isEmpty() ? null : (UserEntity)list.get(0);
    }

    @Override
    public UserInfo getById(Integer userId) {
        Preconditions.checkNotNull((Object)userId, (String)"User id should not be empty");
        UserEntity entity = this.userMapper.selectByPrimaryKey(userId);
        Preconditions.checkNotNull((Object)entity, (String)("User not exists with id " + userId));
        UserInfo result = new UserInfo();
        result.setId(entity.getId());
        result.setUsername(entity.getName());
        result.setValidDays(SmallTools.getValidDays((Date)entity.getCreateTime(), (Date)entity.getDueDate()));
        result.setType(entity.getAccountType());
        log.debug("success to get user info by id={}", (Object)userId);
        return result;
    }

    @Override
    public boolean create(UserInfo userInfo) {
        String username = userInfo.getUsername();
        UserEntity userExists = this.getByName(username);
        Preconditions.checkNull((Object)userExists, (String)("User [" + username + "] already exists"));
        UserEntity entity = new UserEntity();
        entity.setAccountType(userInfo.getType());
        entity.setPassword(SmallTools.passwordMd5((String)userInfo.getPassword()));
        entity.setDueDate(SmallTools.getOverDueDate((Integer)userInfo.getValidDays()));
        entity.setCreateBy(LoginUserUtil.getLoginUserDetail().getUserName());
        entity.setName(username);
        entity.setCreateTime(new Date());
        Preconditions.checkTrue((this.userMapper.insert(entity) > 0 ? 1 : 0) != 0, (String)"Create user failed");
        log.debug("success to create user info={}", (Object)userInfo);
        return true;
    }

    @Override
    public int update(UserInfo userInfo, String currentUser) {
        Preconditions.checkNotNull((Object)userInfo, (String)"User info should not be null");
        Preconditions.checkNotNull((Object)userInfo.getId(), (String)"User id should not be null");
        UserEntity currentUserEntity = this.getByName(currentUser);
        Preconditions.checkTrue((boolean)currentUserEntity.getAccountType().equals(UserTypeEnum.MANAGER.getCode()), (String)"The current user is not a manager and does not have permission to update users");
        UserEntity entity = this.userMapper.selectByPrimaryKey(userInfo.getId());
        Preconditions.checkNotNull((Object)entity, (String)("User not exists with id " + userInfo.getId()));
        entity.setDueDate(SmallTools.getOverDueDate((Integer)userInfo.getValidDays()));
        entity.setAccountType(userInfo.getType());
        entity.setName(userInfo.getUsername());
        log.debug("success to update user info={}", (Object)userInfo);
        return this.userMapper.updateByPrimaryKeySelective(entity);
    }

    @Override
    public Integer updatePassword(PasswordChangeRequest request) {
        String username = request.getName();
        UserEntity entity = this.getByName(username);
        Preconditions.checkNotNull((Object)entity, (String)("User [" + username + "] not exists"));
        String oldPassword = request.getOldPassword();
        String oldPasswordMd = SmallTools.passwordMd5((String)oldPassword);
        Preconditions.checkTrue((boolean)oldPasswordMd.equals(entity.getPassword()), (String)"Old password is wrong");
        String newPasswordMd5 = SmallTools.passwordMd5((String)request.getNewPassword());
        entity.setPassword(newPasswordMd5);
        log.debug("success to update user password, username={}", (Object)username);
        return this.userMapper.updateByPrimaryKey(entity);
    }

    @Override
    public Boolean delete(Integer userId, String currentUser) {
        Preconditions.checkNotNull((Object)userId, (String)"User id should not be empty");
        UserEntity entity = this.getByName(currentUser);
        Preconditions.checkTrue((boolean)entity.getAccountType().equals(UserTypeEnum.MANAGER.getCode()), (String)"The current user is not a manager and does not have permission to delete users");
        this.userMapper.deleteByPrimaryKey(userId);
        log.debug("success to delete user by id={}, current user={}", (Object)userId, (Object)currentUser);
        return true;
    }

    @Override
    public PageInfo<UserDetailListVO> list(UserDetailPageRequest request) {
        PageHelper.startPage((int)request.getPageNum(), (int)request.getPageSize());
        UserEntityExample example = new UserEntityExample();
        UserEntityExample.Criteria criteria = example.createCriteria();
        if (request.getUserName() != null) {
            criteria.andNameLike(request.getUserName() + "%");
        }
        Page entityPage = (Page)this.userMapper.selectByExample(example);
        List detailList = CommonBeanUtils.copyListProperties((List)entityPage, UserDetailListVO::new);
        detailList.forEach(entity -> entity.setStatus(entity.getDueDate().after(new Date()) ? "valid" : "invalid"));
        PageInfo page = new PageInfo(detailList);
        page.setTotal(entityPage.getTotal());
        log.debug("success to list all user, result size={}", (Object)page.getTotal());
        return page;
    }
}

