/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.core.impl;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.List;
import org.apache.inlong.manager.common.event.process.ProcessEvent;
import org.apache.inlong.manager.common.event.task.TaskEvent;
import org.apache.inlong.manager.common.model.instance.EventLog;
import org.apache.inlong.manager.common.model.view.EventLogQuery;
import org.apache.inlong.manager.common.model.view.EventLogView;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.workflow.EventListenerService;
import org.apache.inlong.manager.common.workflow.QueryService;
import org.apache.inlong.manager.service.core.WorkflowEventService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WorkflowEventServiceImpl
implements WorkflowEventService {
    @Autowired
    private QueryService queryService;
    @Autowired
    private EventListenerService eventListenerService;

    @Override
    public EventLogView get(Integer id) {
        EventLog eventLog = this.queryService.getEventLog(id);
        return (EventLogView)CommonBeanUtils.copyProperties((Object)eventLog, EventLogView::new);
    }

    @Override
    public PageInfo<EventLogView> list(EventLogQuery query) {
        PageHelper.startPage((int)query.getPageNum(), (int)query.getPageSize());
        Page page = (Page)this.queryService.listEventLog(query);
        List viewList = CommonBeanUtils.copyListProperties((List)page, EventLogView::new);
        PageInfo pageInfo = new PageInfo(viewList);
        pageInfo.setTotal(page.getTotal());
        return pageInfo;
    }

    @Override
    public void executeEventListener(Integer eventLogId) {
        this.eventListenerService.executeEventListener(eventLogId);
    }

    @Override
    public void executeProcessEventListener(Integer processInstId, String listenerName) {
        this.eventListenerService.executeProcessEventListener(processInstId, listenerName);
    }

    @Override
    public void executeTaskEventListener(Integer taskInstId, String listenerName) {
        this.eventListenerService.executeTaskEventListener(taskInstId, listenerName);
    }

    @Override
    public void triggerProcessEvent(Integer processInstId, ProcessEvent processEvent) {
        this.eventListenerService.triggerProcessEvent(processInstId, processEvent);
    }

    @Override
    public void triggerTaskEvent(Integer taskInstId, TaskEvent taskEvent) {
        this.eventListenerService.triggerTaskEvent(taskInstId, taskEvent);
    }
}

