/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.core.plugin;

import com.google.common.collect.Lists;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class JarHell {
    public static final JavaVersion CURRENT_VERSION = new JavaVersion(Lists.newArrayList((Object[])new Integer[]{1, 8}), null);

    private JarHell() {
    }

    public static void checkJavaVersion(String resource, String javaVersion) {
        JavaVersion version = JarHell.parse(javaVersion);
        if (CURRENT_VERSION.compareTo(version) < 0) {
            throw new IllegalArgumentException(String.format("%s requires Java %s:, your system: %s", resource, CURRENT_VERSION, javaVersion));
        }
    }

    public static JavaVersion parse(String value) {
        String[] numericComponents;
        Objects.requireNonNull(value);
        String prePart = null;
        if (!JarHell.isValid(value)) {
            throw new IllegalArgumentException("Java version string [" + value + "] could not be parsed.");
        }
        ArrayList<Integer> version = new ArrayList<Integer>();
        String[] parts = value.split("-");
        if (parts.length == 1) {
            numericComponents = value.split("\\.");
        } else if (parts.length == 2) {
            numericComponents = parts[0].split("\\.");
            prePart = parts[1];
        } else {
            throw new IllegalArgumentException("Java version string [" + value + "] could not be parsed.");
        }
        for (String component : numericComponents) {
            version.add(Integer.valueOf(component));
        }
        return new JavaVersion(version, prePart);
    }

    public static boolean isValid(String value) {
        return value.matches("^0*[0-9]+(\\.[0-9]+)*(-[a-zA-Z0-9]+)?$");
    }

    public static class JavaVersion {
        private final List<Integer> version;
        private final String prePart;

        public List<Integer> getVersion() {
            return this.version;
        }

        private JavaVersion(List<Integer> version, String prePart) {
            this.prePart = prePart;
            if (version.size() >= 2 && version.get(0) == 1 && version.get(1) == 8) {
                version = new ArrayList<Integer>(version.subList(1, version.size()));
            }
            this.version = Collections.unmodifiableList(version);
        }

        public String toString() {
            return StringUtils.join(this.version, (char)'.') + "-" + this.prePart;
        }

        public int compareTo(JavaVersion o) {
            int len = Math.max(this.version.size(), o.version.size());
            for (int i = 0; i < len; ++i) {
                int s;
                int d = i < this.version.size() ? this.version.get(i) : 0;
                int n = s = i < o.version.size() ? o.version.get(i) : 0;
                if (s < d) {
                    return 1;
                }
                if (s <= d) continue;
                return -1;
            }
            if (this.prePart != null && o.prePart == null) {
                return -1;
            }
            if (this.prePart == null && o.prePart != null) {
                return 1;
            }
            if (this.prePart != null && o.prePart != null) {
                return this.comparePrePart(this.prePart, o.prePart);
            }
            return 0;
        }

        private int comparePrePart(String prePart, String otherPrePart) {
            if (prePart.matches("\\d+")) {
                return otherPrePart.matches("\\d+") ? new BigInteger(prePart).compareTo(new BigInteger(otherPrePart)) : -1;
            }
            return otherPrePart.matches("\\d+") ? 1 : prePart.compareTo(otherPrePart);
        }
    }
}

