/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.core.plugin;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.plugin.PluginDefinition;
import org.apache.inlong.manager.service.core.plugin.JarHell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginClassLoader
extends URLClassLoader {
    private static final Logger log = LoggerFactory.getLogger(PluginClassLoader.class);
    public static final String PLUGIN_PATH = "META-INF/plugin.yaml";
    public static final int PLUGIN_DEF_CAPACITY = 1024;
    private Map<String, PluginDefinition> pluginDefinitionMap = new HashMap<String, PluginDefinition>();
    private File pluginDirectory;
    private ObjectMapper yamlMapper;

    private PluginClassLoader(URL url, ClassLoader parent) throws IOException {
        super(new URL[]{url}, parent);
        this.pluginDirectory = new File(url.getPath());
        this.initYamlMapper();
        this.loadPluginDefinition();
    }

    public static PluginClassLoader getFromPluginUrl(final String url, final ClassLoader parent) {
        PluginClassLoader.checkClassLoader(parent);
        PluginClassLoader.checkUrl(url);
        return AccessController.doPrivileged(new PrivilegedAction<PluginClassLoader>(){

            @Override
            public PluginClassLoader run() {
                return new PluginClassLoader(new URL("file://" + url), parent);
            }
        });
    }

    public Map<String, PluginDefinition> getPluginDefinitions() {
        return this.pluginDefinitionMap;
    }

    private void initYamlMapper() {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.yamlMapper = mapper;
    }

    private void loadPluginDefinition() throws IOException {
        ArrayList<PluginDefinition> definitions = new ArrayList<PluginDefinition>();
        for (File jarFile : this.pluginDirectory.listFiles()) {
            if (!jarFile.getName().endsWith(".jar")) {
                log.warn("{}' is not plugin jar , please check", (Object)jarFile);
                continue;
            }
            JarFile pluginJar = new JarFile(jarFile);
            String pluginDef = this.readPluginDef(pluginJar);
            pluginDef = pluginDef.replaceAll("[\\x00]+", "");
            PluginDefinition definition2 = (PluginDefinition)this.yamlMapper.readValue(pluginDef, PluginDefinition.class);
            this.addURL(new URL("file://" + jarFile.getAbsolutePath()));
            this.checkPluginValid(jarFile, definition2);
            definitions.add(definition2);
        }
        this.pluginDefinitionMap = definitions.stream().collect(Collectors.toMap(definition -> definition.getName(), definition -> definition));
    }

    private void checkPluginValid(File jarFile, PluginDefinition pluginDefinition) {
        if (StringUtils.isEmpty((CharSequence)pluginDefinition.getName())) {
            throw new RuntimeException(String.format("%s should define pluginName in plugin.yaml", jarFile.getName()));
        }
        if (StringUtils.isEmpty((CharSequence)pluginDefinition.getPluginClass())) {
            throw new RuntimeException(String.format("%s should define pluginClass in plugin.yaml", jarFile.getName()));
        }
        try {
            this.loadClass(pluginDefinition.getPluginClass());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(String.format("pluginClass '%s' could not be found in %s", pluginDefinition.getPluginClass(), jarFile.getName()));
        }
        if (StringUtils.isEmpty((CharSequence)pluginDefinition.getDescription())) {
            log.warn(String.format("%s should define description in plugin.yaml", jarFile.getName()));
        }
        if (StringUtils.isEmpty((CharSequence)pluginDefinition.getJavaVersion())) {
            throw new RuntimeException(String.format("%s should define javaVersion in plugin.yaml", jarFile.getName()));
        }
        JarHell.checkJavaVersion(pluginDefinition.getName(), pluginDefinition.getJavaVersion());
    }

    private String readPluginDef(JarFile jar) throws IOException {
        JarEntry entry = jar.getJarEntry(PLUGIN_PATH);
        if (entry == null) {
            throw new RuntimeException(String.format("%s is not found in jar '%s'", PLUGIN_PATH, jar.getName()));
        }
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        try (InputStream is = jar.getInputStream(entry);){
            int bt;
            while ((bt = is.read()) != -1) {
                buffer.put((byte)bt);
            }
        }
        return new String(buffer.array(), StandardCharsets.UTF_8);
    }

    private static void checkClassLoader(ClassLoader classLoader) {
        if (classLoader == null) {
            throw new RuntimeException("parent classLoader should not be null");
        }
    }

    private static void checkUrl(String url) {
        if (StringUtils.isBlank((CharSequence)url)) {
            throw new IllegalArgumentException("url should not be empty");
        }
        File pluginDirectory = new File(url);
        if (!pluginDirectory.exists()) {
            throw new RuntimeException(String.format("pluginDirectory '%s' is not exists", pluginDirectory));
        }
        if (!pluginDirectory.isDirectory()) {
            throw new RuntimeException(String.format("pluginDirectory '%s' should be directory", pluginDirectory));
        }
        if (!pluginDirectory.canRead()) {
            throw new RuntimeException(String.format("pluginDirectory '%s' is not readable", pluginDirectory));
        }
    }
}

