/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.core.plugin;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.inlong.manager.common.plugin.Plugin;
import org.apache.inlong.manager.common.plugin.PluginBinder;
import org.apache.inlong.manager.common.plugin.PluginDefinition;
import org.apache.inlong.manager.service.core.plugin.PluginClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PluginService {
    private static final Logger log = LoggerFactory.getLogger(PluginService.class);
    public static final String DEFAULT_PLUGIN_LOC = "/plugins";
    @Value(value="${plugin.location?:''}")
    private String pluginLoc;
    @Autowired
    private List<PluginBinder> pluginBinders;
    private final List<Plugin> plugins = new ArrayList<Plugin>();

    public PluginService() {
        if (StringUtils.isBlank((String)this.pluginLoc)) {
            this.pluginLoc = DEFAULT_PLUGIN_LOC;
        }
        this.pluginReload();
    }

    public void pluginReload() {
        Path path = Paths.get(this.pluginLoc, new String[0]).toAbsolutePath();
        log.info("search for plugin in {}", (Object)this.pluginLoc);
        if (!path.toFile().exists()) {
            log.warn("plugin directory not found");
            return;
        }
        PluginClassLoader pluginLoader = PluginClassLoader.getFromPluginUrl(path.toString(), Thread.currentThread().getContextClassLoader());
        Map<String, PluginDefinition> pluginDefinitions = pluginLoader.getPluginDefinitions();
        if (MapUtils.isEmpty(pluginDefinitions)) {
            log.warn("pluginDefinition not found in {}", (Object)this.pluginLoc);
            return;
        }
        ArrayList<Plugin> plugins = new ArrayList<Plugin>();
        for (PluginDefinition pluginDefinition : pluginDefinitions.values()) {
            String pluginClassName = pluginDefinition.getPluginClass();
            try {
                Class<?> pluginClass = pluginLoader.loadClass(pluginClassName);
                Object plugin = pluginClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                plugins.add((Plugin)plugin);
            }
            catch (Throwable e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        this.plugins.addAll(plugins);
        for (PluginBinder pluginBinder : this.pluginBinders) {
            for (Plugin plugin : plugins) {
                pluginBinder.acceptPlugin(plugin);
            }
        }
    }

    public void setPluginLoc(String pluginLoc) {
        this.pluginLoc = pluginLoc;
    }

    public String getPluginLoc() {
        return this.pluginLoc;
    }

    public List<PluginBinder> getPluginBinders() {
        return this.pluginBinders;
    }

    public List<Plugin> getPlugins() {
        return this.plugins;
    }
}

