/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.thirdpart.elasticsearch;

import java.io.IOException;
import org.apache.inlong.manager.service.thirdpart.elasticsearch.ElasticsearchConfig;
import org.elasticsearch.action.admin.indices.get.GetIndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ElasticsearchApi {
    private static final Logger LOG = LoggerFactory.getLogger(ElasticsearchApi.class);
    @Autowired
    private ElasticsearchConfig esConfig;

    public SearchResponse search(SearchRequest searchRequest) throws IOException {
        return this.search(searchRequest, RequestOptions.DEFAULT);
    }

    public SearchResponse search(SearchRequest searchRequest, RequestOptions options) throws IOException {
        LOG.info("get es search request of {}", (Object)searchRequest.source().toString());
        return this.getEsClient().search(searchRequest, options);
    }

    public boolean indexExists(String indexName) throws IOException {
        GetIndexRequest getIndexRequest = new GetIndexRequest();
        getIndexRequest.indices(new String[]{indexName});
        return this.getEsClient().indices().exists(getIndexRequest, RequestOptions.DEFAULT);
    }

    private RestHighLevelClient getEsClient() {
        return this.esConfig.highLevelClient();
    }
}

