/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.thirdpart.hive;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.event.EventSelector;
import org.apache.inlong.manager.common.model.WorkflowContext;
import org.apache.inlong.manager.common.model.definition.ProcessForm;
import org.apache.inlong.manager.dao.entity.DataStreamEntity;
import org.apache.inlong.manager.dao.mapper.DataStreamEntityMapper;
import org.apache.inlong.manager.service.core.StorageService;
import org.apache.inlong.manager.service.workflow.business.BusinessResourceWorkflowForm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CreateHiveTableEventSelector
implements EventSelector {
    private static final Logger log = LoggerFactory.getLogger(CreateHiveTableEventSelector.class);
    @Autowired
    private StorageService storageService;
    @Autowired
    private DataStreamEntityMapper streamMapper;

    public boolean accept(WorkflowContext context) {
        ProcessForm processForm = context.getProcessForm();
        if (processForm == null || !(processForm instanceof BusinessResourceWorkflowForm)) {
            return false;
        }
        BusinessResourceWorkflowForm form = (BusinessResourceWorkflowForm)processForm;
        if (form.getBusinessInfo() == null || StringUtils.isEmpty((CharSequence)form.getBusinessInfo().getInlongGroupId())) {
            return false;
        }
        String groupId = form.getInlongGroupId();
        List<String> dsForHive = this.storageService.filterStreamIdByStorageType(groupId, "HIVE", this.streamMapper.selectByGroupId(groupId).stream().map(DataStreamEntity::getInlongStreamId).collect(Collectors.toList()));
        if (CollectionUtils.isEmpty(dsForHive)) {
            log.warn("groupId={} streamId={} does not have storage, skip to create hive table ", (Object)groupId, (Object)form.getInlongStreamId());
            return true;
        }
        return false;
    }
}

