/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.thirdpart.hive;

import java.util.List;
import org.apache.inlong.manager.common.event.ListenerResult;
import org.apache.inlong.manager.common.event.task.StorageOperateListener;
import org.apache.inlong.manager.common.event.task.TaskEvent;
import org.apache.inlong.manager.common.model.WorkflowContext;
import org.apache.inlong.manager.dao.mapper.StorageHiveEntityMapper;
import org.apache.inlong.manager.service.thirdpart.hive.HiveTableOperator;
import org.apache.inlong.manager.service.workflow.business.BusinessResourceWorkflowForm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CreateHiveTableForStreamListener
implements StorageOperateListener {
    private static final Logger log = LoggerFactory.getLogger(CreateHiveTableForStreamListener.class);
    @Autowired
    private StorageHiveEntityMapper hiveEntityMapper;
    @Autowired
    private HiveTableOperator hiveTableOperator;

    public TaskEvent event() {
        return TaskEvent.COMPLETE;
    }

    public ListenerResult listen(WorkflowContext context) {
        BusinessResourceWorkflowForm form = (BusinessResourceWorkflowForm)context.getProcessForm();
        String groupId = form.getInlongGroupId();
        String streamId = form.getInlongStreamId();
        log.info("begin create hive table for groupId={}, streamId={}", (Object)groupId, (Object)streamId);
        List configList = this.hiveEntityMapper.selectAllHiveConfig(groupId, streamId);
        this.hiveTableOperator.createHiveResource(groupId, configList);
        String result = "success to create hive table for group [" + groupId + "], stream [" + streamId + "]";
        log.info(result);
        return ListenerResult.success((String)result);
    }

    public boolean async() {
        return false;
    }
}

