/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.thirdpart.hive;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.inlong.manager.common.enums.BizConstant;
import org.apache.inlong.manager.common.enums.EntityStatus;
import org.apache.inlong.manager.common.exceptions.WorkflowException;
import org.apache.inlong.manager.common.pojo.datastorage.StorageHiveDTO;
import org.apache.inlong.manager.common.pojo.query.ColumnInfoBean;
import org.apache.inlong.manager.common.pojo.query.DatabaseQueryBean;
import org.apache.inlong.manager.common.pojo.query.hive.HiveColumnQueryBean;
import org.apache.inlong.manager.common.pojo.query.hive.HiveTableQueryBean;
import org.apache.inlong.manager.dao.entity.StorageHiveFieldEntity;
import org.apache.inlong.manager.dao.mapper.StorageHiveFieldEntityMapper;
import org.apache.inlong.manager.service.core.DataSourceService;
import org.apache.inlong.manager.service.core.StorageService;
import org.apache.inlong.manager.service.core.impl.StorageHiveOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HiveTableOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(StorageHiveOperation.class);
    @Autowired
    private StorageService storageService;
    @Autowired
    private StorageHiveFieldEntityMapper hiveFieldMapper;
    @Autowired
    private DataSourceService<DatabaseQueryBean, HiveTableQueryBean> dataSourceService;

    public void createHiveResource(String groupId, List<StorageHiveDTO> configList) {
        if (CollectionUtils.isEmpty(configList)) {
            LOGGER.warn("no hive config, skip to create");
            return;
        }
        for (StorageHiveDTO config : configList) {
            if (EntityStatus.DATA_STORAGE_CONFIG_SUCCESSFUL.getCode().equals(config.getStatus())) {
                LOGGER.warn("hive [" + config.getId() + "] already success, skip to create");
                continue;
            }
            if (BizConstant.DISABLE_CREATE_TABLE.equals(config.getEnableCreateTable())) {
                LOGGER.warn("create table was disable, skip to create table for hive [" + config.getId() + "]");
                continue;
            }
            this.createTable(groupId, config);
        }
    }

    private void createTable(String groupId, StorageHiveDTO config) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("begin create hive table for business={}, config={}", (Object)groupId, (Object)config);
        }
        HiveTableQueryBean tableBean = this.getTableQueryBean(config);
        try {
            this.dataSourceService.createDb(tableBean);
            List<ColumnInfoBean> columns = this.dataSourceService.queryColumns(tableBean);
            if (columns.size() == 0) {
                this.dataSourceService.createTable(tableBean);
            } else {
                List columnsSkipHistory = tableBean.getColumns().stream().skip(columns.size()).collect(Collectors.toList());
                if (columnsSkipHistory.size() != 0) {
                    tableBean.setColumns(columnsSkipHistory);
                    this.dataSourceService.createColumn(tableBean);
                }
            }
            this.storageService.updateHiveStatusById(config.getId(), EntityStatus.DATA_STORAGE_CONFIG_SUCCESSFUL.getCode(), "create hive table success");
        }
        catch (Throwable e) {
            LOGGER.error("create hive table error, ", e);
            this.storageService.updateHiveStatusById(config.getId(), EntityStatus.DATA_STORAGE_CONFIG_FAILED.getCode(), e.getMessage());
            throw new WorkflowException("create hive table failed, reason: " + e.getMessage());
        }
        LOGGER.info("success create hive table for data group [" + groupId + "]");
    }

    protected HiveTableQueryBean getTableQueryBean(StorageHiveDTO config) {
        String groupId = config.getInlongGroupId();
        String streamId = config.getInlongStreamId();
        LOGGER.info("begin to get table query bean for groupId={}, streamId={}", (Object)groupId, (Object)streamId);
        List fieldEntities = this.hiveFieldMapper.selectHiveFields(groupId, streamId);
        ArrayList<HiveColumnQueryBean> columnQueryBeans = new ArrayList<HiveColumnQueryBean>();
        for (StorageHiveFieldEntity field : fieldEntities) {
            HiveColumnQueryBean columnBean = new HiveColumnQueryBean();
            columnBean.setColumnName(field.getFieldName());
            columnBean.setColumnType(field.getFieldType());
            columnBean.setColumnDesc(field.getFieldComment());
            columnQueryBeans.add(columnBean);
        }
        String partitionField = config.getPrimaryPartition();
        if (partitionField != null) {
            HiveColumnQueryBean partColumn = new HiveColumnQueryBean();
            partColumn.setPartition(true);
            partColumn.setColumnName(partitionField);
            partColumn.setColumnType("string");
            columnQueryBeans.add(partColumn);
        }
        HiveTableQueryBean queryBean = new HiveTableQueryBean();
        queryBean.setColumns(columnQueryBeans);
        if (config.getTargetSeparator() != null) {
            char ch = (char)Integer.parseInt(config.getTargetSeparator());
            queryBean.setFieldTerSymbol(String.valueOf(ch));
        }
        queryBean.setUsername(config.getUsername());
        queryBean.setPassword(config.getPassword());
        queryBean.setTableName(config.getTableName());
        queryBean.setDbName(config.getDbName());
        queryBean.setJdbcUrl(config.getJdbcUrl());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("success to get table query bean={}", (Object)queryBean);
        }
        return queryBean;
    }
}

