/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.thirdpart.mq;

import java.util.List;
import org.apache.inlong.manager.common.beans.ClusterBean;
import org.apache.inlong.manager.common.event.ListenerResult;
import org.apache.inlong.manager.common.event.task.QueueOperateListener;
import org.apache.inlong.manager.common.event.task.TaskEvent;
import org.apache.inlong.manager.common.exceptions.WorkflowListenerException;
import org.apache.inlong.manager.common.model.WorkflowContext;
import org.apache.inlong.manager.common.pojo.business.BusinessInfo;
import org.apache.inlong.manager.common.pojo.datastream.DataStreamTopicVO;
import org.apache.inlong.manager.common.pojo.pulsar.PulsarTopicBean;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.BusinessPulsarEntity;
import org.apache.inlong.manager.dao.mapper.BusinessPulsarEntityMapper;
import org.apache.inlong.manager.dao.mapper.DataStreamEntityMapper;
import org.apache.inlong.manager.service.core.BusinessService;
import org.apache.inlong.manager.service.thirdpart.mq.PulsarOptService;
import org.apache.inlong.manager.service.thirdpart.mq.util.PulsarUtils;
import org.apache.inlong.manager.service.workflow.business.BusinessResourceWorkflowForm;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CreatePulsarResourceTaskListener
implements QueueOperateListener {
    private static final Logger log = LoggerFactory.getLogger(CreatePulsarResourceTaskListener.class);
    @Autowired
    PulsarOptService pulsarOptService;
    @Autowired
    private ClusterBean clusterBean;
    @Autowired
    private BusinessService businessService;
    @Autowired
    private BusinessPulsarEntityMapper businessPulsarMapper;
    @Autowired
    private DataStreamEntityMapper dataStreamMapper;

    public TaskEvent event() {
        return TaskEvent.COMPLETE;
    }

    public ListenerResult listen(WorkflowContext context) throws WorkflowListenerException {
        BusinessResourceWorkflowForm form = (BusinessResourceWorkflowForm)context.getProcessForm();
        String groupId = form.getInlongGroupId();
        log.info("begin to create pulsar resource for groupId={}", (Object)groupId);
        BusinessInfo businessInfo = this.businessService.get(groupId);
        if (businessInfo == null) {
            throw new WorkflowListenerException("business or pulsar cluster not found for groupId=" + groupId);
        }
        try (PulsarAdmin globalPulsarAdmin = PulsarUtils.getPulsarAdmin(businessInfo, this.clusterBean.getPulsarAdminUrl());){
            List<String> pulsarClusters = PulsarUtils.getPulsarClusters(globalPulsarAdmin);
            for (String cluster : pulsarClusters) {
                String serviceUrl = PulsarUtils.getServiceUrl(globalPulsarAdmin, cluster);
                this.createPulsarProcess(businessInfo, serviceUrl);
            }
        }
        catch (Exception e) {
            log.error("create pulsar resource error for groupId={}", (Object)groupId, (Object)e);
            throw new WorkflowListenerException("create pulsar resource error for groupId=" + groupId);
        }
        log.info("success to create pulsar resource for groupId={}", (Object)groupId);
        return ListenerResult.success();
    }

    private void createPulsarProcess(BusinessInfo businessInfo, String serviceHttpUrl) throws Exception {
        String groupId = businessInfo.getInlongGroupId();
        log.info("begin to create pulsar resource for groupId={} in cluster={}", (Object)groupId, (Object)serviceHttpUrl);
        String namespace = businessInfo.getMqResourceObj();
        Preconditions.checkNotNull((Object)namespace, (String)("pulsar namespace cannot be empty for groupId=" + groupId));
        String queueModule = businessInfo.getQueueModule();
        Preconditions.checkNotNull((Object)queueModule, (String)("queue module cannot be empty for groupId=" + groupId));
        String tenant = this.clusterBean.getDefaultTenant();
        try (PulsarAdmin pulsarAdmin = PulsarUtils.getPulsarAdmin(businessInfo, serviceHttpUrl);){
            this.pulsarOptService.createTenant(pulsarAdmin, tenant);
            BusinessPulsarEntity entity = this.businessPulsarMapper.selectByGroupId(groupId);
            this.pulsarOptService.createNamespace(pulsarAdmin, entity, tenant, namespace);
            Integer partitionNum = businessInfo.getTopicPartitionNum();
            List streamTopicList = this.dataStreamMapper.selectTopicList(groupId);
            PulsarTopicBean topicBean = PulsarTopicBean.builder().tenant(tenant).namespace(namespace).numPartitions(partitionNum).queueModule(queueModule).build();
            for (DataStreamTopicVO topicVO : streamTopicList) {
                topicBean.setTopicName(topicVO.getMqResourceObj());
                this.pulsarOptService.createTopic(pulsarAdmin, topicBean);
            }
        }
        log.info("finish to create pulsar resource for groupId={}, service http url={}", (Object)groupId, (Object)serviceHttpUrl);
    }

    public boolean async() {
        return false;
    }
}

