/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.thirdpart.mq;

import java.util.List;
import org.apache.inlong.manager.common.beans.ClusterBean;
import org.apache.inlong.manager.common.event.ListenerResult;
import org.apache.inlong.manager.common.event.task.QueueOperateListener;
import org.apache.inlong.manager.common.event.task.TaskEvent;
import org.apache.inlong.manager.common.exceptions.WorkflowListenerException;
import org.apache.inlong.manager.common.model.WorkflowContext;
import org.apache.inlong.manager.common.pojo.business.BusinessInfo;
import org.apache.inlong.manager.common.pojo.pulsar.PulsarTopicBean;
import org.apache.inlong.manager.dao.entity.DataStreamEntity;
import org.apache.inlong.manager.dao.mapper.DataStreamEntityMapper;
import org.apache.inlong.manager.service.core.BusinessService;
import org.apache.inlong.manager.service.thirdpart.mq.PulsarOptService;
import org.apache.inlong.manager.service.thirdpart.mq.util.PulsarUtils;
import org.apache.inlong.manager.service.workflow.business.BusinessResourceWorkflowForm;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CreatePulsarTopicForStreamTaskListener
implements QueueOperateListener {
    private static final Logger log = LoggerFactory.getLogger(CreatePulsarTopicForStreamTaskListener.class);
    @Autowired
    private ClusterBean clusterBean;
    @Autowired
    private PulsarOptService pulsarOptService;
    @Autowired
    private BusinessService businessService;
    @Autowired
    private DataStreamEntityMapper dataStreamMapper;

    public TaskEvent event() {
        return TaskEvent.COMPLETE;
    }

    public ListenerResult listen(WorkflowContext context) throws WorkflowListenerException {
        BusinessResourceWorkflowForm form = (BusinessResourceWorkflowForm)context.getProcessForm();
        String groupId = form.getInlongGroupId();
        String streamId = form.getInlongStreamId();
        BusinessInfo businessInfo = this.businessService.get(groupId);
        DataStreamEntity streamEntity = this.dataStreamMapper.selectByIdentifier(groupId, streamId);
        if (businessInfo == null || streamEntity == null) {
            throw new WorkflowListenerException("business or data stream not found with groupId=" + groupId + ", streamId=" + streamId);
        }
        log.info("begin to create pulsar topic for groupId={}, streamId={}", (Object)groupId, (Object)streamId);
        try (PulsarAdmin globalPulsarAdmin = PulsarUtils.getPulsarAdmin(businessInfo, this.clusterBean.getPulsarAdminUrl());){
            List<String> pulsarClusters = PulsarUtils.getPulsarClusters(globalPulsarAdmin);
            for (String cluster : pulsarClusters) {
                String serviceUrl = PulsarUtils.getServiceUrl(globalPulsarAdmin, cluster);
                String pulsarTopic = streamEntity.getMqResourceObj();
                this.createTopicOpt(businessInfo, pulsarTopic, serviceUrl);
            }
        }
        catch (Exception e) {
            log.error("create pulsar topic error for groupId={}, streamId={}", new Object[]{groupId, streamId, e});
            throw new WorkflowListenerException("create pulsar topic error for groupId=" + groupId + ", streamId=" + streamId);
        }
        log.info("success to create pulsar topic for groupId={}, streamId={}", (Object)groupId, (Object)streamId);
        return ListenerResult.success();
    }

    private void createTopicOpt(BusinessInfo bizInfo, String pulsarTopic, String serviceHttpUrl) throws Exception {
        Integer partitionNum = bizInfo.getTopicPartitionNum();
        int partition = 0;
        if (partitionNum != null && partitionNum > 0) {
            partition = partitionNum;
        }
        try (PulsarAdmin pulsarAdmin = PulsarUtils.getPulsarAdmin(bizInfo, serviceHttpUrl);){
            PulsarTopicBean topicBean = PulsarTopicBean.builder().tenant(this.clusterBean.getDefaultTenant()).namespace(bizInfo.getMqResourceObj()).topicName(pulsarTopic).numPartitions(Integer.valueOf(partition)).queueModule(bizInfo.getQueueModule()).build();
            this.pulsarOptService.createTopic(pulsarAdmin, topicBean);
        }
    }

    public boolean async() {
        return false;
    }
}

