/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.thirdpart.mq.util;

import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.pojo.business.BusinessExtInfo;
import org.apache.inlong.manager.common.pojo.business.BusinessInfo;
import org.apache.inlong.manager.common.settings.BusinessSettings;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.AuthenticationFactory;
import org.apache.pulsar.client.api.PulsarClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarUtils {
    private static final Logger log = LoggerFactory.getLogger(PulsarUtils.class);

    private PulsarUtils() {
    }

    public static PulsarAdmin getPulsarAdmin(BusinessInfo businessInfo, String defaultServiceUrl) throws PulsarClientException {
        if (CollectionUtils.isEmpty((Collection)businessInfo.getExtList())) {
            return PulsarUtils.getPulsarAdmin(defaultServiceUrl);
        }
        List businessExtInfoList = businessInfo.getExtList();
        String pulsarServiceUrl = null;
        String pulsarAuthentication = null;
        String pulsarAuthenticationType = BusinessSettings.DEFAULT_PULSAR_AUTHENTICATION_TYPE;
        for (BusinessExtInfo extInfo : businessExtInfoList) {
            if (BusinessSettings.PULSAR_ADMIN_URL.equals(extInfo.getKeyName()) && StringUtils.isNotEmpty((CharSequence)extInfo.getKeyValue())) {
                pulsarServiceUrl = extInfo.getKeyValue();
            }
            if (BusinessSettings.PULSAR_AUTHENTICATION_TYPE.equals(extInfo.getKeyName()) && StringUtils.isNotEmpty((CharSequence)extInfo.getKeyValue())) {
                pulsarAuthenticationType = extInfo.getKeyValue();
            }
            if (!BusinessSettings.PULSAR_AUTHENTICATION.equals(extInfo.getKeyName()) || !StringUtils.isNotEmpty((CharSequence)extInfo.getKeyValue())) continue;
            pulsarAuthentication = extInfo.getKeyValue();
        }
        if (StringUtils.isEmpty(pulsarServiceUrl) && StringUtils.isEmpty(pulsarAuthentication)) {
            return PulsarUtils.getPulsarAdmin(defaultServiceUrl);
        }
        if (StringUtils.isEmpty(pulsarAuthentication)) {
            return PulsarUtils.getPulsarAdmin(pulsarServiceUrl);
        }
        return PulsarUtils.getPulsarAdmin(pulsarServiceUrl, pulsarAuthentication, pulsarAuthenticationType);
    }

    public static PulsarAdmin getPulsarAdmin(String serviceHttpUrl) throws PulsarClientException {
        return PulsarAdmin.builder().serviceHttpUrl(serviceHttpUrl).build();
    }

    public static PulsarAdmin getPulsarAdmin(String serviceHttpUrl, String authentication, String authenticationType) throws PulsarClientException {
        if (BusinessSettings.DEFAULT_PULSAR_AUTHENTICATION_TYPE.equals(authenticationType)) {
            return PulsarAdmin.builder().serviceHttpUrl(serviceHttpUrl).authentication(AuthenticationFactory.token((String)authentication)).build();
        }
        throw new IllegalArgumentException(String.format("illegal authentication type for pulsar : %s", authenticationType));
    }

    public static List<String> getPulsarClusters(PulsarAdmin pulsarAdmin) throws PulsarAdminException {
        return pulsarAdmin.clusters().getClusters();
    }

    public static String getServiceUrl(PulsarAdmin pulsarAdmin, String pulsarCluster) throws PulsarAdminException {
        return pulsarAdmin.clusters().getCluster(pulsarCluster).getServiceUrl();
    }
}

