/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.workflow;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.commons.collections.MapUtils;
import org.apache.inlong.manager.common.event.EventSelector;
import org.apache.inlong.manager.common.event.task.DataSourceOperateListener;
import org.apache.inlong.manager.common.event.task.QueueOperateListener;
import org.apache.inlong.manager.common.event.task.SortOperateListener;
import org.apache.inlong.manager.common.event.task.StorageOperateListener;
import org.apache.inlong.manager.common.event.task.TaskEventListener;
import org.apache.inlong.manager.common.model.WorkflowContext;
import org.apache.inlong.manager.common.model.definition.ServiceTaskListenerProvider;
import org.apache.inlong.manager.common.model.definition.ServiceTaskType;
import org.apache.inlong.manager.common.plugin.Plugin;
import org.apache.inlong.manager.common.plugin.PluginBinder;
import org.apache.inlong.manager.common.plugin.ProcessPlugin;
import org.apache.inlong.manager.service.thirdpart.hive.CreateHiveTableEventSelector;
import org.apache.inlong.manager.service.thirdpart.hive.CreateHiveTableListener;
import org.apache.inlong.manager.service.thirdpart.mq.CreatePulsarGroupTaskListener;
import org.apache.inlong.manager.service.thirdpart.mq.CreatePulsarResourceTaskListener;
import org.apache.inlong.manager.service.thirdpart.mq.CreateTubeGroupTaskListener;
import org.apache.inlong.manager.service.thirdpart.mq.CreateTubeTopicTaskListener;
import org.apache.inlong.manager.service.thirdpart.mq.PulsarEventSelector;
import org.apache.inlong.manager.service.thirdpart.mq.TubeEventSelector;
import org.apache.inlong.manager.service.thirdpart.sort.PushHiveConfigTaskListener;
import org.apache.inlong.manager.service.thirdpart.sort.ZkSortEventSelector;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ServiceTaskListenerFactory
implements PluginBinder,
ServiceTaskListenerProvider {
    private Map<DataSourceOperateListener, EventSelector> sourceOperateListeners;
    private Map<StorageOperateListener, EventSelector> storageOperateListeners;
    private Map<QueueOperateListener, EventSelector> queueOperateListeners;
    private Map<SortOperateListener, EventSelector> sortOperateListeners;
    @Autowired
    private CreateTubeTopicTaskListener createTubeTopicTaskListener;
    @Autowired
    private CreateTubeGroupTaskListener createTubeGroupTaskListener;
    @Autowired
    private CreatePulsarResourceTaskListener createPulsarResourceTaskListener;
    @Autowired
    private CreatePulsarGroupTaskListener createPulsarGroupTaskListener;
    @Autowired
    private CreateHiveTableListener createHiveTableListener;
    @Autowired
    private CreateHiveTableEventSelector createHiveTableEventSelector;
    @Autowired
    private PushHiveConfigTaskListener pushHiveConfigTaskListener;
    @Autowired
    private ZkSortEventSelector zkSortEventSelector;

    @PostConstruct
    public void init() {
        this.sourceOperateListeners = new LinkedHashMap<DataSourceOperateListener, EventSelector>();
        this.storageOperateListeners = new LinkedHashMap<StorageOperateListener, EventSelector>();
        this.storageOperateListeners.put(this.createHiveTableListener, this.createHiveTableEventSelector);
        this.queueOperateListeners = new LinkedHashMap<QueueOperateListener, EventSelector>();
        this.queueOperateListeners.put(this.createTubeTopicTaskListener, new TubeEventSelector());
        this.queueOperateListeners.put(this.createTubeGroupTaskListener, new TubeEventSelector());
        this.queueOperateListeners.put(this.createPulsarResourceTaskListener, new PulsarEventSelector());
        this.queueOperateListeners.put(this.createPulsarGroupTaskListener, new PulsarEventSelector());
        this.sortOperateListeners = new LinkedHashMap<SortOperateListener, EventSelector>();
        this.sortOperateListeners.put(this.pushHiveConfigTaskListener, this.zkSortEventSelector);
    }

    public void clearListeners() {
        this.sourceOperateListeners = new LinkedHashMap<DataSourceOperateListener, EventSelector>();
        this.storageOperateListeners = new LinkedHashMap<StorageOperateListener, EventSelector>();
        this.queueOperateListeners = new LinkedHashMap<QueueOperateListener, EventSelector>();
        this.sortOperateListeners = new LinkedHashMap<SortOperateListener, EventSelector>();
    }

    public List<TaskEventListener> get(WorkflowContext workflowContext, ServiceTaskType serviceTaskType) {
        switch (serviceTaskType) {
            case INIT_MQ: {
                List<QueueOperateListener> queueOperateListeners = this.getQueueOperateListener(workflowContext);
                return Lists.newArrayList(queueOperateListeners);
            }
            case INIT_SORT: {
                List<SortOperateListener> sortOperateListeners = this.getSortOperateListener(workflowContext);
                return Lists.newArrayList(sortOperateListeners);
            }
            case INIT_SOURCE: {
                List<DataSourceOperateListener> sourceOperateListeners = this.getSourceOperateListener(workflowContext);
                return Lists.newArrayList(sourceOperateListeners);
            }
            case INIT_STORAGE: {
                List<StorageOperateListener> storageOperateListeners = this.getStorageOperateListener(workflowContext);
                return Lists.newArrayList(storageOperateListeners);
            }
        }
        throw new IllegalArgumentException(String.format("UnSupport ServiceTaskType %s", serviceTaskType));
    }

    public List<DataSourceOperateListener> getSourceOperateListener(WorkflowContext context) {
        ArrayList<DataSourceOperateListener> listeners = new ArrayList<DataSourceOperateListener>();
        for (Map.Entry<DataSourceOperateListener, EventSelector> entry : this.sourceOperateListeners.entrySet()) {
            EventSelector selector = entry.getValue();
            if (selector == null || !selector.accept(context)) continue;
            listeners.add(entry.getKey());
        }
        return listeners;
    }

    public List<StorageOperateListener> getStorageOperateListener(WorkflowContext context) {
        ArrayList<StorageOperateListener> listeners = new ArrayList<StorageOperateListener>();
        for (Map.Entry<StorageOperateListener, EventSelector> entry : this.storageOperateListeners.entrySet()) {
            EventSelector selector = entry.getValue();
            if (selector == null || !selector.accept(context)) continue;
            listeners.add(entry.getKey());
        }
        return listeners;
    }

    public List<QueueOperateListener> getQueueOperateListener(WorkflowContext context) {
        ArrayList<QueueOperateListener> listeners = new ArrayList<QueueOperateListener>();
        for (Map.Entry<QueueOperateListener, EventSelector> entry : this.queueOperateListeners.entrySet()) {
            EventSelector selector = entry.getValue();
            if (selector == null || !selector.accept(context)) continue;
            listeners.add(entry.getKey());
        }
        return listeners;
    }

    public List<SortOperateListener> getSortOperateListener(WorkflowContext context) {
        ArrayList<SortOperateListener> listeners = new ArrayList<SortOperateListener>();
        for (Map.Entry<SortOperateListener, EventSelector> entry : this.sortOperateListeners.entrySet()) {
            EventSelector selector = entry.getValue();
            if (selector == null || !selector.accept(context)) continue;
            listeners.add(entry.getKey());
        }
        return listeners;
    }

    public void acceptPlugin(Plugin plugin) {
        Map pluginSortOperateListeners;
        Map pluginQueueOperateListeners;
        Map pluginStorageOperateListeners;
        if (!(plugin instanceof ProcessPlugin)) {
            return;
        }
        ProcessPlugin processPlugin = (ProcessPlugin)plugin;
        Map pluginDsOperateListeners = processPlugin.createSourceOperateListeners();
        if (MapUtils.isNotEmpty((Map)pluginDsOperateListeners)) {
            this.sourceOperateListeners.putAll(processPlugin.createSourceOperateListeners());
        }
        if (MapUtils.isNotEmpty((Map)(pluginStorageOperateListeners = processPlugin.createStorageOperateListeners()))) {
            this.storageOperateListeners.putAll(pluginStorageOperateListeners);
        }
        if (MapUtils.isNotEmpty((Map)(pluginQueueOperateListeners = processPlugin.createQueueOperateListeners()))) {
            this.queueOperateListeners.putAll(pluginQueueOperateListeners);
        }
        if (MapUtils.isNotEmpty((Map)(pluginSortOperateListeners = processPlugin.createSortOperateListeners()))) {
            this.sortOperateListeners.putAll(pluginSortOperateListeners);
        }
    }

    public void setCreateTubeTopicTaskListener(CreateTubeTopicTaskListener createTubeTopicTaskListener) {
        this.createTubeTopicTaskListener = createTubeTopicTaskListener;
    }

    public void setCreateTubeGroupTaskListener(CreateTubeGroupTaskListener createTubeGroupTaskListener) {
        this.createTubeGroupTaskListener = createTubeGroupTaskListener;
    }

    public void setCreatePulsarResourceTaskListener(CreatePulsarResourceTaskListener createPulsarResourceTaskListener) {
        this.createPulsarResourceTaskListener = createPulsarResourceTaskListener;
    }

    public void setCreatePulsarGroupTaskListener(CreatePulsarGroupTaskListener createPulsarGroupTaskListener) {
        this.createPulsarGroupTaskListener = createPulsarGroupTaskListener;
    }

    public void setCreateHiveTableListener(CreateHiveTableListener createHiveTableListener) {
        this.createHiveTableListener = createHiveTableListener;
    }

    public void setPushHiveConfigTaskListener(PushHiveConfigTaskListener pushHiveConfigTaskListener) {
        this.pushHiveConfigTaskListener = pushHiveConfigTaskListener;
    }
}

