/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.workflow;

import org.apache.inlong.manager.common.dao.EventLogStorage;
import org.apache.inlong.manager.common.dao.ProcessInstanceStorage;
import org.apache.inlong.manager.common.dao.TaskInstanceStorage;
import org.apache.inlong.manager.common.model.WorkflowConfig;
import org.apache.inlong.manager.common.workflow.EventListenerService;
import org.apache.inlong.manager.common.workflow.ProcessDefinitionService;
import org.apache.inlong.manager.common.workflow.ProcessDefinitionStorage;
import org.apache.inlong.manager.common.workflow.QueryService;
import org.apache.inlong.manager.common.workflow.WorkflowDataAccessor;
import org.apache.inlong.manager.common.workflow.WorkflowEngine;
import org.apache.inlong.manager.workflow.core.impl.MemoryProcessDefinitionStorage;
import org.apache.inlong.manager.workflow.core.impl.WorkflowDataAccessorImpl;
import org.apache.inlong.manager.workflow.core.impl.WorkflowEngineImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;

@Component
@Configuration
public class WorkflowEngineConfig {
    @Autowired
    private ProcessInstanceStorage processInstanceStorage;
    @Autowired
    private TaskInstanceStorage taskInstanceStorage;
    @Autowired
    private EventLogStorage eventLogStorage;
    @Autowired
    private PlatformTransactionManager platformTransactionManager;

    @Bean
    public WorkflowDataAccessor workflowDataAccessor() {
        return new WorkflowDataAccessorImpl((ProcessDefinitionStorage)new MemoryProcessDefinitionStorage(), this.processInstanceStorage, this.taskInstanceStorage, this.eventLogStorage);
    }

    @Bean
    public WorkflowEngine workflowEngineer() {
        WorkflowConfig workFlowConfig = new WorkflowConfig().setWorkflowDataAccessor(this.workflowDataAccessor()).setPlatformTransactionManager(this.platformTransactionManager);
        return new WorkflowEngineImpl(workFlowConfig);
    }

    @Bean
    public QueryService queryService(WorkflowEngine workflowEngine) {
        return workflowEngine.queryService();
    }

    @Bean
    public EventListenerService eventListenerService(WorkflowEngine workflowEngine) {
        return workflowEngine.eventListenerService();
    }

    @Bean
    public ProcessDefinitionService processDefinitionService(WorkflowEngine workflowEngine) {
        return workflowEngine.processDefinitionService();
    }
}

