/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.workflow;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.inlong.manager.common.model.WorkflowContext;
import org.apache.inlong.manager.common.model.instance.ProcessInstance;
import org.apache.inlong.manager.common.model.view.ProcessView;
import org.apache.inlong.manager.common.model.view.TaskView;

@ApiModel(value="Workflow interface response interface")
public class WorkflowResult {
    @ApiModelProperty(value="Application form information")
    private ProcessView processInfo;
    @ApiModelProperty(value="Newly generated tasks")
    private List<TaskView> newTasks;

    public static WorkflowResult of(WorkflowContext context) {
        if (context == null) {
            return null;
        }
        WorkflowResult workflowResult = new WorkflowResult();
        workflowResult.setProcessInfo(ProcessView.fromProcessInstance((ProcessInstance)context.getProcessInstance()));
        workflowResult.setNewTasks(context.getNewTaskInstances().stream().map(TaskView::fromTaskInstance).collect(Collectors.toList()));
        return workflowResult;
    }

    public ProcessView getProcessInfo() {
        return this.processInfo;
    }

    public List<TaskView> getNewTasks() {
        return this.newTasks;
    }

    public void setProcessInfo(ProcessView processInfo) {
        this.processInfo = processInfo;
    }

    public void setNewTasks(List<TaskView> newTasks) {
        this.newTasks = newTasks;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WorkflowResult)) {
            return false;
        }
        WorkflowResult other = (WorkflowResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ProcessView this$processInfo = this.getProcessInfo();
        ProcessView other$processInfo = other.getProcessInfo();
        if (this$processInfo == null ? other$processInfo != null : !this$processInfo.equals(other$processInfo)) {
            return false;
        }
        List<TaskView> this$newTasks = this.getNewTasks();
        List<TaskView> other$newTasks = other.getNewTasks();
        return !(this$newTasks == null ? other$newTasks != null : !((Object)this$newTasks).equals(other$newTasks));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WorkflowResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ProcessView $processInfo = this.getProcessInfo();
        result = result * 59 + ($processInfo == null ? 43 : $processInfo.hashCode());
        List<TaskView> $newTasks = this.getNewTasks();
        result = result * 59 + ($newTasks == null ? 43 : ((Object)$newTasks).hashCode());
        return result;
    }

    public String toString() {
        return "WorkflowResult(processInfo=" + this.getProcessInfo() + ", newTasks=" + this.getNewTasks() + ")";
    }
}

