/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.workflow.business;

import org.apache.inlong.manager.common.event.process.ProcessEventListener;
import org.apache.inlong.manager.common.model.definition.Element;
import org.apache.inlong.manager.common.model.definition.EndEvent;
import org.apache.inlong.manager.common.model.definition.Process;
import org.apache.inlong.manager.common.model.definition.ServiceTask;
import org.apache.inlong.manager.common.model.definition.ServiceTaskListenerProvider;
import org.apache.inlong.manager.common.model.definition.ServiceTaskType;
import org.apache.inlong.manager.common.model.definition.StartEvent;
import org.apache.inlong.manager.common.model.definition.Task;
import org.apache.inlong.manager.service.workflow.ProcessName;
import org.apache.inlong.manager.service.workflow.ServiceTaskListenerFactory;
import org.apache.inlong.manager.service.workflow.WorkflowDefinition;
import org.apache.inlong.manager.service.workflow.business.BusinessResourceWorkflowForm;
import org.apache.inlong.manager.service.workflow.business.listener.BusinessCompleteProcessListener;
import org.apache.inlong.manager.service.workflow.business.listener.BusinessFailedProcessListener;
import org.apache.inlong.manager.service.workflow.business.listener.InitBusinessInfoListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CreateBusinessWorkflowDefinition
implements WorkflowDefinition {
    private static final Logger log = LoggerFactory.getLogger(CreateBusinessWorkflowDefinition.class);
    @Autowired
    private InitBusinessInfoListener initBusinessInfoListener;
    @Autowired
    private BusinessCompleteProcessListener businessCompleteProcessListener;
    @Autowired
    private BusinessFailedProcessListener businessFailedProcessListener;
    @Autowired
    private ServiceTaskListenerFactory serviceTaskListenerFactory;

    @Override
    public Process defineProcess() {
        Process process = new Process();
        process.addListener((ProcessEventListener)this.initBusinessInfoListener);
        process.addListener((ProcessEventListener)this.businessCompleteProcessListener);
        process.addListener((ProcessEventListener)this.businessFailedProcessListener);
        process.setType("Business Resource Creation");
        process.setName(this.getProcessName().name());
        process.setDisplayName(this.getProcessName().getDisplayName());
        process.setFormClass(BusinessResourceWorkflowForm.class);
        process.setVersion(1);
        process.setHidden(Boolean.valueOf(true));
        StartEvent startEvent = new StartEvent();
        process.setStartEvent(startEvent);
        ServiceTask initDataSourceTask = new ServiceTask();
        initDataSourceTask.setName("initDataSource");
        initDataSourceTask.setDisplayName("Business-InitDataSource");
        initDataSourceTask.addServiceTaskType(ServiceTaskType.INIT_SOURCE);
        initDataSourceTask.addListenerProvider((ServiceTaskListenerProvider)this.serviceTaskListenerFactory);
        process.addTask((Task)initDataSourceTask);
        ServiceTask initMQResourceTask = new ServiceTask();
        initMQResourceTask.setName("initMQ");
        initMQResourceTask.setDisplayName("Business-InitMQ");
        initMQResourceTask.addServiceTaskType(ServiceTaskType.INIT_MQ);
        initMQResourceTask.addListenerProvider((ServiceTaskListenerProvider)this.serviceTaskListenerFactory);
        process.addTask((Task)initMQResourceTask);
        ServiceTask initSortResourceTask = new ServiceTask();
        initSortResourceTask.setName("initSort");
        initSortResourceTask.setDisplayName("Business-InitSort");
        initSortResourceTask.addServiceTaskType(ServiceTaskType.INIT_SORT);
        initSortResourceTask.addListenerProvider((ServiceTaskListenerProvider)this.serviceTaskListenerFactory);
        process.addTask((Task)initSortResourceTask);
        ServiceTask initStorageTask = new ServiceTask();
        initStorageTask.setName("initStorage");
        initStorageTask.setDisplayName("Business-InitStorage");
        initStorageTask.addServiceTaskType(ServiceTaskType.INIT_STORAGE);
        initStorageTask.addListenerProvider((ServiceTaskListenerProvider)this.serviceTaskListenerFactory);
        process.addTask((Task)initStorageTask);
        EndEvent endEvent = new EndEvent();
        process.setEndEvent(endEvent);
        startEvent.addNext((Element)initDataSourceTask);
        initDataSourceTask.addNext((Element)initMQResourceTask);
        initMQResourceTask.addNext((Element)initSortResourceTask);
        initSortResourceTask.addNext((Element)initStorageTask);
        initStorageTask.addNext((Element)endEvent);
        return process;
    }

    @Override
    public ProcessName getProcessName() {
        return ProcessName.CREATE_BUSINESS_RESOURCE;
    }
}

